/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.ColumnManager;
import com.sapmarkets.bam.view.LogViewerMainFrame;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.component.DNDList;
import com.sapmarkets.bam.view.config.ColumnSettings;
import com.sapmarkets.bam.view.config.IViewConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColumnCustomizer
extends JDialog
implements ActionListener {
    private DNDList mAvailableValueList;
    private DNDList mCurrentValueList;
    private DefaultListModel mAvailableValueListModel;
    private DefaultListModel mCurrentValueListModel;
    private Object[] mLogTypes;
    private Map mSettings;
    private JComboBox mComboBox;
    private String mPreviousLogType;
    private LogDescriptor mFirstLD;
    private IViewConfiguration mViewConfiguration;
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$ColumnCustomizer == null ? (class$com$sapmarkets$bam$view$ColumnCustomizer = ColumnCustomizer.class$("com.sapmarkets.bam.view.ColumnCustomizer")) : class$com$sapmarkets$bam$view$ColumnCustomizer);
    private Frame mParent;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$ColumnCustomizer;

    public ColumnCustomizer(Frame parent, String title, IViewConfiguration viewConfiguration, String logType) {
        super(parent, title, true);
        this.mParent = parent;
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        } else {
            com.sap.engine.gui.LookAndFeelHandler.add((Component)this);
        }
        this.mViewConfiguration = viewConfiguration;
        this.mSettings = this.mViewConfiguration.getColumnSettings();
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel();
        JPanel midPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        topPanel.setLayout(new FlowLayout(0));
        JLabel lblType = new JLabel("Log Type:");
        topPanel.add(lblType);
        this.mLogTypes = this.getLogTypes();
        this.mComboBox = new JComboBox<Object>(this.mLogTypes);
        this.mComboBox.setSelectedItem(logType);
        this.mPreviousLogType = this.mComboBox.getSelectedItem().toString();
        this.mComboBox.addActionListener(this);
        this.mComboBox.setActionCommand("ComboBox");
        topPanel.add(this.mComboBox);
        topPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        ViewUtil.makeComponent(basePanel, topPanel, 0, 0, 1, 1, 0.0, 0.0);
        midPanel.setLayout(new GridBagLayout());
        this.mAvailableValueListModel = this.createAvailableListModel();
        this.mAvailableValueList = new DNDList();
        this.mAvailableValueList.setModel(this.mAvailableValueListModel);
        this.mAvailableValueList.setSelectionMode(2);
        this.mAvailableValueList.addListSelectionListener(new AvailableValueListListener());
        this.mAvailableValueList.setSelectedIndex(0);
        JScrollPane availableValueScrollPane = new JScrollPane(this.mAvailableValueList);
        availableValueScrollPane.setPreferredSize(new Dimension(250, 80));
        availableValueScrollPane.setMinimumSize(new Dimension(250, 80));
        JPanel availablePanel = new JPanel();
        availablePanel.setLayout(new BorderLayout());
        JLabel lblAvailable = new JLabel("Available columns:");
        availablePanel.add((Component)lblAvailable, "North");
        availablePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        availablePanel.add((Component)availableValueScrollPane, "Center");
        availablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(midPanel, availablePanel, 0, 0, 1, 1, 1.0, 1.0);
        this.mCurrentValueListModel = this.createCurrentListModel();
        this.mCurrentValueList = new DNDList();
        this.mCurrentValueList.setModel(this.mCurrentValueListModel);
        this.mCurrentValueList.setSelectionMode(2);
        this.mCurrentValueList.addListSelectionListener(new CurrentValueListListener());
        this.mCurrentValueList.setSelectedIndex(0);
        JScrollPane currentValueScrollPane = new JScrollPane(this.mCurrentValueList);
        currentValueScrollPane.setPreferredSize(new Dimension(250, 80));
        currentValueScrollPane.setMinimumSize(new Dimension(250, 80));
        JPanel currentPanel = new JPanel();
        currentPanel.setLayout(new BorderLayout());
        JLabel lblcurrent = new JLabel("Current displayed columns:");
        currentPanel.add((Component)lblcurrent, "North");
        currentPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        currentPanel.add((Component)currentValueScrollPane, "Center");
        currentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(midPanel, currentPanel, 2, 0, 1, 1, 1.0, 1.0);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton btnAdd = new JButton("Add->");
        btnAdd.addActionListener(this);
        btnAdd.setActionCommand("add");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1, 5, 5));
        panel.add(btnAdd);
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        ViewUtil.makeComponent(buttonPanel, panel, 0, 0, 1, 1, 0.0, 0.0);
        JButton btnRemove = new JButton("<-Remove");
        btnRemove.addActionListener(this);
        btnRemove.setActionCommand("remove");
        panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1, 5, 5));
        panel.add(btnRemove);
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        ViewUtil.makeComponent(buttonPanel, panel, 0, 1, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(midPanel, buttonPanel, 1, 0, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(basePanel, midPanel, 0, 1, 1, 1, 1.0, 1.0);
        bottomPanel = new JPanel(new FlowLayout(1));
        JButton ok = new JButton("Ok");
        ok.addActionListener(this);
        ok.registerKeyboardAction(new EscapeAction(), KeyStroke.getKeyStroke(79, 0, false), 2);
        ok.setActionCommand("ok");
        bottomPanel.add(ok);
        JButton reset = new JButton("Reset");
        reset.addActionListener(this);
        reset.setActionCommand("reset");
        bottomPanel.add(reset);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        cancel.registerKeyboardAction(new EscapeAction(), KeyStroke.getKeyStroke(67, 0, false), 2);
        cancel.setActionCommand("cancel");
        bottomPanel.add(cancel);
        ViewUtil.makeComponent(basePanel, bottomPanel, 0, 2, 1, 1, 0.0, 0.0);
        this.getContentPane().add(basePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ColumnCustomizer.this.adjustSize();
            }
        });
    }

    private void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("add".equals(actionCommand)) {
            int[] selectedIndices = this.mAvailableValueList.getSelectedIndices();
            int i = selectedIndices.length - 1;
            while (i >= 0) {
                Object availableValue = this.mAvailableValueListModel.getElementAt(selectedIndices[i]);
                this.mAvailableValueListModel.remove(selectedIndices[i]);
                this.mCurrentValueListModel.addElement(availableValue);
                --i;
            }
            if (!this.mAvailableValueListModel.isEmpty()) {
                this.mAvailableValueList.setSelectedIndex(0);
            }
            return;
        }
        if ("remove".equals(actionCommand)) {
            int[] selectedIndices = this.mCurrentValueList.getSelectedIndices();
            int i = selectedIndices.length - 1;
            while (i >= 0) {
                Object currentValue = this.mCurrentValueListModel.getElementAt(selectedIndices[i]);
                this.mCurrentValueListModel.remove(selectedIndices[i]);
                if (this.mCurrentValueListModel.isEmpty()) {
                    JOptionPane.showMessageDialog(this.mParent, "At least one column need to be displayed.");
                    this.mCurrentValueListModel.addElement(currentValue);
                } else {
                    this.mAvailableValueListModel.addElement(currentValue);
                }
                --i;
            }
            if (!this.mCurrentValueListModel.isEmpty()) {
                this.mCurrentValueList.setSelectedIndex(0);
            }
            return;
        }
        if ("reset".equals(actionCommand)) {
            this.mAvailableValueListModel = this.createAvailableListModel();
            this.mAvailableValueList.setModel(this.mAvailableValueListModel);
            this.mAvailableValueList.repaint();
            this.mAvailableValueList.setSelectedIndex(0);
            this.mCurrentValueListModel = this.createCurrentListModel();
            this.mCurrentValueList.setModel(this.mCurrentValueListModel);
            this.mCurrentValueList.repaint();
            this.mCurrentValueList.setSelectedIndex(0);
            return;
        }
        if ("ok".equals(actionCommand)) {
            this.saveSetting();
            ColumnManager.getInstance().fireColumnChanged(this.mSettings);
            this.hide();
            if (this.mParent instanceof LogViewerMainFrame) {
                ((LogViewerMainFrame)this.mParent).getLogViewerApplication().focusedTableChanged();
            }
            return;
        }
        if ("cancel".equals(actionCommand)) {
            ((Component)this).setVisible(false);
            return;
        }
        if ("ComboBox".equals(actionCommand)) {
            String logType = this.mComboBox.getSelectedItem().toString();
            if (this.mPreviousLogType.equals(logType)) {
                return;
            }
            HashMap<String, ColumnSettings> settings = new HashMap<String, ColumnSettings>();
            Map savedColumns = (Map)this.mSettings.get(this.mPreviousLogType);
            int i = 0;
            while (i < this.mAvailableValueListModel.size()) {
                ColumnSettings availCol = (ColumnSettings)this.mAvailableValueListModel.get(i);
                availCol.setIsDefaultDisplay(false);
                settings.put(availCol.getID(), availCol);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.mCurrentValueListModel.size()) {
                ColumnSettings currentCol = (ColumnSettings)this.mCurrentValueListModel.get(i2);
                currentCol.setIsDefaultDisplay(true);
                settings.put(currentCol.getID(), currentCol);
                ++i2;
            }
            this.mSettings.put(this.mPreviousLogType, settings);
            this.resetAction();
            this.mPreviousLogType = logType;
        }
    }

    private void resetAction() {
        this.mAvailableValueListModel = this.createAvailableListModel();
        this.mAvailableValueList.setModel(this.mAvailableValueListModel);
        this.mAvailableValueList.repaint();
        this.mAvailableValueList.setSelectedIndex(0);
        this.mCurrentValueListModel = this.createCurrentListModel();
        this.mCurrentValueList.setModel(this.mCurrentValueListModel);
        this.mCurrentValueList.repaint();
        this.mCurrentValueList.setSelectedIndex(0);
    }

    private void saveSetting() {
        HashMap<String, ColumnSettings> settings = new HashMap<String, ColumnSettings>();
        Map savedColumns = (Map)this.mSettings.get(this.mPreviousLogType);
        int i = 0;
        while (i < this.mAvailableValueListModel.size()) {
            ColumnSettings availCol = (ColumnSettings)this.mAvailableValueListModel.get(i);
            availCol.setIsDefaultDisplay(false);
            settings.put(availCol.getID(), availCol);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.mCurrentValueListModel.size()) {
            ColumnSettings currentCol = (ColumnSettings)this.mCurrentValueListModel.get(i2);
            currentCol.setIsDefaultDisplay(true);
            settings.put(currentCol.getID(), currentCol);
            ++i2;
        }
        this.mSettings.put(this.mComboBox.getSelectedItem().toString(), settings);
        try {
            String home = System.getProperty("user.home");
            FileOutputStream fileOut = new FileOutputStream(home + "\\ColumnCustomizer.ser");
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.mSettings);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            mLogger.logException(e);
        }
        catch (IOException ex) {
            mLogger.logException(ex);
        }
    }

    private DefaultListModel createAvailableListModel() {
        DefaultListModel<ColumnSettings> model = new DefaultListModel<ColumnSettings>();
        String logType = this.mComboBox.getSelectedItem().toString();
        Map settings = null;
        if (this.mSettings != null) {
            settings = (Map)this.mSettings.get(logType);
        }
        if (settings != null) {
            Set valueSet = settings.entrySet();
            Iterator itr = valueSet.iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (((ColumnSettings)entry.getValue()).isDefaultDisplay()) continue;
                model.addElement((ColumnSettings)entry.getValue());
            }
        }
        return model;
    }

    private DefaultListModel createCurrentListModel() {
        DefaultListModel<ColumnSettings> model = new DefaultListModel<ColumnSettings>();
        String logType = this.mComboBox.getSelectedItem().toString();
        Map settings = null;
        if (this.mSettings != null) {
            settings = (Map)this.mSettings.get(logType);
        }
        if (settings != null) {
            Set valueSet = settings.entrySet();
            Iterator itr = valueSet.iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (!((ColumnSettings)entry.getValue()).isDefaultDisplay()) continue;
                model.addElement((ColumnSettings)entry.getValue());
            }
        }
        return model;
    }

    private Object[] getLogTypes() {
        return this.mSettings.keySet().toArray();
    }

    private void closeWindow() {
        ((Component)this).setVisible(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EscapeAction
    implements ActionListener {
        private EscapeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ColumnCustomizer.this.closeWindow();
        }
    }

    class LogTypeListListener
    implements ListSelectionListener {
        LogTypeListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }

    class CurrentValueListListener
    implements ListSelectionListener {
        CurrentValueListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }

    class AvailableValueListListener
    implements ListSelectionListener {
        AvailableValueListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }
}

