/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.application.Search;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpressionDescriptor;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.CreateExpressionException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.InputDialog;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.buffertable.LogTable;
import com.sapmarkets.bam.view.config.ColumnSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class ColumnContextMenuActionListener
implements ActionListener,
ItemListener {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$ColumnContextMenuActionListener == null ? (class$com$sapmarkets$bam$view$ColumnContextMenuActionListener = ColumnContextMenuActionListener.class$("com.sapmarkets.bam.view.ColumnContextMenuActionListener")) : class$com$sapmarkets$bam$view$ColumnContextMenuActionListener);
    LogTable mParentTable;
    InputDialog mInputDialog;
    private String[] mParameterTitleArray;
    private Object[] mParameterValueArray;
    private LogQueryExpression mLogQueryExpression;
    private String mColumnName;
    private int mMenuIndex;
    private JMenuItem mSource;
    private ContentPane mContentPane;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$ColumnContextMenuActionListener;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ColumnContextMenuActionListener(LogTable table, ContentPane contentpane) {
        this.mContentPane = contentpane;
        this.mParentTable = table;
    }

    public void actionPerformed(ActionEvent e) {
        this.mSource = (JMenuItem)e.getSource();
        String aMenuText = this.mSource.getText();
        String aCommandString = this.mSource.getActionCommand();
        StringTokenizer commandTokens = new StringTokenizer(aCommandString, "@@@");
        this.mColumnName = commandTokens.nextToken();
        String action = commandTokens.nextToken();
        String value = commandTokens.nextToken();
        if (action.equalsIgnoreCase("Copy")) {
            this.mParentTable.copyRows(value);
            return;
        }
        if (action.equalsIgnoreCase("Find logrecord")) {
            int selectedRow = this.mParentTable.getSelectedRow();
            LogRecord lr = this.mParentTable.getLogRecordAtRow(selectedRow);
            this.mContentPane.findLogRecord(lr);
        }
        ColumnSettings columnSetting = this.mParentTable.getColumnContextMenu().getColumnSetting();
        if (action.equalsIgnoreCase("Align ")) {
            if (columnSetting.getAlignment() == 0) {
                columnSetting.setAlignment(1);
            } else {
                columnSetting.setAlignment(0);
            }
            this.mParentTable.repaint();
            return;
        }
        try {
            MonitoredDataDefinition aMonitoredDataDefinition = columnSetting.getMonitoredDataDefinition();
            List aPossibleQueryExpressionList = aMonitoredDataDefinition.getPossibleQueryExpressionDescriptions();
            LogQueryExpressionDescriptor aLogQueryExpressionDescriptor = null;
            Iterator itr = aPossibleQueryExpressionList.iterator();
            while (itr.hasNext()) {
                LogQueryExpressionDescriptor lqed = (LogQueryExpressionDescriptor)itr.next();
                if (!lqed.getOperationDisplayName().equalsIgnoreCase(action)) continue;
                aLogQueryExpressionDescriptor = lqed;
                break;
            }
            if (aLogQueryExpressionDescriptor != null) {
                this.mLogQueryExpression = aLogQueryExpressionDescriptor.makeQueryExpression(aMonitoredDataDefinition);
                Collection aParameterList = this.mLogQueryExpression.getSearchParameters();
                if (aParameterList.size() > 0) {
                    this.mParameterTitleArray = new String[aParameterList.size()];
                    this.mParameterValueArray = new Object[aParameterList.size()];
                    Iterator iterator = aParameterList.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        ParameterDescriptor aParamDesc = (ParameterDescriptor)iterator.next();
                        this.mParameterTitleArray[i] = aParamDesc.getName();
                        this.mParameterValueArray[i] = aParamDesc.getType() == (class$java$lang$Boolean == null ? ColumnContextMenuActionListener.class$("java.lang.Boolean") : class$java$lang$Boolean) ? Boolean.FALSE : "";
                        ++i;
                    }
                    JFrame frame = (JFrame)ViewUtil.getOwnerFrame(this.mParentTable);
                    this.mInputDialog = new InputDialog((Frame)frame, aMenuText, this.mParameterTitleArray, this.mParameterValueArray);
                    this.mInputDialog.setLocationRelativeTo(frame);
                    this.mInputDialog.pack();
                    this.mInputDialog.addItemListener(this);
                    this.mInputDialog.addWindowListener(new DialogWinAdapter());
                    this.mInputDialog.show();
                }
            }
        }
        catch (CreateExpressionException ex) {
            ex.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object[] newVals = this.mInputDialog.getSelectedObjects();
        int i = 0;
        while (i < this.mParameterTitleArray.length) {
            ParameterDescriptor aParamDesc = this.mLogQueryExpression.getSearchParameter(this.mParameterTitleArray[i]);
            aParamDesc.setValue(newVals[i]);
            ++i;
        }
        FilterAndSearchHandler newFilterAndSearchHandler = new FilterAndSearchHandler(this.mParentTable.getFilterAndSearchHandler());
        Search search = new Search(this.mLogQueryExpression);
        newFilterAndSearchHandler.addAdditionalSearch(search);
        try {
            this.mContentPane.doSearch(this.mColumnName, newFilterAndSearchHandler);
        }
        catch (BAMAppException e1) {
            mLogger.logException((Throwable)((Object)e1));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DialogWinAdapter
    extends WindowAdapter {
        private DialogWinAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            ((Component)ColumnContextMenuActionListener.this.mInputDialog).setVisible(false);
        }
    }
}

