/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.queryexpr.LogQueryExpressionDescriptor;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.view.buffertable.LogTable;
import com.sapmarkets.bam.view.buffertable.TableRowSelectActionListener;
import com.sapmarkets.bam.view.config.ColumnSettings;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ColumnContextMenu
extends JPopupMenu {
    public static final String ALIGN = "Align ";
    private int mMenuCount;
    private ActionListener mContextMenuActionListener;
    private LogTable table;
    private ColumnSettings columnSetting = null;

    public ColumnContextMenu(ActionListener anActionListener, LogTable table) {
        this.mContextMenuActionListener = anActionListener;
        this.table = table;
    }

    public int getMenuCount() {
        return this.mMenuCount;
    }

    public void addMenu(String aMenuString, String aColumnName, String action, String columnValue, ActionListener actionListener) {
        JMenuItem aMenuItem = this.add(aMenuString + " " + aColumnName);
        aMenuItem.setActionCommand(aColumnName + "@@@" + action + "@@@" + columnValue);
        aMenuItem.addActionListener(actionListener);
        ++this.mMenuCount;
    }

    public void removeMenu(int anIndex) {
        this.remove(anIndex);
        --this.mMenuCount;
    }

    public void createMenuForColumn(ColumnSettings columnSetting, String columnValue) {
        this.removeAll();
        this.columnSetting = columnSetting;
        List aPossibleQueryExpressionList = columnSetting.getMonitoredDataDefinition().getPossibleQueryExpressionDescriptions();
        Iterator iterator = aPossibleQueryExpressionList.iterator();
        while (iterator.hasNext()) {
            LogQueryExpressionDescriptor aLogQueryExpressionDescriptor = (LogQueryExpressionDescriptor)iterator.next();
            this.addMenu(aLogQueryExpressionDescriptor.getOperationDisplayName(), columnSetting.getDisplayName(), aLogQueryExpressionDescriptor.getOperationDisplayName(), columnValue, this.mContextMenuActionListener);
        }
        this.addSeparator();
        this.addMenu("Copy", " ", "copy", columnValue, this.mContextMenuActionListener);
        if (!this.table.getViewType().equalsIgnoreCase(LogTypeEnumeration.SAT_TRACE.toString())) {
            int currentAlignment = columnSetting.getAlignment();
            int nextAlignment = (currentAlignment + 1) % ColumnSettings.ALIGNMENT_NAMES.length;
            this.addMenu(ALIGN + ColumnSettings.ALIGNMENT_NAMES[nextAlignment] + " for", columnSetting.getDisplayName(), ALIGN, columnValue, this.mContextMenuActionListener);
        }
        TableRowSelectActionListener detailActionListener = new TableRowSelectActionListener(this.table);
        this.addMenu("Display details", " ", "Display details", columnValue, detailActionListener);
        if (this.table.isInSearchMode()) {
            this.addMenu("Find this Logrecord in Log above", " ", "Find logrecord", columnValue, this.mContextMenuActionListener);
        }
    }

    public ColumnSettings getColumnSetting() {
        return this.columnSetting;
    }
}

