/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sap.tc.logging.FileLog;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.logcontroller.AbstractBAMLogReader;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.commandline.DataSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class ClientCommandLineArgs {
    private DataSource mDataSource;
    private List mHostDescriptors;
    private String mUsername = "";
    private String mPassword = "";
    private String mNIconnectionString = "";
    private List mLogFilesFromConsole = new ArrayList();
    ConnectionProtocol mConnectionProtocol;
    private File mPropertyFile;
    private boolean mVerbose;

    public ClientCommandLineArgs(String[] args) {
        this.mHostDescriptors = new ArrayList();
        this.parseArgs(args);
    }

    private void parseArgs(String[] args) {
        boolean error = true;
        int i = 0;
        int servercount = 1;
        while (i < args.length) {
            String argument = args[i];
            if (argument.equalsIgnoreCase("-h") || argument.equalsIgnoreCase("-help")) {
                this.usage();
            } else if (argument.equalsIgnoreCase("-v") || argument.equalsIgnoreCase("-verbose")) {
                this.mVerbose = true;
            } else if (argument.equalsIgnoreCase("-m") || argument.equalsIgnoreCase("-mode")) {
                try {
                    String mode = args[++i];
                    if (mode.equalsIgnoreCase("standalone") || mode.equalsIgnoreCase("J2EE") || mode.equalsIgnoreCase("NI")) {
                        this.mConnectionProtocol = ConnectionProtocol.JRMP;
                        if (args[++i].equalsIgnoreCase("-s") || args[i].equalsIgnoreCase("-server")) {
                            try {
                                this.mDataSource = new DataSource(args[++i]);
                            }
                            catch (IllegalArgumentException iargEx) {
                                this.usage();
                            }
                        } else {
                            --i;
                        }
                    }
                    if (mode.equalsIgnoreCase("J2EE") || mode.equalsIgnoreCase("NI")) {
                        this.mConnectionProtocol = ConnectionProtocol.P4;
                        if (mode.equalsIgnoreCase("J2EE")) {
                            this.mUsername = args[++i];
                            this.mPassword = args[++i];
                        }
                        if (mode.equalsIgnoreCase("NI")) {
                            this.mConnectionProtocol = ConnectionProtocol.NI_JRMP;
                            String theNIconnectionString = args[++i];
                            StringTokenizer connTok = new StringTokenizer(theNIconnectionString, "/");
                            int i2 = connTok.countTokens() - 3;
                            while (i2 > 0) {
                                this.mNIconnectionString = this.mNIconnectionString + connTok.nextToken() + "/";
                                --i2;
                            }
                            this.mNIconnectionString = this.mNIconnectionString.substring(0, this.mNIconnectionString.length() - 3);
                            String mDataSourceStr = connTok.nextToken();
                            connTok.nextToken();
                            mDataSourceStr = mDataSourceStr + ":" + connTok.nextToken();
                            this.mDataSource = new DataSource(mDataSourceStr);
                        }
                    }
                    this.mHostDescriptors.add(new HostDescriptor(this.mDataSource.getServername(), Integer.toString(this.mDataSource.getPort()), this.mConnectionProtocol, true, this.mNIconnectionString, this.mUsername, this.mPassword, this.mDataSource.getServername() + " " + servercount));
                    error = false;
                }
                catch (ArrayIndexOutOfBoundsException arrayEx) {
                    this.usage();
                }
            } else {
                File f = new File(argument);
                if (f.isFile()) {
                    this.mLogFilesFromConsole.add(AbstractBAMLogReader.createReadableLog(new FileLog(f.getAbsolutePath())));
                    this.mHostDescriptors.add(LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__);
                    error = false;
                    AbstractLogViewerAppplication.setDirectLog(true);
                } else if (argument.equalsIgnoreCase("-p") || argument.equalsIgnoreCase("-property")) {
                    if ((f = new File(args[++i])).isFile()) {
                        this.mPropertyFile = f;
                        error = false;
                    } else {
                        this.usage();
                    }
                } else if (error) {
                    this.usage();
                }
            }
            ++i;
            ++servercount;
        }
    }

    public List getLogFilesFromConsole() {
        return this.mLogFilesFromConsole;
    }

    public File getPropertyFile() {
        return this.mPropertyFile;
    }

    public Collection getHostDescriptors() {
        return this.mHostDescriptors;
    }

    private void usage() {
        System.out.println("usage: java LogViewerApplication [options]");
        System.out.println("-m[ode] standalone -s[erver] logviewerServername:logviewerPort");
        System.out.println("OR");
        System.out.println("-m[ode] j2ee -s[erver] j2eeServername:j2eePort j2eeServerUsername j2eeServerPassword");
        System.out.println("OR");
        System.out.println("-m[ode] ni -s[erver] logviewerServername:logviewerPort connectionString");
        System.out.println("OR");
        System.out.println("-p[roperty] <propertyfile>");
        System.out.println("-h[elp]");
        System.out.println("-v[erbose]");
        System.exit(1);
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }
}

