/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.InvalidAttributeException;
import com.sapmarkets.bam.application.InvalidLogDescriptorException;
import com.sapmarkets.bam.application.LogAttributeDescriptor;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.view.ViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttributeSettingDialog
extends JDialog
implements ActionListener {
    private JList mAttributeList;
    private JList mValueList;
    private DefaultListModel mAttributeListModel;
    private DefaultListModel mValueListModel;
    private JButton btnOk;
    private JButton btnCancel;
    private LogDescriptor mLogDescriptor;
    private Map mAttributeValues;
    private JTextArea mDescriptionLabel;
    private List mLogDescriptors = null;

    public AttributeSettingDialog(Frame parent, List logDescriptors, String title) {
        this(parent, (LogDescriptor)logDescriptors.get(0), title);
        this.mLogDescriptors = logDescriptors;
    }

    public AttributeSettingDialog(Frame parent, LogDescriptor logDescriptor, String title) {
        super(parent, title);
        this.mLogDescriptor = logDescriptor;
        this.getContentPane().setLayout(new GridBagLayout());
        this.mAttributeValues = this.getCurrentAttributeValues();
        this.mValueList = new JList();
        this.mValueList.setSelectionMode(0);
        this.mValueList.addListSelectionListener(new ValueListListener());
        this.mValueList.setCellRenderer(new ValueListCellRenderer());
        this.mDescriptionLabel = new JTextArea();
        this.mDescriptionLabel.setEditable(false);
        this.mDescriptionLabel.setBackground(((Component)this).getBackground());
        this.mAttributeListModel = this.createAttributeListModel();
        this.mAttributeList = new JList(this.mAttributeListModel);
        this.mAttributeList.setSelectionMode(0);
        this.mAttributeList.addListSelectionListener(new AttributeListListener());
        this.mAttributeList.setSelectedIndex(0);
        JScrollPane attributeScrollPane = new JScrollPane(this.mAttributeList);
        attributeScrollPane.setPreferredSize(new Dimension(250, 80));
        attributeScrollPane.setMinimumSize(new Dimension(250, 80));
        JPanel attributePane = new JPanel();
        attributePane.setLayout(new BorderLayout());
        JLabel lblTitle = new JLabel("Attributes:");
        attributePane.add((Component)lblTitle, "North");
        attributePane.add(Box.createRigidArea(new Dimension(0, 5)));
        attributePane.add((Component)attributeScrollPane, "Center");
        this.mDescriptionLabel.setText(this.getAttributeDescription());
        attributePane.add((Component)this.mDescriptionLabel, "South");
        attributePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(this.getContentPane(), attributePane, 0, 0, 1, 1, 1.0, 1.0);
        JScrollPane valueScrollPane = new JScrollPane(this.mValueList);
        valueScrollPane.setPreferredSize(new Dimension(250, 80));
        valueScrollPane.setMinimumSize(new Dimension(250, 80));
        JPanel valuePane = new JPanel();
        valuePane.setLayout(new BorderLayout());
        lblTitle = new JLabel("Values:");
        valuePane.add((Component)lblTitle, "North");
        valuePane.add(Box.createRigidArea(new Dimension(0, 5)));
        valuePane.add((Component)valueScrollPane, "Center");
        valuePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(this.getContentPane(), valuePane, 1, 0, 1, 1, 1.0, 1.0);
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.btnOk = new JButton("  OK  ");
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        this.btnCancel.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        bottomPanel.add(this.btnOk);
        bottomPanel.add(this.btnCancel);
        ViewUtil.makeComponent(this.getContentPane(), bottomPanel, 0, 1, 2, 1, 0.0, 0.0);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AttributeSettingDialog.this.adjustSize();
            }
        });
    }

    private void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    private String getAttributeDescription() {
        String attributeName = this.mAttributeList.getSelectedValue().toString();
        LogAttributeDescriptor logAttributeDescriptor = this.getAttributeDescriptorByName(attributeName);
        return logAttributeDescriptor.getDescription();
    }

    public void actionPerformed(ActionEvent e) {
        block11: {
            if (e.getSource() == this.btnOk) {
                try {
                    try {
                        Set key = this.mAttributeValues.keySet();
                        Iterator itr = key.iterator();
                        while (itr.hasNext()) {
                            String attributeName = itr.next().toString();
                            if (this.mLogDescriptors == null) {
                                LogDepot logDepot = this.mLogDescriptor.getLogDepot();
                                logDepot.setAttribute(this.mLogDescriptor.getObjectName(), attributeName, this.mAttributeValues.get(attributeName));
                                continue;
                            }
                            int i = 0;
                            while (i < this.mLogDescriptors.size()) {
                                LogDescriptor logDescriptor = (LogDescriptor)this.mLogDescriptors.get(i);
                                LogDepot logDepot = logDescriptor.getLogDepot();
                                logDepot.setAttribute(logDescriptor.getObjectName(), attributeName, this.mAttributeValues.get(attributeName));
                                ++i;
                            }
                        }
                    }
                    catch (InvalidAttributeException ex2) {
                        JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex2.getMessage()), "Error", 0);
                        Object var9_13 = null;
                        ((Component)this).setVisible(false);
                        break block11;
                    }
                    catch (InvalidLogDescriptorException ex3) {
                        JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex3.getMessage()), "Error", 0);
                        Object var9_14 = null;
                        ((Component)this).setVisible(false);
                        break block11;
                    }
                    catch (BAMAppException ex) {
                        JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex.getMessage()), "Error", 0);
                        Object var9_15 = null;
                        ((Component)this).setVisible(false);
                    }
                    Object var9_12 = null;
                    ((Component)this).setVisible(false);
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    ((Component)this).setVisible(false);
                    throw throwable;
                }
            }
        }
        if (e.getSource() == this.btnCancel) {
            ((Component)this).setVisible(false);
        }
    }

    private void setValueListData(String attributeName, Object currentValue) {
        DefaultListModel model = this.createValueListModel(attributeName);
        this.mValueList.setModel(model);
        int i = 0;
        while (i < model.getSize()) {
            if (currentValue != null && currentValue.toString().equalsIgnoreCase(model.getElementAt(i).toString())) {
                this.mValueList.setSelectedIndex(i);
            }
            ++i;
        }
    }

    private DefaultListModel createAttributeListModel() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        Set someAttributes = this.mLogDescriptor.getLogAttributeDescriptors();
        if (someAttributes != null) {
            Iterator itr = someAttributes.iterator();
            while (itr.hasNext()) {
                LogAttributeDescriptor logAttributeDescriptor = (LogAttributeDescriptor)itr.next();
                if (!logAttributeDescriptor.isWritable()) continue;
                model.addElement(logAttributeDescriptor.getName());
            }
        }
        return model;
    }

    private LogAttributeDescriptor getAttributeDescriptorByName(String attrName) {
        Set someAttributes = this.mLogDescriptor.getLogAttributeDescriptors();
        Iterator itr = someAttributes.iterator();
        while (itr.hasNext()) {
            LogAttributeDescriptor logAttributeDescriptor = (LogAttributeDescriptor)itr.next();
            if (!attrName.equals(logAttributeDescriptor.getName())) continue;
            return logAttributeDescriptor;
        }
        return null;
    }

    private Map getCurrentAttributeValues() {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Set someAttributes = this.mLogDescriptor.getLogAttributeDescriptors();
            Iterator itr = someAttributes.iterator();
            while (itr.hasNext()) {
                LogAttributeDescriptor logAttributeDescriptor = (LogAttributeDescriptor)itr.next();
                if (!logAttributeDescriptor.isWritable()) continue;
                String attributeName = logAttributeDescriptor.getName();
                LogDepot logDepot = this.mLogDescriptor.getLogDepot();
                Object currentValue = logDepot.getAttribute(this.mLogDescriptor.getObjectName(), attributeName);
                values.put(attributeName, currentValue);
            }
            return values;
        }
        catch (InvalidAttributeException ex2) {
            JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex2.getMessage()), "Error", 0);
        }
        catch (InvalidLogDescriptorException ex3) {
            JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex3.getMessage()), "Error", 0);
        }
        catch (BAMAppException ex) {
            JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex.getMessage()), "Error", 0);
        }
        return null;
    }

    private DefaultListModel createValueListModel(String attributeName) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        LogAttributeDescriptor logAttributeDescriptor = this.getAttributeDescriptorByName(attributeName);
        List somePossibleValues = logAttributeDescriptor.getPossibleValues();
        if (somePossibleValues != null) {
            Iterator itr = somePossibleValues.iterator();
            while (itr.hasNext()) {
                model.addElement(itr.next().toString());
            }
        }
        return model;
    }

    class ValueListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        final ImageIcon checkIcon = ViewUtil.getIcon("/images/check.gif");
        final ImageIcon blankIcon = ViewUtil.getIcon("/images/blank.gif");

        ValueListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = list.getSelectedIndex();
            String s = value.toString();
            this.setText(s);
            if (isSelected) {
                this.setIcon(this.checkIcon);
            } else if (index > selectedIndex) {
                this.setIcon(this.checkIcon);
            } else {
                this.setIcon(this.blankIcon);
            }
            return this;
        }
    }

    class ValueListListener
    implements ListSelectionListener {
        ValueListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && AttributeSettingDialog.this.mValueList.getSelectedIndex() != -1) {
                String attributeName = AttributeSettingDialog.this.mAttributeList.getSelectedValue().toString();
                String currentValue = AttributeSettingDialog.this.mValueList.getSelectedValue().toString();
                AttributeSettingDialog.this.mAttributeValues.put(attributeName, currentValue);
            }
        }
    }

    class AttributeListListener
    implements ListSelectionListener {
        AttributeListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && AttributeSettingDialog.this.mAttributeList.getSelectedIndex() != -1) {
                String attributeName = AttributeSettingDialog.this.mAttributeList.getSelectedValue().toString();
                Object currentValue = AttributeSettingDialog.this.mAttributeValues.get(attributeName);
                AttributeSettingDialog.this.setValueListData(attributeName, currentValue);
                AttributeSettingDialog.this.mDescriptionLabel.setText(AttributeSettingDialog.this.getAttributeDescription());
            }
        }
    }
}

