/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.ViewUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AlertDialog
extends JDialog
implements ActionListener {
    private JCheckBox mCheck;
    private JOptionPane mOptionPane;
    private final String ALERTMESSAGE = "You will sort the currently displayed log records." + System.getProperty("line.separator") + "In order to see new log records, you need to turn off sorting mode." + System.getProperty("line.separator") + "Until then no new records will be loaded";

    public AlertDialog() {
        this.setTitle("Sort mode will be activated Warning");
        this.setModal(true);
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        } else {
            com.sap.engine.gui.LookAndFeelHandler.add((Component)this);
        }
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        Object[] optionButtons = new Object[1];
        JButton ok = new JButton("Ok");
        ok.addActionListener(this);
        ok.setActionCommand("ok");
        optionButtons[0] = ok;
        this.mOptionPane = new JOptionPane(this.ALERTMESSAGE, 1, 0, null, optionButtons);
        ViewUtil.makeComponent(basePanel, this.mOptionPane, 0, 0, 1, 1, 0.0, 0.0);
        this.mCheck = new JCheckBox("Never show this message again");
        ViewUtil.makeComponent(basePanel, this.mCheck, 0, 1, 1, 1, 1.0, 1.0);
        this.getContentPane().add(basePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AlertDialog.this.adjustSize();
            }
        });
    }

    private void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            if (this.mCheck.isSelected()) {
                ViewUtil.setAlertOff();
            }
            ((Component)this).setVisible(false);
        }
    }

    public static void main(String[] args) {
        AlertDialog dlg = new AlertDialog();
        dlg.show();
    }
}

