/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.MonitorableFileHandler;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.ExampleFileFilter;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.FormatObtainer;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogPreview;
import com.sapmarkets.bam.view.LogViewerApplication;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.overview.OverviewFacade;
import com.sapmarkets.bam.view.overview.OverviewFilePathTreeWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class AddFileStandalone
extends JDialog
implements ActionListener {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$view$AddFileStandalone == null ? (class$com$sapmarkets$bam$view$AddFileStandalone = AddFileStandalone.class$("com.sapmarkets.bam.view.AddFileStandalone")) : class$com$sapmarkets$bam$view$AddFileStandalone);
    private JRadioButton[] mRadioButtons;
    private JButton mAdd;
    private JFileChooser mFileChooser;
    private String mFormatType = "";
    private FormatObtainer mButtonPanel_FormatObtainer;
    private ILogViewerApplication mLogViewer;
    private MonitorableFileHandler mMonitorableFileHandler;
    private static File mCurrentDirectory = null;
    private LogDepot logDepot;
    private File file;
    public static int fileCount = 0;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$AddFileStandalone;

    public AddFileStandalone(ILogViewerApplication application, Frame frame, MonitorableFileHandler handler, String[] formats) {
        super(frame, "Add a file to monitor");
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        } else {
            com.sap.engine.gui.LookAndFeelHandler.add((Component)this);
        }
        this.mLogViewer = application;
        this.mMonitorableFileHandler = handler;
        this.setResizable(false);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Step 1"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel midPanel = new JPanel();
        midPanel.setLayout(new BorderLayout());
        midPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Step 2"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        LogDepot logDepot = this.mMonitorableFileHandler.getLogDepot();
        JLabel lblFileChooser = new JLabel("Select file to monitor from " + logDepot.getNodeDescription());
        topPanel.add((Component)lblFileChooser, "North");
        this.mFileChooser = new JFileChooser();
        this.mFileChooser.setDialogType(0);
        this.mFileChooser.setControlButtonsAreShown(false);
        LogDescriptor sld = OverviewFacade.getSelectedLogDescriptor();
        try {
            mCurrentDirectory = new File(new File(sld.getURI()).getCanonicalPath());
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.mFileChooser.setCurrentDirectory(mCurrentDirectory);
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("txt");
        filter.addExtension("log");
        filter.addExtension("log.*");
        filter.addExtension("trc");
        filter.addExtension("trc.*");
        filter.setDescription("Log Files");
        this.mFileChooser.setFileFilter(filter);
        this.mFileChooser.setMultiSelectionEnabled(true);
        topPanel.add((Component)this.mFileChooser, "Center");
        midPanel.setLayout(new BoxLayout(midPanel, 1));
        JLabel formatLabel = new JLabel("Choose the format:  (If the format is determined automatically, the choices are disabled)");
        midPanel.add((Component)formatLabel, "North");
        this.mButtonPanel_FormatObtainer = this.createRadioButtonPanel(formats);
        midPanel.add((Component)this.mButtonPanel_FormatObtainer, "Center");
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BorderLayout());
        LogPreview mLogInfoText = new LogPreview(this.mFileChooser);
        mLogInfoText.setLineWrap(true);
        mLogInfoText.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(mLogInfoText);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        mLogInfoText.setScrollPane(scrollPane);
        previewPanel.add((Component)scrollPane, "Center");
        previewPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mLogInfoText.setText("No file selected");
        midPanel.add((Component)previewPanel, "South");
        this.mFileChooser.addPropertyChangeListener(this.mButtonPanel_FormatObtainer);
        bottomPanel.setLayout(new FlowLayout(1));
        this.mAdd = new JButton("Add");
        this.mAdd.addActionListener(this);
        this.mAdd.setActionCommand("add");
        this.mAdd.setEnabled(true);
        bottomPanel.add(this.mAdd);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        cancel.setActionCommand("cancel");
        bottomPanel.add(cancel);
        ViewUtil.makeComponent(basePanel, topPanel, 0, 0, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(basePanel, midPanel, 0, 1, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(basePanel, bottomPanel, 0, 2, 1, 1, 0.0, 0.0);
        if (LogViewerApplication.isDrop) {
            this.addDropFile();
        } else {
            this.getContentPane().add(basePanel);
        }
    }

    public void addDropFile() {
        try {
            LogDepot logDepot = this.mMonitorableFileHandler.getLogDepot();
            List filelist = OverviewFilePathTreeWrapper.filelist;
            Iterator iterator = filelist.iterator();
            while (iterator.hasNext()) {
                LogDescriptor ld;
                String formatType;
                ++fileCount;
                this.file = (File)iterator.next();
                String filename = this.file.getAbsolutePath();
                LogRegistrationResult logRegistrationResult = this.mMonitorableFileHandler.registerToMonitor(filename, formatType = this.mButtonPanel_FormatObtainer.getFormatType(filename), new User("Tester"));
                ObjectName objectName = logRegistrationResult.getObjectName();
                if (null == objectName || null == (ld = logDepot.getLogDescriptor(objectName))) continue;
                this.mLogViewer.addLogToOverview(ld);
            }
            ((Component)this).setVisible(false);
            String message = new String();
        }
        catch (BAMRuntimeException ex) {
            ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)ex));
            LOG.logException((Throwable)((Object)ex));
        }
    }

    private FormatObtainer createRadioButtonPanel(String[] formats) {
        FormatObtainer panel = new FormatObtainer(this.mMonitorableFileHandler);
        panel.setLayout(new FlowLayout(0));
        ButtonGroup group = new ButtonGroup();
        this.mRadioButtons = new JRadioButton[formats.length];
        int i = 0;
        while (i < this.mRadioButtons.length) {
            this.mRadioButtons[i] = new JRadioButton(formats[i]);
            this.mRadioButtons[i].addActionListener(this);
            this.mRadioButtons[i].setActionCommand(formats[i]);
            group.add(this.mRadioButtons[i]);
            panel.add(this.mRadioButtons[i]);
            ++i;
        }
        panel.setRadioBottons(this.mRadioButtons);
        this.mRadioButtons[0].setSelected(true);
        this.mFormatType = formats[0];
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("add")) {
            try {
                LogDepot logDepot = this.mMonitorableFileHandler.getLogDepot();
                File[] files = this.mFileChooser.getSelectedFiles();
                StringBuffer preDefinedLogsMessage = new StringBuffer("The following logs are already registered: \n");
                StringBuffer unMonitorableLogsMessage = new StringBuffer("The directory for the following logs have not been defined in the MonitorablePaths: \n");
                boolean preDefinedLogs = false;
                boolean unMonitorableLogs = false;
                int i = 0;
                while (i < this.mRadioButtons.length) {
                    if (this.mRadioButtons[i].isSelected()) {
                        this.mFormatType = this.mRadioButtons[i].getText();
                        break;
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < files.length) {
                    LogDescriptor ld;
                    String filename = files[i2].getAbsolutePath();
                    mCurrentDirectory = this.mFileChooser.getCurrentDirectory();
                    String formatType = this.mButtonPanel_FormatObtainer.getFormatType(filename);
                    LogRegistrationResult logRegistrationResult = this.mMonitorableFileHandler.registerToMonitor(filename, formatType, new User("Tester"));
                    ObjectName objectName = logRegistrationResult.getObjectName();
                    if (null != objectName && null != (ld = logDepot.getLogDescriptor(objectName))) {
                        this.mLogViewer.addLogToOverview(ld);
                    }
                    if (logRegistrationResult.getStatus() == 1) {
                        preDefinedLogsMessage.append(filename + "\n");
                        preDefinedLogs = true;
                    } else if (logRegistrationResult.getStatus() == 3) {
                        unMonitorableLogsMessage.append(filename + "\n");
                        unMonitorableLogs = true;
                    }
                    ++i2;
                }
                ((Component)this).setVisible(false);
                String message = new String();
                if (preDefinedLogs) {
                    message = message + preDefinedLogsMessage;
                }
                if (unMonitorableLogs) {
                    message = message + unMonitorableLogsMessage;
                }
                if (preDefinedLogs || unMonitorableLogs) {
                    JOptionPane.showMessageDialog(this, message, "File Registration Status", 2);
                }
                return;
            }
            catch (BAMRuntimeException ex) {
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)ex));
                LOG.logException((Throwable)((Object)ex));
            }
        }
        if (actionCommand.equals("cancel")) {
            ((Component)this).setVisible(false);
            return;
        }
        this.mFormatType = actionCommand;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

