/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.MonitorableFileHandler;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.FormatObtainer;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.ViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.List;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class AddFileDialog
extends JDialog
implements ActionListener {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$view$AddFileDialog == null ? (class$com$sapmarkets$bam$view$AddFileDialog = AddFileDialog.class$("com.sapmarkets.bam.view.AddFileDialog")) : class$com$sapmarkets$bam$view$AddFileDialog);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$view$AddFileDialog == null ? (class$com$sapmarkets$bam$view$AddFileDialog = AddFileDialog.class$("com.sapmarkets.bam.view.AddFileDialog")) : class$com$sapmarkets$bam$view$AddFileDialog);
    String fileName;
    private JList mFileList;
    private JPanel toprightPanel;
    private JPanel midPanel;
    private JButton mAdd;
    private JComboBox mFilename;
    private JRadioButton[] mRadioButtons;
    private String mFormatType = "";
    private ILogViewerApplication mLogViewer;
    private Frame frame = null;
    private FormatObtainer mButtonPanel_FormatObtainer;
    private MonitorableFileHandler mMonitorableFileHandler;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$AddFileDialog;

    public AddFileDialog(ILogViewerApplication application, Frame frame, MonitorableFileHandler handler, String[] formats) {
        super(frame, "Add monitorable file");
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        } else {
            com.sap.engine.gui.LookAndFeelHandler.add((Component)this);
        }
        this.mLogViewer = application;
        this.mMonitorableFileHandler = handler;
        JPanel topPanel = new JPanel();
        JPanel topleftPanel = new JPanel();
        this.toprightPanel = new JPanel();
        this.midPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        topPanel.setLayout(new GridBagLayout());
        JLabel nodeLabel = new JLabel("Select file to monitor from node: " + this.mMonitorableFileHandler.getLogDepot().getNodeDescription());
        topleftPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Step 1"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        topleftPanel.setLayout(new BorderLayout());
        JLabel filenameLabel = new JLabel("Enter a filename:");
        JLabel commentLabel = new JLabel(" * = any string   ... = cross multiple directories");
        topleftPanel.add((Component)filenameLabel, "North");
        topleftPanel.add((Component)commentLabel, "South");
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new FlowLayout(0));
        this.mFilename = new JComboBox<String>(this.getMonitorablePaths());
        this.mFilename.setEditable(true);
        inputPanel.add(this.mFilename);
        JButton goButton = new JButton("Show file list");
        goButton.addActionListener(this);
        goButton.setActionCommand("go");
        inputPanel.add(goButton);
        topleftPanel.add((Component)inputPanel, "Center");
        this.getRootPane().setDefaultButton(goButton);
        this.toprightPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Step 2"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.toprightPanel.setLayout(new BorderLayout());
        JLabel selectLabel = new JLabel("Select a file to monitor:");
        this.toprightPanel.add((Component)selectLabel, "North");
        this.mFileList = new JList();
        JScrollPane scrollPane = new JScrollPane(this.mFileList);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        this.toprightPanel.add((Component)scrollPane, "Center");
        ViewUtil.makeComponent(topPanel, nodeLabel, 0, 0, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(topPanel, topleftPanel, 0, 1, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(topPanel, this.toprightPanel, 1, 1, 1, 1, 1.0, 1.0);
        this.midPanel.setLayout(new BorderLayout());
        this.midPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Step 3"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel formatLabel = new JLabel("Choose the format:");
        this.midPanel.add((Component)formatLabel, "North");
        this.mButtonPanel_FormatObtainer = this.createRadioButtonPanel(formats);
        this.midPanel.add((Component)this.mButtonPanel_FormatObtainer, "Center");
        this.mFileList.addListSelectionListener(this.mButtonPanel_FormatObtainer);
        ViewUtil.makeComponent(basePanel, topPanel, 0, 0, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(basePanel, this.midPanel, 0, 1, 1, 1, 0.0, 0.0);
        bottomPanel.setLayout(new FlowLayout(1));
        this.mAdd = new JButton("Add");
        this.mAdd.addActionListener(this);
        this.mAdd.setActionCommand("add");
        this.mAdd.setEnabled(false);
        bottomPanel.add(this.mAdd);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        cancel.setActionCommand("cancel");
        bottomPanel.add(cancel);
        ViewUtil.makeComponent(basePanel, bottomPanel, 0, 2, 1, 1, 0.0, 0.0);
        this.toprightPanel.setVisible(false);
        this.midPanel.setVisible(false);
        this.getContentPane().add(basePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AddFileDialog.this.adjustSize();
            }
        });
        this.frame = frame;
    }

    private void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    private FormatObtainer createRadioButtonPanel(String[] formats) {
        FormatObtainer panel = new FormatObtainer(this.mMonitorableFileHandler);
        panel.setLayout(new FlowLayout(0));
        ButtonGroup group = new ButtonGroup();
        this.mRadioButtons = new JRadioButton[formats.length];
        int i = 0;
        while (i < this.mRadioButtons.length) {
            this.mRadioButtons[i] = new JRadioButton(formats[i]);
            this.mRadioButtons[i].addActionListener(this);
            this.mRadioButtons[i].setActionCommand(formats[i]);
            group.add(this.mRadioButtons[i]);
            panel.add(this.mRadioButtons[i]);
            ++i;
        }
        panel.setRadioBottons(this.mRadioButtons);
        this.mRadioButtons[0].setSelected(true);
        this.mFormatType = formats[0];
        return panel;
    }

    private DefaultListModel createFileListModel(String filename) {
        DefaultListModel model = new DefaultListModel();
        try {
            List files = this.mMonitorableFileHandler.getMonitorableFiles(filename);
            if (files != null) {
                int i = 0;
                while (i < files.size()) {
                    model.addElement(files.get(i));
                    ++i;
                }
                return model;
            }
            return null;
        }
        catch (BAMRuntimeException e) {
            ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)e));
            LOG.logException((Throwable)((Object)e));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent e) {
        block27: {
            block26: {
                block24: {
                    try {
                        try {
                            this.setCursorType(3);
                            String actionCommand = e.getActionCommand();
                            if ("go".equals(actionCommand)) {
                                String filename = (String)this.mFilename.getSelectedItem();
                                TRACE.traceInfo("Trying to add a file with path [" + filename + "]");
                                DefaultListModel fileListModel = this.createFileListModel(filename);
                                this.mFileList.setModel(fileListModel);
                                TRACE.traceInfo("The server returned " + fileListModel.getSize() + " available files to select!");
                                if (fileListModel.getSize() > 0) {
                                    this.mFileList.setSelectedIndex(0);
                                    this.mAdd.setEnabled(true);
                                } else {
                                    JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "Either the directory is empty, the file specified could not be found \n\r or the directory you choose is invalid, because it is not maintained in the properties.\n\r Please check the property [MonitorablePath]!", "Warning", 2);
                                }
                                this.toprightPanel.setVisible(true);
                                this.midPanel.setVisible(true);
                                this.pack();
                                this.setCursorType(0);
                                Object var17_9 = null;
                                this.setCursorType(0);
                                return;
                            }
                            if ("cancel".equals(actionCommand)) {
                                ((Component)this).setVisible(false);
                                this.setCursorType(0);
                                break block24;
                            }
                            if ("add".equals(actionCommand)) {
                                LogDepot logDepot = this.mMonitorableFileHandler.getLogDepot();
                                if (this.mFileList.getSelectedIndex() != -1) {
                                    try {
                                        Object[] files = this.mFileList.getSelectedValues();
                                        StringBuffer preDefinedLogsMessage = new StringBuffer("The following logs are already registered: \n");
                                        StringBuffer unMonitorableLogsMessage = new StringBuffer("The directory for the following logs have not been defined in the MonitorablePaths: \n");
                                        boolean preDefinedLogs = false;
                                        boolean unMonitorableLogs = false;
                                        int i = 0;
                                        while (i < this.mRadioButtons.length) {
                                            if (this.mRadioButtons[i].isSelected()) {
                                                this.mFormatType = this.mRadioButtons[i].getText();
                                                break;
                                            }
                                            ++i;
                                        }
                                        int i2 = 0;
                                        while (true) {
                                            LogDescriptor ld;
                                            if (i2 >= files.length) {
                                                ((Component)this).setVisible(false);
                                                String message = new String();
                                                if (preDefinedLogs) {
                                                    message = message + preDefinedLogsMessage;
                                                }
                                                if (unMonitorableLogs) {
                                                    message = message + unMonitorableLogsMessage;
                                                }
                                                if (preDefinedLogs || unMonitorableLogs) {
                                                    JOptionPane.showMessageDialog(this, message, "File Registration Status", 2);
                                                }
                                                break;
                                            }
                                            String filename = (String)files[i2];
                                            String formatType = this.mButtonPanel_FormatObtainer.getFormatType(filename);
                                            LogRegistrationResult logRegistrationResult = this.mMonitorableFileHandler.registerToMonitor(filename, formatType, new User("Tester"));
                                            ObjectName objectName = logRegistrationResult.getObjectName();
                                            if (null != objectName && null != (ld = logDepot.getLogDescriptor(objectName))) {
                                                this.mLogViewer.addLogToOverview(ld);
                                            }
                                            if (logRegistrationResult.getStatus() == 1) {
                                                preDefinedLogsMessage.append(filename + "\n");
                                                preDefinedLogs = true;
                                            } else if (logRegistrationResult.getStatus() == 3) {
                                                unMonitorableLogsMessage.append(filename + "\n");
                                                unMonitorableLogs = true;
                                            }
                                            ++i2;
                                        }
                                    }
                                    catch (BAMRuntimeException ex) {
                                        ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)ex));
                                        LOG.logException((Throwable)((Object)ex));
                                    }
                                }
                                this.setCursorType(0);
                                break block26;
                            }
                            this.mFormatType = actionCommand;
                            break block27;
                        }
                        catch (BAMRuntimeException ex) {
                            ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)ex));
                            LOG.logException((Throwable)((Object)ex));
                            Object var17_13 = null;
                            this.setCursorType(0);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_14 = null;
                        this.setCursorType(0);
                        throw throwable;
                    }
                }
                Object var17_10 = null;
                this.setCursorType(0);
                return;
            }
            Object var17_11 = null;
            this.setCursorType(0);
            return;
        }
        Object var17_12 = null;
        this.setCursorType(0);
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getFileObject() {
        if (this.fileName != null) {
            File logFile = new File(this.fileName);
            return logFile;
        }
        return null;
    }

    public void setCursorType(int cursor) {
        this.setCursor(new Cursor(cursor));
        if (null != this.frame) {
            this.frame.setCursor(new Cursor(cursor));
        }
    }

    public String[] getMonitorablePaths() {
        List paths = this.mMonitorableFileHandler.getMonitorablePaths();
        String[] pathArray = new String[paths.size() * 2];
        int count = 0;
        int i = paths.size() - 1;
        while (i >= 0) {
            String filepath = ((File)paths.get(i)).getPath();
            pathArray[count++] = filepath + "\\*";
            pathArray[count++] = filepath + "\\...";
            --i;
        }
        return pathArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

