/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.AbstractFilterSearch;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.queryexpr.GrepExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.LVVersion;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.AttributeSettingDialog;
import com.sapmarkets.bam.view.ColumnCustomizer;
import com.sapmarkets.bam.view.DockingWindow;
import com.sapmarkets.bam.view.DownloadProgressDialog;
import com.sapmarkets.bam.view.ErrorsOccurredDialog;
import com.sapmarkets.bam.view.ExampleFileFilter;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.FilterSearchDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogClusterNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.LogTablePane;
import com.sapmarkets.bam.view.LogViewDetailsDialog;
import com.sapmarkets.bam.view.NodePropertyDialog;
import com.sapmarkets.bam.view.SearchPane;
import com.sapmarkets.bam.view.ViewProperty;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.buffertable.LogTable;
import com.sapmarkets.bam.view.config.IViewConfiguration;
import com.sapmarkets.bam.view.detail.DetailDialogFactory;
import com.sapmarkets.bam.view.filter.DefaultFilterPanel;
import com.sapmarkets.bam.view.filter.FilterAndSearchPanel;
import com.sapmarkets.bam.view.overview.OverviewFacade;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;

public abstract class AbstractLogViewerAppplication
extends JPanel
implements ILogViewerApplication {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$AbstractLogViewerAppplication == null ? (class$com$sapmarkets$bam$view$AbstractLogViewerAppplication = AbstractLogViewerAppplication.class$("com.sapmarkets.bam.view.AbstractLogViewerAppplication")) : class$com$sapmarkets$bam$view$AbstractLogViewerAppplication);
    protected static final String TXT_MENU_CONFIG = "Configuration...";
    protected static final String TXT_MENU_ATTRIBUTE = "Attribute Setting...";
    protected static final String TXT_MENU_REFRESH_TREE = "Refresh overview of logs";
    public static final String TXT_MENU_VIEW_HIDE_BAD = "Hide empty logs";
    public static final String TXT_MENU_VIEW_SHOW_BAD = "Show empty logs";
    protected static final String TXT_MENU_REFRESH_FILE = "Refresh currently displayed log";
    protected static final String TXT_MENU_DISABLE_SORT = "Turn off Sorting";
    protected static final String TXT_MENU_SHOWLOGS = "Show Logs";
    protected static final String TXT_MENU_SELECTNEXTTAB = "Select next tab";
    protected static final String TXT_MENU_SELECTPREVIOUSTAB = "Select previous tab";
    protected static final String TXT_MENU_COLUMN_CUSTOMIZE = "Column Customize...";
    protected static final String TXT_MENU_GLOBAL_DATE_TIME_FILTER = "Global Date/Time DefaultFilter";
    protected static final String TXT_MENU_SAVE = "Save to file...";
    protected static final String TXT_MENU_ADDFILE = "Add a file...";
    public static final String TXT_MENU_ADDDIR = "Add Files from LogDirectory...";
    protected static final String TXT_MENU_PROPERTY = "Look and Feel...";
    protected static final String TXT_MENU_SHOW_NEW_MESSAGES = "Continually show new messages";
    protected static final String TXT_MENU_DISABLE_SORTING = "Turn off Sorting";
    protected static final String TXT_MENU_PROPERTIES = "Properties...";
    public static final String TXT_MENU_NOERROR = "No errors while reading the logs";
    protected static JSplitPane mSplitPane;
    protected static JPanel mRightPane;
    protected static JSplitPane mOverviewSplitPane;
    protected static FilterAndSearchPanel mFilterAndSearchPanel;
    protected static LogTablePane mLogPane;
    protected static Container mContentPane;
    protected static JButton mBtnConfig;
    protected static JButton mBtnAttribute;
    protected static JButton mBtnRefreshLog;
    protected static JButton mBtnRefreshOverview;
    protected static JButton mBtnToggleOverviewDisplay;
    protected static JButton mBtnDisableSorting;
    protected static JButton mErrorIndicator;
    protected static JButton mBtnTail;
    protected final String CONFIG_PATH = "cfg.path";
    protected boolean isOverviewDisplayAsTree = true;
    protected static SearchPane mSearchPane;
    protected static boolean isInitial;
    protected IViewConfiguration mViewConfiguration;
    protected static boolean isStandalone;
    protected static boolean directLog;
    public static final int BLOCK_TEXT_COLUMN_SIZE;
    private static boolean isOSSCopy;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$AbstractLogViewerAppplication;

    public static void setDirectLog(boolean value) {
        directLog = value;
    }

    public static boolean isStandalone() {
        return isStandalone;
    }

    public void doCloseLogWindow(LogTablePane aPane, DockingWindow unDockedWindow) {
        this.closeLog(aPane, aPane.getSelectedIndex(), unDockedWindow);
        int size = aPane.getTabCount();
        if (size == 0) {
            this.resetErrorStatus();
            this.closeLogWindow();
            this.changeStateOfTollBarAndMenuWhenAllFilesClose(false);
        } else {
            this.setErrorIndicator((ContentPane)aPane.getComponentAt(aPane.getSelectedIndex()));
        }
    }

    public abstract Frame getFrame();

    protected abstract Component getReferenceComponent();

    public void populateOverview() {
        if (null == this.mViewConfiguration) {
            try {
                this.closeAllLog();
                this.createViewConfiguration();
            }
            catch (Throwable e) {
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e, "Unable to obtain a valid configuration. Please check the detail of the exception.");
            }
        }
        if (null != this.mViewConfiguration) {
            OverviewFacade.setViewConfiguration(this.mViewConfiguration);
            OverviewFacade.populateOverview();
        }
    }

    public void populatArchiveNode(LogFileNode fileNode) {
        if (null == this.mViewConfiguration) {
            try {
                this.createViewConfiguration();
            }
            catch (Throwable e) {
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e, "Unable to obtain a valid configuration. Please check the detail of the exception.");
            }
        }
        if (null != this.mViewConfiguration) {
            OverviewFacade.setViewConfiguration(this.mViewConfiguration);
            fileNode.setArchiveUpdated(false);
            OverviewFacade.populateArchiveNodes(fileNode);
        }
    }

    public void removeFileNodeFromOverview(LogFileNode fileNode) {
        if (null == this.mViewConfiguration) {
            try {
                this.createViewConfiguration();
            }
            catch (Throwable e) {
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e, "Unable to obtain a valid configuration. Please check the detail of the exception.");
            }
        }
        if (null != this.mViewConfiguration) {
            OverviewFacade.setViewConfiguration(this.mViewConfiguration);
            OverviewFacade.removeLog(fileNode.getLogDescriptor());
        }
    }

    void updateMinSizeRightPane() {
        mRightPane.setMinimumSize(new Dimension(AbstractLogViewerAppplication.mSearchPane.getMinimumSize().width, 0));
    }

    public void populateApplicationNode(LogApplicationNode applicationNode) {
        if (null == this.mViewConfiguration) {
            try {
                this.createViewConfiguration();
            }
            catch (Throwable e) {
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e, "Unable to obtain a valid configuration. Please check the detail of the exception.");
            }
        }
        if (null != this.mViewConfiguration) {
            OverviewFacade.setViewConfiguration(this.mViewConfiguration);
            OverviewFacade.populateOverview(applicationNode);
        }
    }

    public void populateClusterNode(LogApplicationNode applicationNode, LogClusterNode clusterNode) {
        if (null == this.mViewConfiguration) {
            try {
                this.createViewConfiguration();
            }
            catch (Throwable e) {
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e, "Unable to obtain a valid configuration. Please check the detail of the exception.");
            }
        }
        if (null != this.mViewConfiguration) {
            OverviewFacade.setViewConfiguration(this.mViewConfiguration);
            OverviewFacade.populateOverview(applicationNode, clusterNode);
        }
    }

    public boolean isOverviewDisplayAsTree() {
        return this.isOverviewDisplayAsTree;
    }

    public void setOverviewDisplayAsTree(boolean overviewDisplayAsTree) {
        this.isOverviewDisplayAsTree = overviewDisplayAsTree;
    }

    public void toggleOverviewDisplayMode() {
        try {
            this.setCursorType(3);
            this.setOverviewDisplayAsTree(!this.isOverviewDisplayAsTree());
            OverviewFacade.updateOverviewDisplayType(this.isOverviewDisplayAsTree);
            mBtnToggleOverviewDisplay.setToolTipText(this.getOverviewModeActionText());
            Object var2_1 = null;
            this.setCursorType(0);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.setCursorType(0);
            throw throwable;
        }
    }

    public String getOverviewModeActionText() {
        String text = "View Logs As ";
        text = this.isOverviewDisplayAsTree() ? text + "Table" : text + "Tree";
        return text;
    }

    public void logSelected(String logType) {
        if (null == logType || logType.equals("")) {
            mBtnAttribute.setEnabled(false);
        } else if (LogTypeEnumeration.SAPJLOG.toString().equals(logType) || LogTypeEnumeration.SAT_TRACE.toString().equals(logType) || LogTypeEnumeration.SQL_TRACE.toString().equals(logType)) {
            if (!AbstractLogViewerAppplication.isStandalone()) {
                mBtnAttribute.setEnabled(true);
            }
        } else {
            mBtnAttribute.setEnabled(false);
        }
    }

    public void addLogToOverview(LogDescriptor ld) {
        OverviewFacade.addLog(ld);
    }

    public boolean isMergable(List someDescriptors) {
        if (someDescriptors != null) {
            LogFileNode fileNode = (LogFileNode)someDescriptors.get(0);
            LogDescriptor firstLogDescriptor = fileNode.getLogDescriptor();
            int i = 1;
            while (i < someDescriptors.size()) {
                fileNode = (LogFileNode)someDescriptors.get(i);
                LogDescriptor secondLogDescriptor = fileNode.getLogDescriptor();
                if (!firstLogDescriptor.isMergableWith(secondLogDescriptor)) {
                    JOptionPane.showMessageDialog(mContentPane, "The log file " + firstLogDescriptor.getDisplayName() + " and " + secondLogDescriptor.getDisplayName() + " cannot be merged.", "Merge Info", 1);
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isTableAlreadyDisplayed(List toBeOpened) {
        int i = 0;
        while (i < mLogPane.getTabCount()) {
            ContentPane pane = (ContentPane)mLogPane.getComponentAt(i);
            List paneLogFileNodes = pane.getLogFileNodes();
            if (toBeOpened.containsAll(paneLogFileNodes) && paneLogFileNodes.containsAll(toBeOpened)) {
                mLogPane.setSelectedIndex(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ContentPane makeTablePane(List someLogFileNodes, String paneTitle) throws BAMAppException {
        FilterAndSearchHandler filterAndSearchHandler = new FilterAndSearchHandler(mFilterAndSearchPanel.getGlobalFilterAndSearchHandler());
        ContentPane contentPane = new ContentPane(paneTitle, someLogFileNodes, filterAndSearchHandler, this.mViewConfiguration, this);
        this.changeStateOfTollBarAndMenuWhenAllFilesClose(true);
        return contentPane;
    }

    public void displayLogs(List selectedLogFileNodes) {
        String paneTitle = "";
        String tooltip = "";
        int i = 0;
        while (i < selectedLogFileNodes.size()) {
            LogFileNode logFileNode = (LogFileNode)selectedLogFileNodes.get(i);
            if (i < 5) {
                paneTitle = paneTitle + logFileNode.getIndex();
            }
            tooltip = tooltip + logFileNode.getPhysicalPath();
            if (i < selectedLogFileNodes.size() - 1) {
                if (i < 5) {
                    paneTitle = paneTitle + " + ";
                }
                tooltip = tooltip + " + ";
            }
            ++i;
        }
        if (selectedLogFileNodes.size() > 4) {
            paneTitle = paneTitle + "...[" + selectedLogFileNodes.size() + "]";
        }
        if (this.isMergable(selectedLogFileNodes)) {
            boolean showTable = false;
            Iterator itr = selectedLogFileNodes.iterator();
            while (itr.hasNext()) {
                LogFileNode logFileNode = (LogFileNode)itr.next();
                logFileNode.open();
                if (!logFileNode.isFileAvailable()) continue;
                showTable = true;
            }
            if (showTable) {
                try {
                    ContentPane contentPane;
                    if (isInitial) {
                        contentPane = this.makeTablePane(selectedLogFileNodes, paneTitle);
                        mSplitPane.setRightComponent(mRightPane);
                        mLogPane.addComponent(paneTitle, contentPane, tooltip);
                        isInitial = false;
                    } else if (!this.isTableAlreadyDisplayed(selectedLogFileNodes)) {
                        contentPane = this.makeTablePane(selectedLogFileNodes, paneTitle);
                        mLogPane.addComponent(paneTitle, contentPane, tooltip);
                    }
                }
                catch (BAMAppException ex) {
                    mLogger.logException((Throwable)((Object)ex));
                    ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)ex));
                }
                this.changeStateOfTollBarAndMenuWhenAllFilesClose(true);
            }
        }
    }

    public void removeSelectedLog() {
        this.setCursorType(3);
        try {
            LogDescriptor selLogDescriptor = OverviewFacade.getSelectedLogDescriptor();
            HostDescriptor selHostDescriptor = OverviewFacade.getSelectedHostDescriptor();
            if (selLogDescriptor == null) {
                JOptionPane.showMessageDialog(this.getFrame(), "Please select a log first.");
                this.setCursorType(0);
                Object var8_3 = null;
                this.setCursorType(0);
                return;
            }
            List logFileNodes = OverviewFacade.getSelectedLogFileNodes();
            Iterator it = logFileNodes.iterator();
            while (it.hasNext()) {
                LogFileNode logFileNode = (LogFileNode)it.next();
                this.closeOpenedLogFile(logFileNode);
                LogDescriptor ld = logFileNode.getLogDescriptor();
                OverviewFacade.removeLog(ld);
                this.unregister(selHostDescriptor, ld);
            }
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.setCursorType(0);
            throw throwable;
        }
        Object var8_4 = null;
        this.setCursorType(0);
    }

    public void hideBadLogs(JMenuItem m) {
        OverviewFacade.setHideBadFiles(!OverviewFacade.getHideBadFiles());
        this.refreshOverview();
        m.setText(OverviewFacade.getHideBadFiles() ? TXT_MENU_VIEW_SHOW_BAD : TXT_MENU_VIEW_HIDE_BAD);
    }

    protected abstract void setCursorType(int var1);

    public void clearOverview() {
        OverviewFacade.clear();
    }

    public void refreshOverview() {
        try {
            this.setCursorType(3);
            this.populateOverview();
            this.broadcastOverviewRefresh();
            Object var2_1 = null;
            this.setCursorType(0);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.setCursorType(0);
            throw throwable;
        }
    }

    public void refreshFileNode(LogFileNode fileNode) {
        try {
            this.setCursorType(3);
            this.populatArchiveNode(fileNode);
            this.broadcastOverviewRefresh();
            Object var3_2 = null;
            this.setCursorType(0);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setCursorType(0);
            throw throwable;
        }
    }

    public void removeArchiveNodes(LogFileNode fileNode) {
        if (null == this.mViewConfiguration) {
            try {
                this.createViewConfiguration();
            }
            catch (Throwable e) {
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e, "Unable to obtain a valid configuration. Please check the detail of the exception.");
            }
        }
        if (null != this.mViewConfiguration) {
            OverviewFacade.setViewConfiguration(this.mViewConfiguration);
            OverviewFacade.removeArchiveNodes(fileNode);
            this.refreshOverview();
        }
    }

    public void refreshClusterNode(LogApplicationNode applicationNode, LogClusterNode clusterNode) {
        try {
            this.setCursorType(3);
            this.populateClusterNode(applicationNode, clusterNode);
            this.broadcastOverviewRefresh();
            Object var4_3 = null;
            this.setCursorType(0);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setCursorType(0);
            throw throwable;
        }
    }

    public void refreshApplicationNode(LogApplicationNode applicationNode) {
        try {
            this.setCursorType(3);
            this.populateApplicationNode(applicationNode);
            this.broadcastOverviewRefresh();
            Object var3_2 = null;
            this.setCursorType(0);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setCursorType(0);
            throw throwable;
        }
    }

    protected void broadcastOverviewRefresh() {
        OverviewFacade.broadcastRefresh();
    }

    protected void initOverview() {
        this.createToolBar();
        this.mViewConfiguration = null;
        this.populateOverview();
    }

    protected abstract void createViewConfiguration() throws RemoteException, MalformedURLException, NotBoundException, Exception;

    public abstract void unregister(HostDescriptor var1, LogDescriptor var2);

    protected void closeLog(LogTablePane pane, int index, DockingWindow unDockedWindow) {
        Iterator itr = null;
        if (index > -1) {
            ContentPane contentPane = (ContentPane)pane.getComponentAt(index);
            if (contentPane.getLogTable() != null) {
                DetailDialogFactory.removeInstance(contentPane.getLogTable());
            }
            itr = contentPane.getLogFileNodes().iterator();
            contentPane.close();
            contentPane = null;
            pane.remove(index);
        } else {
            itr = unDockedWindow.getFileNodes().iterator();
        }
        while (itr.hasNext()) {
            LogFileNode fileNode = (LogFileNode)itr.next();
            if (null == fileNode) continue;
            fileNode.close();
        }
    }

    protected void closeAllLog() {
        int size = mLogPane.getTabCount();
        int i = size - 1;
        while (i >= 0) {
            this.closeLog(mLogPane, i, null);
            --i;
        }
        this.changeStateOfToolBarAndMenu(false);
        this.closeLogWindow();
    }

    private void closeLogWindow() {
        this.changeStateOfTollBarAndMenuWhenAllFilesClose(false);
        this.createInitialScreen();
        isInitial = true;
    }

    public abstract void createInitialScreen();

    protected void saveToFileAction() {
        if (mLogPane.getSelectedIndex() != -1) {
            LogQueryExpression logQueryExpression;
            ContentPane contentPane = (ContentPane)mLogPane.getComponentAt(mLogPane.getSelectedIndex());
            FilterAndSearchHandler filterAndSearchHandler = contentPane.getFilterAndSearch();
            List logDescriptors = contentPane.getLogDescriptors();
            try {
                logQueryExpression = filterAndSearchHandler.generateLogQueryExpressionForFilters(logDescriptors);
            }
            catch (BAMAppException e) {
                mLogger.logException((Throwable)((Object)e));
                mLogger.logError("QueryExpression could not be retrieved from LogDataService. Therefore it will be defaulted to standard GrepExpression");
                logQueryExpression = new GrepExpression(null);
            }
            this.downloadAction(logDescriptors, logQueryExpression);
        } else {
            JOptionPane.showMessageDialog(this.getFrame(), "Please open a log file(s) first.");
        }
    }

    public void showAttributeDialog() {
        List logFileNodes = OverviewFacade.getSelectedLogFileNodes();
        ArrayList<LogDescriptor> logDescriptors = new ArrayList<LogDescriptor>();
        int i = 0;
        while (i < logFileNodes.size()) {
            LogFileNode logFileNode = (LogFileNode)logFileNodes.get(i);
            if (!logFileNode.getLogType().equals(LogTypeEnumeration.ASCII_LOG.toString()) && !logFileNode.getLogType().equals(LogTypeEnumeration.ASCII_TRACE.toString())) {
                logDescriptors.add(logFileNode.getLogDescriptor());
            }
            ++i;
        }
        if (logDescriptors.size() == 0) {
            JOptionPane.showMessageDialog(this.getFrame(), "Please select a non-ascii log file", "Select a log", 1);
        } else {
            String title = "Attribute Setting";
            AttributeSettingDialog attributeDialog = new AttributeSettingDialog(this.getFrame(), logDescriptors, title);
            attributeDialog.pack();
            attributeDialog.setLocationRelativeTo(this.getReferenceComponent());
            attributeDialog.show();
        }
    }

    public void showErrorsActionPerformed() {
        int selectedIndex = mLogPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            ContentPane contentPane = (ContentPane)mLogPane.getComponentAt(selectedIndex);
            ErrorsOccurredDialog errorsOccurredDialog = new ErrorsOccurredDialog(contentPane.getExistingExceptions(), contentPane.getLogTable(), this);
            errorsOccurredDialog.setModal(true);
            errorsOccurredDialog.pack();
            errorsOccurredDialog.show();
        }
    }

    public void showProperties() {
        LogFileNode logFileNode = OverviewFacade.getSelectedLogFileNode();
        if (logFileNode != null) {
            NodePropertyDialog dlg = NodePropertyDialog.getInstance(this.getFrame());
            dlg.setText(logFileNode);
            dlg.setTitle("Properties for " + logFileNode.toString());
            dlg.pack();
            dlg.setLocationRelativeTo(this.getFrame());
            dlg.show();
        }
    }

    public void showServerProperties() {
        LVVersion serverVersion = null;
        Map logDepots = this.getLogDepot();
        Iterator iter = logDepots.values().iterator();
        while (iter.hasNext()) {
            LogDepot logDepot = (LogDepot)iter.next();
            serverVersion = logDepot.getServerVersion();
            if (serverVersion != null) break;
        }
        JOptionPane.showMessageDialog(null, serverVersion.toString());
    }

    public abstract Map getLogDepot();

    protected void actionColumnCustomize() {
        if (this.mViewConfiguration != null && this.mViewConfiguration.getFirstLogDescriptor() != null) {
            try {
                this.setCursorType(3);
                ContentPane pane = this.getFocusedContentPane();
                String logType = pane != null ? pane.getViewType() : LogTypeEnumeration.ASCII_LOG.toString();
                ColumnCustomizer columnCustomizer = new ColumnCustomizer(this.getFrame(), "Customize columns", this.mViewConfiguration, logType);
                columnCustomizer.pack();
                columnCustomizer.setLocationRelativeTo(this.getReferenceComponent());
                columnCustomizer.show();
                Object var5_4 = null;
                this.setCursorType(0);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setCursorType(0);
                throw throwable;
            }
        } else {
            JOptionPane.showMessageDialog(null, "You have to connect to a server to customize the column settings!");
        }
    }

    public ContentPane getFocusedContentPane() {
        if (mLogPane.getSelectedIndex() != -1) {
            ContentPane contentPane = (ContentPane)mLogPane.getComponentAt(mLogPane.getSelectedIndex());
            return contentPane;
        }
        return null;
    }

    protected abstract void setContentPane();

    protected abstract void createMenuBar();

    protected abstract void createToolBar();

    protected abstract void addPopupMenu();

    protected abstract void addPanes();

    protected void initSplitPanes() {
        this.createMenuBar();
        this.createToolBar();
        this.setContentPane();
        mSplitPane = new JSplitPane(1);
        mSplitPane.setOneTouchExpandable(true);
        mSplitPane.setResizeWeight(0.0);
        mOverviewSplitPane = new JSplitPane(0);
        mOverviewSplitPane.setOneTouchExpandable(true);
        mOverviewSplitPane.setResizeWeight(1.0);
        mRightPane = new JPanel();
        mRightPane.setLayout(new BorderLayout());
        JPanel overviewPanel = OverviewFacade.createOverviewPanel(this, AbstractLogViewerAppplication.isStandalone());
        overviewPanel.addMouseListener(new OverviewSelectPopupMenu());
        mSearchPane = new SearchPane(this);
        mLogPane = new LogTablePane(this);
        this.addPopupMenu();
        mRightPane.add((Component)mSearchPane, "North");
        mRightPane.add((Component)mLogPane, "Center");
        this.updateMinSizeRightPane();
        mFilterAndSearchPanel = new FilterAndSearchPanel(this);
        this.createInitialScreen();
        mOverviewSplitPane.setTopComponent(overviewPanel);
        mOverviewSplitPane.setBottomComponent(mFilterAndSearchPanel);
        mSplitPane.setLeftComponent(mOverviewSplitPane);
        mSplitPane.setRightComponent(mRightPane);
        this.addPanes();
    }

    public void collapseLeft() {
        mOverviewSplitPane.setMinimumSize(new Dimension(0, 0));
        mOverviewSplitPane.setPreferredSize(new Dimension(0, 0));
        mFilterAndSearchPanel.setMinimumSize(new Dimension(0, 260));
        mFilterAndSearchPanel.setPreferredSize(new Dimension(0, 260));
        mSplitPane.setDividerLocation(0);
        mSplitPane.setLastDividerLocation(400);
    }

    public abstract void setSortingState(boolean var1);

    public void setErrorIndicator(ContentPane selectedContentPane) {
        selectedContentPane.showErrorsOccured(mErrorIndicator);
    }

    public void resetErrorStatus() {
        mErrorIndicator.setIcon(ViewUtil.getIcon("/images/allOkay.gif"));
        mErrorIndicator.setEnabled(true);
        mErrorIndicator.setToolTipText(TXT_MENU_NOERROR);
    }

    public void notifyAllContentPanesOfGlobalFilterChange() {
        int i = 0;
        while (i < mLogPane.getComponentCount()) {
            ContentPane contentPane = (ContentPane)mLogPane.getComponentAt(i);
            FilterAndSearchHandler newFilterandSearchHandler = new FilterAndSearchHandler(mFilterAndSearchPanel.getGlobalFilterAndSearchHandler());
            FilterAndSearchHandler oldFilterAndSearchHanlder = contentPane.getFilterAndSearch();
            Iterator itr = oldFilterAndSearchHanlder.getNonGlobalFilters().iterator();
            while (itr.hasNext()) {
                AbstractFilterSearch afs = (AbstractFilterSearch)itr.next();
                newFilterandSearchHandler.addFilterOrSearch(afs);
            }
            contentPane.filtersHaveChanged(newFilterandSearchHandler);
            ++i;
        }
        int i2 = 0;
        while (i2 < mLogPane.getUndockedWindowCount()) {
            ContentPane contentPane = mLogPane.getUndockedWindowAt(i2);
            FilterAndSearchHandler newFilterandSearchHandler = new FilterAndSearchHandler(mFilterAndSearchPanel.getGlobalFilterAndSearchHandler());
            FilterAndSearchHandler oldFilterAndSearchHanlder = contentPane.getFilterAndSearch();
            Iterator itr = oldFilterAndSearchHanlder.getNonGlobalFilters().iterator();
            while (itr.hasNext()) {
                AbstractFilterSearch afs = (AbstractFilterSearch)itr.next();
                newFilterandSearchHandler.addFilterOrSearch(afs);
            }
            contentPane.filtersHaveChanged(newFilterandSearchHandler);
            contentPane.checkForFilterChanges();
            ++i2;
        }
    }

    public void focusedTableChanged() {
        if (mLogPane.getSelectedIndex() != -1) {
            ContentPane contentPane = (ContentPane)mLogPane.getComponentAt(mLogPane.getSelectedIndex());
            contentPane.checkForFilterChanges();
            this.setSortingState(contentPane.isSorting());
            this.setErrorIndicator(contentPane);
            mSearchPane.columnNameChanged();
            this.updateMinSizeRightPane();
        }
        mFilterAndSearchPanel.focusedTableChanged();
    }

    protected void downloadAction(List logDescriptors, LogQueryExpression logQueryExpression) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(System.getProperty("user.home")));
        fc.setSelectedFile(new File("*.csv"));
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV Files");
        fc.setFileFilter(filter);
        int retMethod = fc.showSaveDialog(fc);
        File f = fc.getSelectedFile();
        String filename = f.getAbsolutePath();
        if (ViewUtil.getExtension(f) == null) {
            filename = filename + ".csv";
        }
        if (retMethod == 0) {
            try {
                DownloadProgressDialog dlg = new DownloadProgressDialog(this.getFrame(), logDescriptors, logQueryExpression, filename);
                dlg.pack();
                dlg.show();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.getFrame(), ex.getMessage());
            }
            catch (Exception e) {
                mLogger.logException(e);
            }
        }
    }

    protected void disableSorting() {
        if (mLogPane.getSelectedIndex() == -1) {
            return;
        }
        ContentPane contentPane = (ContentPane)mLogPane.getComponentAt(mLogPane.getSelectedIndex());
        if (contentPane.isSorting()) {
            contentPane.stopSorting();
            this.setSortingState(false);
        }
    }

    public void removeApplicationNodes(List applicationNodes) {
        OverviewFacade.removeApplicationNodes(applicationNodes);
    }

    public void closeOpenedLogFile(LogFileNode logFileNode) {
        String fileIndex = logFileNode.getIndex();
        int i = 0;
        while (i < mLogPane.getTabCount()) {
            String title = mLogPane.getTitleAt(i);
            if (title.equals(fileIndex)) {
                mLogPane.remove(i);
                int size = mLogPane.getTabCount();
                if (size != 0) break;
                this.changeStateOfTollBarAndMenuWhenAllFilesClose(false);
                this.createInitialScreen();
                isInitial = true;
                break;
            }
            ++i;
        }
    }

    public static boolean isOSSCopy() {
        return isOSSCopy;
    }

    public void copyAction() {
        if (mLogPane.getSelectedIndex() != -1) {
            ContentPane contentPane = (ContentPane)mLogPane.getComponentAt(mLogPane.getSelectedIndex());
            LogTable logTable = contentPane.getLogTable();
        }
    }

    public static void setOSSCopy(boolean doOSSCopy) {
        isOSSCopy = doOSSCopy;
    }

    public abstract void addFileListener();

    public void refreshLogTable() {
        block6: {
            try {
                block5: {
                    try {
                        Component component;
                        this.setCursorType(3);
                        if (mLogPane.getSelectedIndex() == -1 || (component = mLogPane.getComponentAt(mLogPane.getSelectedIndex())) == null || !(component instanceof ContentPane)) break block5;
                        ContentPane cPane = (ContentPane)component;
                        cPane.getLogTable().getBufferedTable().goToTop(cPane.getLogTable().getNumberOfRecordsShown());
                    }
                    catch (UndeclaredThrowableException ex) {
                        ExceptionDialog.showErrorMessage(this.getFrame(), ex, "Please close currently displayed log and re-display it.");
                        Object var4_6 = null;
                        this.setCursorType(0);
                        break block6;
                    }
                    catch (BAMSysRuntimeException ex) {
                        ExceptionDialog.showErrorMessage(this.getFrame(), (Throwable)((Object)ex), "Please close currently displayed log and re-display it.");
                        Object var4_7 = null;
                        this.setCursorType(0);
                    }
                }
                Object var4_5 = null;
                this.setCursorType(0);
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.setCursorType(0);
                throw throwable;
            }
        }
    }

    public IViewConfiguration getViewConfiguration() {
        return this.mViewConfiguration;
    }

    public void initColumnSettingsForFilterPanel() {
        ((DefaultFilterPanel)AbstractLogViewerAppplication.mFilterAndSearchPanel.defaultSearchFilterTab).tabSelected();
    }

    public abstract void addDirectoryListener();

    public abstract void setConfiguratedConnections(List var1);

    public abstract List getConfiguratedConnections();

    public abstract void changeStateOfTollBarAndMenuWhenAllFilesClose(boolean var1);

    public abstract void changeStateOfToolBarAndMenu(boolean var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        isInitial = true;
        isStandalone = false;
        directLog = false;
        BLOCK_TEXT_COLUMN_SIZE = ViewProperty.getInstance().getInt(ViewProperty.OSS_COPY_LENGTH) == 0 ? 71 : ViewProperty.getInstance().getInt(ViewProperty.OSS_COPY_LENGTH);
        isOSSCopy = false;
    }

    protected class OverviewSelectActionListener
    implements ActionListener {
        protected OverviewSelectActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            if (e.getActionCommand().equals("ToggleOverviewDisplay")) {
                AbstractLogViewerAppplication.this.toggleOverviewDisplayMode();
                return;
            }
        }
    }

    public class OverviewSelectPopupMenu
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OverviewSelectActionListener anActionListener = new OverviewSelectActionListener();
                JPopupMenu aPopupMenu = new JPopupMenu();
                JMenuItem aMenuItem = new JMenuItem(AbstractLogViewerAppplication.this.getOverviewModeActionText());
                aMenuItem.setActionCommand("ToggleOverviewDisplay");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected class TabCloseActionListener
    implements ActionListener {
        private LogTablePane mPane;

        public TabCloseActionListener(LogTablePane aTabbedPane) {
            this.mPane = aTabbedPane;
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            String actionCommand = source.getActionCommand();
            if (actionCommand.equals("Undock")) {
                this.mPane.unDockSelectedPane();
                return;
            }
            if (actionCommand.equals("Download")) {
                AbstractLogViewerAppplication.this.saveToFileAction();
                return;
            }
            if (actionCommand.equals("SearchResult")) {
                ContentPane contentPane = (ContentPane)this.mPane.getComponentAt(this.mPane.getSelectedIndex());
                contentPane.showSearchResult(source.isSelected());
                return;
            }
            if (actionCommand.equals("Close this tab")) {
                AbstractLogViewerAppplication.this.doCloseLogWindow(this.mPane, null);
                return;
            }
            if (actionCommand.equals("Close All")) {
                AbstractLogViewerAppplication.this.closeAllLog();
                AbstractLogViewerAppplication.this.resetErrorStatus();
                return;
            }
            if (actionCommand.equals("Details")) {
                this.showLogViewDetails(this.mPane.getSelectedIndex());
                return;
            }
            if (actionCommand.equals("show filter")) {
                this.showFilter(this.mPane.getSelectedIndex());
            }
        }

        protected void showFilter(int index) {
            ContentPane contentPane = (ContentPane)this.mPane.getComponentAt(index);
            FilterAndSearchHandler handler = contentPane.getFilterAndSearch();
            if (handler.getFilterCount() == 0) {
                JOptionPane.showMessageDialog(this.mPane, "Currently there are no filters applied to this table.");
            } else {
                FilterSearchDialog filterSearchDialog = new FilterSearchDialog(handler);
                filterSearchDialog.pack();
                filterSearchDialog.show();
            }
        }

        protected void showLogViewDetails(int index) {
            ContentPane contentPane = (ContentPane)this.mPane.getComponentAt(index);
            List fileNodes = contentPane.getLogFileNodes();
            if (fileNodes.size() > 0) {
                LogViewDetailsDialog dlg = new LogViewDetailsDialog(AbstractLogViewerAppplication.this.getFrame(), this.mPane.getApplication(), fileNodes, AbstractLogViewerAppplication.isStandalone());
                if (fileNodes.size() > 1) {
                    dlg.setTitle("Details for Selected Merged Log");
                } else {
                    dlg.setTitle("Details for Selected Log");
                }
                dlg.pack();
                dlg.setLocationRelativeTo(AbstractLogViewerAppplication.this.getFrame());
                dlg.show();
            }
        }
    }
}

