/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.util;

import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$util$XMLHelper == null ? (class$com$sapmarkets$bam$util$XMLHelper = XMLHelper.class$("com.sapmarkets.bam.util.XMLHelper")) : class$com$sapmarkets$bam$util$XMLHelper);
    static /* synthetic */ Class class$com$sapmarkets$bam$util$XMLHelper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document buildDOMFromXML(InputStream aStream) {
        Document document = null;
        try {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((class$com$sapmarkets$bam$util$XMLHelper == null ? (class$com$sapmarkets$bam$util$XMLHelper = XMLHelper.class$("com.sapmarkets.bam.util.XMLHelper")) : class$com$sapmarkets$bam$util$XMLHelper).getClassLoader());
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                Thread.currentThread().setContextClassLoader(cl);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(new InputSource(aStream));
            }
            catch (FileNotFoundException fnfe) {
                mLogger.logException(fnfe);
                throw new BAMRuntimeException(mLogger.getLocation(), "EXCEPTION_CAUGHT", new Object[]{"FileNotFouneException", aStream}, fnfe);
            }
            catch (IOException ioe) {
                mLogger.logException(ioe);
                throw new BAMRuntimeException(mLogger.getLocation(), "EXCEPTION_CAUGHT", new Object[]{"IOException", aStream}, ioe);
            }
            catch (ParserConfigurationException pce) {
                mLogger.logException(pce);
                throw new BAMRuntimeException(mLogger.getLocation(), "EXCEPTION_CAUGHT", new Object[]{"ParserEConfigurationxception", aStream}, pce);
            }
            catch (SAXException se) {
                mLogger.logException(se);
                throw new BAMRuntimeException(mLogger.getLocation(), "EXCEPTION_CAUGHT", new Object[]{"SAXException", aStream}, se);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                aStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        aStream.close();
        return document;
    }

    public static Document buildDOMFromScratch() {
        Document document = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sapmarkets$bam$util$XMLHelper == null ? (class$com$sapmarkets$bam$util$XMLHelper = XMLHelper.class$("com.sapmarkets.bam.util.XMLHelper")) : class$com$sapmarkets$bam$util$XMLHelper).getClassLoader());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            mLogger.logException(pce);
            throw new BAMRuntimeException(mLogger.getLocation(), "EXCEPTION_CAUGHT", new Object[]{"ParserConfigurationException", "the scratch"}, pce);
        }
        return document;
    }

    public static List getSignificantChildNodes(Node aNode) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (aNode == null) {
            return list;
        }
        if (aNode.getNodeType() != 1 && aNode.getNodeType() != 3) {
            return list;
        }
        NodeList nodeList = aNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            String value = node.getNodeValue();
            if (!(type != 1 && type != 3 || type == 3 && value == null || type == 3 && value != null && value.trim().equals(""))) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    public static Node getChildNodeByTag(Node aNode, String aTag) {
        if (aNode.getNodeType() != 1 && aNode.getNodeType() != 3) {
            return null;
        }
        NodeList nodeList = aNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (aTag.equals(node.getNodeName())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public static List getChildNodesByTag(Node aNode, String aTag) {
        if (aNode.getNodeType() != 1 && aNode.getNodeType() != 3) {
            return null;
        }
        List childList = XMLHelper.getSignificantChildNodes(aNode);
        ArrayList<Node> result = new ArrayList<Node>();
        int i = 0;
        while (i < childList.size()) {
            Node node = (Node)childList.get(i);
            if (aTag.equals(node.getNodeName())) {
                result.add(node);
            }
            ++i;
        }
        return result;
    }

    public static Properties getAttributes(Node aNode) {
        Properties properties = null;
        if (aNode.hasAttributes()) {
            properties = new Properties();
            NamedNodeMap attributes = aNode.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                ((Hashtable)properties).put(attribute.getNodeName(), attribute.getNodeValue());
                ++i;
            }
        }
        return properties;
    }

    public static String getAttributeValue(Node aNode, String aProperty) {
        if (aNode.hasAttributes()) {
            NamedNodeMap attributes = aNode.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                if (aProperty.equals(attribute.getNodeName())) {
                    return attribute.getNodeValue();
                }
                ++i;
            }
        }
        return null;
    }

    public static List search(String aQuery, Node aNode) {
        ArrayList<Node> result = new ArrayList<Node>();
        StringTokenizer queryTokens = new StringTokenizer(aQuery = XMLHelper.trimSlashesAtTheFront(aQuery), "/");
        int numberOfTokens = queryTokens.countTokens();
        if (numberOfTokens == 0) {
            return result;
        }
        String currentToken = queryTokens.nextToken();
        if (currentToken.equals(aNode.getNodeName())) {
            if (numberOfTokens == 1) {
                result.add(aNode);
                return result;
            }
            NodeList children = aNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                List temp = XMLHelper.search(aQuery.substring(currentToken.length()), node);
                if (temp != null) {
                    result.addAll(temp);
                    temp = null;
                }
                ++i;
            }
            return result;
        }
        return result;
    }

    public static List search(String aQuery, String anAttributeName, String anAttributeValue, Node aNode) {
        ArrayList result = new ArrayList();
        List temp = XMLHelper.search(aQuery, aNode);
        int size = temp.size();
        if (size == 0) {
            return result;
        }
        int i = 0;
        while (i < size) {
            NamedNodeMap attributes = ((Node)temp.get(i)).getAttributes();
            int j = 0;
            while (j < attributes.getLength()) {
                Node attribute = attributes.item(j);
                if (anAttributeName.equals(attribute.getNodeName()) && anAttributeValue.equals(attribute.getNodeValue())) {
                    result.add(temp.get(i));
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static List getTextValues(String aSubquery, List aList) {
        int size = aList.size();
        if (size == 0) {
            return aList;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            Node node = (Node)aList.get(i);
            List temp = XMLHelper.search(node.getNodeName() + aSubquery, node);
            int j = 0;
            while (j < temp.size()) {
                result.add(XMLHelper.getTextBetweenTags((Node)temp.get(j)));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static String getTextBetweenTags(Node aNode) {
        List list = XMLHelper.getSignificantChildNodes(aNode);
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < list.size()) {
            String value;
            Node node = (Node)list.get(i);
            if (node.getNodeType() == 3 && (value = node.getNodeValue()) != null && !"".equals(value.trim())) {
                result.append(value);
            }
            ++i;
        }
        return result.toString();
    }

    private static String trimSlashesAtTheFront(String aString) {
        int i = 0;
        while (i < aString.length()) {
            if (aString.charAt(i) != '/') {
                return aString.substring(i);
            }
            ++i;
        }
        return aString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void printDocumentToFile(Node aRoot, File aFile) throws IOException {
        FileWriter fw;
        block12: {
            int indentLevel = -1;
            int numberOfSpacesForEachIndentation = 4;
            BufferedWriter aBufferedWriter = null;
            fw = null;
            try {
                try {
                    fw = new FileWriter(aFile);
                    aBufferedWriter = new BufferedWriter(new FileWriter(aFile));
                    aBufferedWriter.write("<?xml version=\"1.0\" encoding=\"" + fw.getEncoding() + "\" ?>");
                    if (aRoot != null) {
                        XMLHelper.print(aRoot, aBufferedWriter, indentLevel, numberOfSpacesForEachIndentation);
                    }
                }
                catch (IOException anIOException) {
                    mLogger.logException(anIOException);
                    throw anIOException;
                }
                Object var8_6 = null;
                if (null == aBufferedWriter) break block12;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (null != aBufferedWriter) {
                    try {
                        aBufferedWriter.close();
                    }
                    catch (IOException anIOException) {
                        mLogger.logException(anIOException);
                        throw anIOException;
                    }
                }
                if (null == fw) throw throwable;
                try {
                    fw.close();
                    throw throwable;
                }
                catch (IOException anIOException) {
                    mLogger.logException(anIOException);
                    throw anIOException;
                }
            }
            try {}
            catch (IOException anIOException) {
                mLogger.logException(anIOException);
                throw anIOException;
            }
            aBufferedWriter.close();
        }
        if (null == fw) return;
        try {}
        catch (IOException anIOException) {
            mLogger.logException(anIOException);
            throw anIOException;
        }
        fw.close();
    }

    private static void print(Node aNode, BufferedWriter aBufferedWriter, int anIndentLevel, int aNumberOfSpacesForEachIndentation) throws IOException {
        aBufferedWriter.newLine();
        XMLHelper.printIndentation(aBufferedWriter, ++anIndentLevel, aNumberOfSpacesForEachIndentation);
        aBufferedWriter.write("<");
        aBufferedWriter.write(aNode.getNodeName());
        if (aNode.hasAttributes()) {
            XMLHelper.printAttributes(aNode, aBufferedWriter);
        }
        if (aNode.hasChildNodes()) {
            aBufferedWriter.write(">");
            List childNodes = XMLHelper.getSignificantChildNodes(aNode);
            if (null != childNodes) {
                if (childNodes.size() == 1 && ((Node)childNodes.get(0)).getNodeType() == 3) {
                    String text = XMLHelper.getTextBetweenTags(aNode);
                    aBufferedWriter.write(text);
                    aBufferedWriter.write("</" + aNode.getNodeName() + ">");
                    --anIndentLevel;
                    return;
                }
                int i = 0;
                while (i < childNodes.size()) {
                    Node node = (Node)childNodes.get(i);
                    XMLHelper.print(node, aBufferedWriter, anIndentLevel, aNumberOfSpacesForEachIndentation);
                    ++i;
                }
                aBufferedWriter.newLine();
                XMLHelper.printIndentation(aBufferedWriter, anIndentLevel, aNumberOfSpacesForEachIndentation);
                aBufferedWriter.write("</" + aNode.getNodeName() + ">");
                --anIndentLevel;
            }
        } else {
            aBufferedWriter.write("/>");
            --anIndentLevel;
        }
        aBufferedWriter.flush();
    }

    private static void printIndentation(BufferedWriter aBufferedWriter, int anIndentLevel, int aNumberOfSpacesForEachIndentation) throws IOException {
        int i = anIndentLevel * aNumberOfSpacesForEachIndentation;
        while (i > 0) {
            aBufferedWriter.write(" ");
            --i;
        }
    }

    private static void printAttributes(Node aNode, BufferedWriter aBufferedWriter) throws IOException {
        aBufferedWriter.write(" ");
        NamedNodeMap attributes = aNode.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            aBufferedWriter.write(" ");
            aBufferedWriter.write(attribute.getNodeName());
            aBufferedWriter.write("=");
            aBufferedWriter.write("\"" + attribute.getNodeValue() + "\"");
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

