/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.util;

import com.sapmarkets.bam.util.Executor;

public class PooledExecutor
implements Executor {
    private int maxNumThreads;
    private int numOfThreadsRunning;
    private static int mThreadCounter = 0;

    public PooledExecutor(int maxNumThreads) {
        this.maxNumThreads = maxNumThreads;
    }

    public void execute(Runnable runnable) throws InterruptedException {
        PooledExecutor pooledExecutor = this;
        synchronized (pooledExecutor) {
            while (this.numOfThreadsRunning >= this.maxNumThreads) {
                this.wait();
            }
            ++this.numOfThreadsRunning;
        }
        new Thread((Runnable)new WorkerThread(runnable), "SAPEngine_PooledThread_" + mThreadCounter++).start();
    }

    protected class WorkerThread
    implements Runnable {
        private Runnable runnable;

        protected WorkerThread(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() {
            this.runnable.run();
            PooledExecutor pooledExecutor = PooledExecutor.this;
            synchronized (pooledExecutor) {
                PooledExecutor.this.numOfThreadsRunning--;
                PooledExecutor.this.notifyAll();
            }
        }
    }
}

