/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.util;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sapmarkets.bam.logcontroller.ManualInitLogging;
import com.sapmarkets.bam.util.BAMConfigurationHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;

public abstract class Loggable {
    private static PropertiesConfigurator mProperties = null;
    public static final String LOGGING_PROPERTIES_FILE = "LogViewerLogging.properties";
    protected Location mLocation;
    protected Category mCategory;
    static /* synthetic */ Class class$com$sapmarkets$bam$util$Logger;

    public Loggable(String location) {
        if (ManualInitLogging.isStandaloneJVM()) {
            Loggable.setUpConfiguration();
        }
        this.mLocation = Location.getLocation((String)location);
    }

    public static void setUpConfiguration() {
        if (null == mProperties && (mProperties = BAMConfigurationHandler.getLoggingProperties() != null ? new PropertiesConfigurator(BAMConfigurationHandler.getLoggingProperties(), (class$com$sapmarkets$bam$util$Logger == null ? (class$com$sapmarkets$bam$util$Logger = Loggable.class$("com.sapmarkets.bam.util.Logger")) : class$com$sapmarkets$bam$util$Logger).getClassLoader()) : new PropertiesConfigurator(new File(BAMConfigurationHandler.getFilePath(LOGGING_PROPERTIES_FILE)), (class$com$sapmarkets$bam$util$Logger == null ? (class$com$sapmarkets$bam$util$Logger = Loggable.class$("com.sapmarkets.bam.util.Logger")) : class$com$sapmarkets$bam$util$Logger).getClassLoader())) != null) {
            mProperties.configure();
        }
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public Category getCategory() {
        return this.mCategory;
    }

    public abstract LogController getLogController();

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStackTrace(Throwable aT) {
        if (aT == null) {
            return "No exception occured (null)";
        }
        ByteArrayOutputStream aBufStream = null;
        String aStack = null;
        aBufStream = new ByteArrayOutputStream();
        aT.printStackTrace(new PrintStream(aBufStream));
        aStack = aBufStream.toString();
        Object var5_3 = null;
        if (aBufStream == null) return aStack;
        try {
            aBufStream.close();
            return aStack;
        }
        catch (IOException exception) {}
        return aStack;
        {
            catch (Exception e) {
                aStack = "Exception stack not available\n" + e.getMessage() + ")";
                Object var5_4 = null;
                if (aBufStream == null) return aStack;
                try {
                    aBufStream.close();
                    return aStack;
                }
                catch (IOException exception) {}
                return aStack;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (aBufStream == null) throw throwable;
            try {
                aBufStream.close();
                throw throwable;
            }
            catch (IOException exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void printThreads() {
        Thread[] threads = new Thread[64];
        int i = 0;
        int count = Thread.enumerate(threads);
        while (i < count) {
            System.out.println("Thread " + i + " = " + threads[i].getName() + ", Daemon = " + threads[i].isDaemon());
            ++i;
        }
    }

    public boolean isDebugEnabled() {
        return this.getLogController().beDebug();
    }

    public boolean isInfoEnabled() {
        return this.getLogController().beInfo();
    }

    public boolean isWarningEnabled() {
        return this.getLogController().beWarning();
    }

    public boolean isErrorEnabled() {
        return this.getLogController().beError();
    }

    public boolean isFatalEnabled() {
        return this.getLogController().beFatal();
    }

    public abstract void logOrTraceError(String var1);

    public void logException(Throwable anException) {
        String logText = Loggable.getStackTrace(anException);
        this.logOrTraceError(logText);
    }

    public void logOriginalException(Throwable throwable) {
        Throwable next;
        Method method;
        this.logOrTraceError(throwable.toString());
        Class<?> clazz = throwable.getClass();
        try {
            method = clazz.getMethod("getCause", null);
            next = (Throwable)method.invoke((Object)throwable, null);
            if (next != null) {
                this.logOriginalException(next);
                return;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            method = clazz.getMethod("getTargetException", null);
            next = (Throwable)method.invoke((Object)throwable, null);
            if (next != null) {
                this.logOriginalException(next);
                return;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String logText = "Originated from: " + Loggable.getStackTrace(throwable);
        this.logOrTraceError(logText);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

