/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.util;

import com.sapmarkets.bam.util.Executor;

public class ConnectorClientPooledExecutor
implements Executor {
    final int NUM_OF_THREADS = 5;
    ThreadStack stack = new ThreadStack();
    private ConnectorClientPooledExecutor mInstance;

    public static synchronized ConnectorClientPooledExecutor getInstance() {
        return new ConnectorClientPooledExecutor();
    }

    private ConnectorClientPooledExecutor() {
        int i = 0;
        while (i < 5) {
            WorkerThread worker = new WorkerThread("SAPEngine_ConnectorPooledThread_" + i);
            worker.start();
            ++i;
        }
    }

    public void execute(Runnable runnable) throws InterruptedException {
        WorkerThread workerThread = (WorkerThread)this.stack.pop();
        workerThread.setRunnable(runnable);
        Object object = workerThread.lock;
        synchronized (object) {
            workerThread.lock.notifyAll();
        }
    }

    public String toString() {
        return "Number of worker threads = " + this.stack.mThreads.length;
    }

    private class ThreadStack {
        Thread[] mThreads = new Thread[5];
        int mCurrentStackPointer = 0;

        private ThreadStack() {
        }

        public void push(Thread thread) {
            ThreadStack threadStack = this;
            synchronized (threadStack) {
                this.mThreads[this.mCurrentStackPointer] = thread;
                ++this.mCurrentStackPointer;
                this.notifyAll();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Thread pop() {
            ThreadStack threadStack = this;
            synchronized (threadStack) {
                while (this.mCurrentStackPointer == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return this.mThreads[--this.mCurrentStackPointer];
            }
        }
    }

    protected class WorkerThread
    extends Thread {
        private Runnable mRunnable;
        Object lock = new Object();

        public WorkerThread(String threadName) {
            super(threadName);
        }

        public void run() throws OutOfMemoryError {
            while (true) {
                Object object;
                try {
                    object = this;
                    synchronized (object) {
                        if (this.mRunnable != null) {
                            this.mRunnable.run();
                        }
                    }
                }
                catch (OutOfMemoryError error) {
                    error.printStackTrace();
                    throw error;
                }
                object = this.lock;
                synchronized (object) {
                    try {
                        ConnectorClientPooledExecutor.this.stack.push(this);
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        this.lock.notifyAll();
                    }
                }
            }
        }

        public synchronized void setRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }
    }
}

