/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.util;

public class CircularBuffer {
    private CircList queue;
    int head;
    int tail;
    int headUserIndex;
    int tailUserIndex;
    private boolean lastAddedAtTail;
    private boolean isGrowingIndefinitively;
    private int bufSize;

    public CircularBuffer(int size) {
        if (size == 0) {
            this.isGrowingIndefinitively = true;
            this.queue = new CircList(1500);
        } else {
            this.isGrowingIndefinitively = false;
            this.bufSize = size;
            this.queue = new CircList(size);
        }
        this.reset();
    }

    private int nextIndex(int index) {
        int result = this.isGrowingIndefinitively ? index + 1 : (index + 1) % this.bufSize;
        return result;
    }

    private int previousIndex(int index) throws IllegalArgumentException, IllegalStateException {
        if (this.isGrowingIndefinitively) {
            throw new IllegalStateException("Growing buffer does not getPrvious!");
        }
        if (index == 0) {
            index = this.bufSize - 1;
            return index;
        }
        if (index < 0) {
            throw new IllegalArgumentException("Index in circ buffer is smaller than 0");
        }
        return (index - 1) % this.bufSize;
    }

    public void reset() {
        this.head = this.bufSize - 1;
        this.tail = 0;
        this.headUserIndex = -1;
        this.tailUserIndex = 0;
    }

    public void empty() {
        this.reset();
        this.queue.empty();
    }

    public int addToTail(Object object) {
        this.lastAddedAtTail = true;
        this.queue.set(this.tail, object);
        this.tail = this.nextIndex(this.tail);
        if (this.tail == this.nextIndex(this.head)) {
            this.head = this.nextIndex(this.head);
            ++this.headUserIndex;
        }
        ++this.tailUserIndex;
        return this.tail;
    }

    public void informAboutTurnAbout(boolean pointerAtTail) {
        this.lastAddedAtTail = pointerAtTail;
    }

    public int addToHead(Object object) throws IllegalStateException {
        if (this.isGrowingIndefinitively) {
            throw new IllegalStateException("Growing buffer does not allow adding to head!");
        }
        this.lastAddedAtTail = false;
        this.queue.set(this.head, object);
        this.head = this.previousIndex(this.head);
        if (this.head == this.previousIndex(this.tail)) {
            this.tail = this.previousIndex(this.tail);
            --this.tailUserIndex;
        }
        --this.headUserIndex;
        return this.head;
    }

    public Object get(int userIndex) throws IllegalArgumentException {
        Object result;
        if (this.isGrowingIndefinitively) {
            return this.queue.get(userIndex);
        }
        if (userIndex > this.tailUserIndex || userIndex < this.headUserIndex) {
            throw new IllegalArgumentException("CircBuffer: get (" + userIndex + ") not in [" + this.headUserIndex + ", " + this.tailUserIndex + "]");
        }
        if (userIndex > this.bufSize - 1) {
            result = this.queue.get(userIndex % this.bufSize);
        } else if (userIndex < 0) {
            int effectiveUserIndex = this.bufSize + (userIndex % this.bufSize == 0 ? this.bufSize * -1 : userIndex % this.bufSize);
            result = this.queue.get(effectiveUserIndex);
        } else {
            result = this.queue.get(userIndex);
        }
        return result;
    }

    public String toString() {
        return "CircBuffer tail,head =[" + this.tail + ", " + this.head + "] userIDX (h, t)=[" + this.headUserIndex + ", " + this.tailUserIndex + "] size= " + this.size();
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public int size() {
        if (this.isGrowingIndefinitively) {
            return this.headUserIndex - this.tailUserIndex > 0 ? this.headUserIndex - this.tailUserIndex : this.tailUserIndex - this.headUserIndex;
        }
        return this.tail == this.head ? this.bufSize : this.tail + (this.bufSize - this.head) - 1;
    }

    public int getHeadUserIndex() {
        return this.headUserIndex;
    }

    public int getTailUserIndex() {
        return this.tailUserIndex;
    }

    public int calculateRequestedStartUserindex(int requestedStartUserindex, int size) {
        if (this.lastAddedAtTail) {
            return requestedStartUserindex + size;
        }
        return requestedStartUserindex - size;
    }

    public int getFilePointerUserIndex() {
        if (this.lastAddedAtTail) {
            return this.getTailUserIndex();
        }
        return this.getHeadUserIndex();
    }

    public boolean isLastAddedAtTail() {
        return this.lastAddedAtTail;
    }

    private class CircList {
        private Object[] _data;
        private int _size;

        public CircList(int size) {
            this._data = new Object[size];
            this._size = size;
        }

        public int size() {
            return this._size;
        }

        public Object get(int i) throws ArrayIndexOutOfBoundsException {
            return this._data[i];
        }

        public void set(int index, Object o) throws ArrayIndexOutOfBoundsException {
            if (index == this._size) {
                this._size *= 2;
                Object[] newData = new Object[this._size];
                int i = 0;
                while (i < this._size) {
                    newData[i] = this._data[i];
                    ++i;
                }
                this._data = newData;
            }
            this._data[index] = o;
        }

        public Object remove(int index) throws ArrayIndexOutOfBoundsException {
            Object result = this.get(index);
            this._data[index] = null;
            return result;
        }

        public void empty() {
            this._data = new Object[this._size];
        }
    }
}

