/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.util;

import com.sap.tc.logging.Location;
import com.sapmarkets.bam.util.BAMRuntimeException;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class BAMConfigurationHandler {
    private static String mRootPath;
    private static final String LOG_VIEWER_PROPERTIES_DIRECTORY = "";
    private static Properties serverProperties;
    private static Properties loggingProperties;
    private static Properties logviewerProperties;
    static /* synthetic */ Class class$com$sapmarkets$bam$util$BAMConfigurationHandler;

    public BAMConfigurationHandler(Properties aServerProperties) {
        serverProperties = aServerProperties;
        loggingProperties = BAMConfigurationHandler.extractLoggingProperties(serverProperties);
        logviewerProperties = BAMConfigurationHandler.extractLogviewerProperties(serverProperties);
    }

    private static void init() {
        Properties systemProperties = System.getProperties();
        String fileSeparator = systemProperties.getProperty("file.separator");
        String configPath = null;
        configPath = System.getProperty("cfg.path");
        mRootPath = configPath != null ? configPath : systemProperties.getProperty("user.home") + fileSeparator + LOG_VIEWER_PROPERTIES_DIRECTORY;
        if (null == mRootPath) {
            throw new BAMRuntimeException(Location.getLocation((Class)(class$com$sapmarkets$bam$util$BAMConfigurationHandler == null ? (class$com$sapmarkets$bam$util$BAMConfigurationHandler = BAMConfigurationHandler.class$("com.sapmarkets.bam.util.BAMConfigurationHandler")) : class$com$sapmarkets$bam$util$BAMConfigurationHandler)), "Please specify -Dcfg.path in your command line.If not, there should be a directory called '' directory in your HOME directory!");
        }
    }

    public static String getConfigPath() {
        BAMConfigurationHandler.init();
        return mRootPath;
    }

    public static String getFilePath(String aFileName) {
        BAMConfigurationHandler.init();
        File aFile = new File(aFileName);
        if (aFile.isAbsolute()) {
            return aFile.getPath();
        }
        return mRootPath + File.separator + aFileName;
    }

    public static Properties getLoggingProperties() {
        return loggingProperties;
    }

    public static Properties getLogviewerProperties() {
        return logviewerProperties;
    }

    private static Properties extractLoggingProperties(Properties props) {
        Properties logging = new Properties();
        Enumeration propKeys = ((Hashtable)props).keys();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            if (key.startsWith("Logviewer")) continue;
            logging.setProperty(key, props.getProperty(key));
        }
        return logging;
    }

    private static Properties extractLogviewerProperties(Properties props) {
        Properties tempProperties = props;
        Properties logviewerProperties = new Properties();
        Enumeration propKeys = ((Hashtable)tempProperties).keys();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            if (!key.startsWith("Logviewer")) continue;
            String value = tempProperties.getProperty(key);
            logviewerProperties.setProperty(key.substring(10, key.length()), value);
        }
        return logviewerProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

