/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.queryexpr;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.util.SUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class SingleQueryExpression
implements LogQueryExpression {
    private Map mSearchParameters;
    private String mOperationDisplayName;
    final String SPACE = " ";
    MonitoredDataDefinition mMonitoredDataDef;
    public static final long serialVersionUID = SUID.getID();

    public SingleQueryExpression(MonitoredDataDefinition aMonitoredDataDef, String anOperationDisplayName) {
        this.mMonitoredDataDef = aMonitoredDataDef;
        this.mOperationDisplayName = anOperationDisplayName;
        this.mSearchParameters = new HashMap();
    }

    public MonitoredDataDefinition getMonitoredDataDef() {
        return this.mMonitoredDataDef;
    }

    public String getOperationDisplayName() {
        return this.mOperationDisplayName;
    }

    public Collection getSearchParameters() {
        return Collections.unmodifiableCollection(this.mSearchParameters.values());
    }

    public ParameterDescriptor getSearchParameter(String paramName) {
        return (ParameterDescriptor)this.mSearchParameters.get(paramName);
    }

    public boolean evaluate(LogRecord aLogRecord) {
        return true;
    }

    protected void setSearchParameters(Collection someParams) {
        this.mSearchParameters = new HashMap();
        Iterator itr = someParams.iterator();
        while (itr.hasNext()) {
            ParameterDescriptor param = (ParameterDescriptor)itr.next();
            this.mSearchParameters.put(param.getName(), param);
        }
    }

    public String toString() {
        return this.mOperationDisplayName + " params: " + (this.mSearchParameters != null ? this.mSearchParameters.toString() : "no parameters");
    }

    public abstract int getqueryType();

    public boolean hasChildren() {
        return false;
    }

    public Collection getChildren() {
        return new ArrayList();
    }

    public abstract String printExpression();
}

