/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.queryexpr;

import com.sap.tc.logging.Severity;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.queryexpr.SingleQueryExpression;
import com.sapmarkets.bam.util.SUID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SeverityExpression
extends SingleQueryExpression {
    public static final int EXPRESSION_TYPE = 42;
    private Map mOperation = new HashMap();
    public static final String REG_EXPR_PARAM_NAME = "Value to be compared";
    public static final String OPERATION = "Operator";
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = 2;
    public static final int EQUAL_T0 = 3;
    public static final int GREATER_THAN_OR_EQUAL_TO = 4;
    public static final int LESS_THAN_OR_EQUAL_TO = 5;
    private Map mStringOperatorMap = new HashMap();
    private int mIndexOfMDinLR = -1;
    private int mValueToBecomparedAgainst = -1;
    public static final long serialVersionUID = SUID.getID();
    static /* synthetic */ Class class$java$lang$String;

    public SeverityExpression(MonitoredDataDefinition aMonitoredDataDef, String anOperationDisplayName) {
        super(aMonitoredDataDef, anOperationDisplayName);
        ParameterDescriptor param = new ParameterDescriptor(REG_EXPR_PARAM_NAME, class$java$lang$String == null ? (class$java$lang$String = SeverityExpression.class$("java.lang.String")) : class$java$lang$String);
        HashSet<ParameterDescriptor> parameters = new HashSet<ParameterDescriptor>();
        parameters.add(param);
        this.setSearchParameters(parameters);
    }

    public SeverityExpression(MonitoredDataDefinition aMonitoredDataDef, String anOperationDisplayName, Map otherParams) {
        this(aMonitoredDataDef, anOperationDisplayName);
        this.mOperation = otherParams;
    }

    public boolean evaluate(LogRecord aLogRecord) {
        int operation;
        if (this.mMonitoredDataDef == null) {
            return true;
        }
        if (this.mValueToBecomparedAgainst == -1) {
            String regExp = (String)this.getSearchParameter(REG_EXPR_PARAM_NAME).getValue();
            if (regExp == null) {
                return true;
            }
            this.mValueToBecomparedAgainst = Severity.parse((String)regExp);
        }
        int n = operation = this.mOperation.get(OPERATION) == null ? 3 : (Integer)this.mOperation.get(OPERATION);
        if (this.mIndexOfMDinLR == -1) {
            this.mIndexOfMDinLR = this.findIndexOfMDinLogRecord(aLogRecord);
        }
        String valueToBeSearched = aLogRecord.getMonitoredDataAt(this.mIndexOfMDinLR).getValueAsString();
        return this.applyRegExp(valueToBeSearched, this.mValueToBecomparedAgainst, operation);
    }

    private int findIndexOfMDinLogRecord(LogRecord lr) {
        List monitoredDatum = lr.getMonitoredData();
        Iterator itr = monitoredDatum.iterator();
        MonitoredData monitoredData = null;
        int i = 0;
        while (itr.hasNext()) {
            monitoredData = (MonitoredData)itr.next();
            MonitoredDataDefinition mdd = monitoredData.getDefinition();
            if (this.mMonitoredDataDef.equals(mdd)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("findIndexOfMDinLogRecord: the MDD was not found in LogRecord! ReaderSettings.xml may be wrong!");
    }

    private boolean applyRegExp(String aValueToBeSearched, int valueToBecomparedAgainst, int operation) {
        aValueToBeSearched = aValueToBeSearched.toUpperCase();
        switch (operation) {
            case 1: {
                return Severity.parse((String)aValueToBeSearched) > valueToBecomparedAgainst;
            }
            case 2: {
                return Severity.parse((String)aValueToBeSearched) < valueToBecomparedAgainst;
            }
            case 3: {
                return Severity.parse((String)aValueToBeSearched) == valueToBecomparedAgainst;
            }
            case 4: {
                return Severity.parse((String)aValueToBeSearched) >= valueToBecomparedAgainst;
            }
            case 5: {
                return Severity.parse((String)aValueToBeSearched) <= valueToBecomparedAgainst;
            }
        }
        return false;
    }

    public int getqueryType() {
        return 42;
    }

    public String printExpression() {
        String severity = (String)this.getSearchParameter(REG_EXPR_PARAM_NAME).getValue();
        int operation = this.mOperation.get(OPERATION) == null ? 3 : (Integer)this.mOperation.get(OPERATION);
        String operator = this.getEquivalentOperatorString(operation);
        return operator + " " + severity;
    }

    private String getEquivalentOperatorString(int operator) {
        switch (operator) {
            case 1: {
                return ">";
            }
            case 2: {
                return "<";
            }
            case 3: {
                return "=";
            }
            case 4: {
                return ">=";
            }
            case 5: {
                return "<=";
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

