/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.queryexpr;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.queryexpr.SingleQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.SUID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class PreDateExpression
extends SingleQueryExpression {
    public static final long serialVersionUID = SUID.getID();
    public static final String OPERATION_DISPLAY_NAME = "Search before a specific Date";
    public static final String REG_EXPR_PARAM_NAME = "before";
    public static final int EXPRESSION_TYPE = 30;
    private Date mDateToBeSearchedAgainst;
    static /* synthetic */ Class class$java$util$Date;

    public PreDateExpression(Date dateToBeSearchedAgainst) throws BAMAppException {
        super(new MonitoredDataDefinition("time", "Date", new ArrayList(), true, true, true, "Normal", "", "", 1, 10, false), OPERATION_DISPLAY_NAME);
        this.mDateToBeSearchedAgainst = dateToBeSearchedAgainst;
        ParameterDescriptor param = new ParameterDescriptor(REG_EXPR_PARAM_NAME, class$java$util$Date == null ? (class$java$util$Date = PreDateExpression.class$("java.util.Date")) : class$java$util$Date);
        param.setValue(dateToBeSearchedAgainst);
        HashSet<ParameterDescriptor> parameters = new HashSet<ParameterDescriptor>();
        parameters.add(param);
        this.setSearchParameters(parameters);
    }

    public PreDateExpression(MonitoredDataDefinition aDataDef) {
        super(aDataDef, OPERATION_DISPLAY_NAME);
        ParameterDescriptor param = new ParameterDescriptor(REG_EXPR_PARAM_NAME, class$java$util$Date == null ? (class$java$util$Date = PreDateExpression.class$("java.util.Date")) : class$java$util$Date);
        HashSet<ParameterDescriptor> parameters = new HashSet<ParameterDescriptor>();
        parameters.add(param);
        this.setSearchParameters(parameters);
    }

    public boolean evaluate(LogRecord aLogRecord) {
        MonitoredData md = null;
        if (this.mMonitoredDataDef == null) {
            return true;
        }
        if (this.mDateToBeSearchedAgainst == null) {
            Date regExp = (Date)this.getSearchParameter(REG_EXPR_PARAM_NAME).getValue();
            if (regExp == null && this.mDateToBeSearchedAgainst == null) {
                return true;
            }
            this.mDateToBeSearchedAgainst = regExp;
        }
        md = aLogRecord.getMonitoredDataByKey("time");
        Date dateToBeSearched = null;
        if (md != null) {
            dateToBeSearched = (Date)md.getValue();
            return dateToBeSearched.before(this.mDateToBeSearchedAgainst);
        }
        return true;
    }

    public int getqueryType() {
        return 30;
    }

    public Date getDate() {
        if (this.mDateToBeSearchedAgainst == null) {
            Date regExp;
            this.mDateToBeSearchedAgainst = regExp = (Date)this.getSearchParameter(REG_EXPR_PARAM_NAME).getValue();
        }
        return this.mDateToBeSearchedAgainst;
    }

    public String printExpression() {
        Date d = (Date)this.getSearchParameter(REG_EXPR_PARAM_NAME).getValue();
        String date = new SimpleDateFormat("H:mm:ss:SSS - MM/DD/yyyy").format(d);
        String expression = "Before " + date;
        return expression;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

