/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.queryexpr;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.queryexpr.SingleQueryExpression;
import com.sapmarkets.bam.util.SUID;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GrepExpression
extends SingleQueryExpression {
    public static final String OPERATION_DISPLAY_NAME = "Search for a String";
    public static final String REG_EXPR_PARAM_NAME = "Search String";
    public static final String CASE_SENSITIVE = "Case sensitive";
    public static final int EXPRESSION_TYPE = 10;
    public static final long serialVersionUID = SUID.getID();
    private String mSearchString;
    private boolean mIsCaseSensitive;
    private int mIndexOfMDinLR = -1;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public GrepExpression(MonitoredDataDefinition aDataDef) {
        super(aDataDef, OPERATION_DISPLAY_NAME);
        ParameterDescriptor param = new ParameterDescriptor(REG_EXPR_PARAM_NAME, class$java$lang$String == null ? (class$java$lang$String = GrepExpression.class$("java.lang.String")) : class$java$lang$String);
        HashSet<ParameterDescriptor> parameters = new HashSet<ParameterDescriptor>();
        parameters.add(param);
        param = new ParameterDescriptor(CASE_SENSITIVE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = GrepExpression.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        parameters.add(param);
        this.setSearchParameters(parameters);
    }

    public boolean evaluate(LogRecord aLogRecord) {
        boolean isCaseSensitive;
        if (this.mMonitoredDataDef == null) {
            return true;
        }
        String regExp = (String)this.getSearchParameter(REG_EXPR_PARAM_NAME).getValue();
        if (regExp == null) {
            return true;
        }
        boolean bl = isCaseSensitive = this.getSearchParameter(CASE_SENSITIVE).getValue() == null ? true : (Boolean)this.getSearchParameter(CASE_SENSITIVE).getValue();
        if (this.mIndexOfMDinLR == -1) {
            this.mIndexOfMDinLR = this.findIndexOfMDinLogRecord(aLogRecord);
        }
        String valueToBeSearched = aLogRecord.getMonitoredDataAt(this.mIndexOfMDinLR).getValueAsString();
        return this.applyRegExp(valueToBeSearched, regExp, isCaseSensitive);
    }

    private int findIndexOfMDinLogRecord(LogRecord lr) {
        List monitoredDatum = lr.getMonitoredData();
        Iterator itr = monitoredDatum.iterator();
        MonitoredData monitoredData = null;
        int i = 0;
        while (itr.hasNext()) {
            monitoredData = (MonitoredData)itr.next();
            MonitoredDataDefinition mdd = monitoredData.getDefinition();
            if (this.mMonitoredDataDef.equals(mdd)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("findIndexOfMDinLogRecord: the MDD was not found in LogRecord! ReaderSettings.xml may be wrong!");
    }

    private boolean applyRegExp(String aValueToBeSearched, String aRegExp) {
        return this.applyRegExp(aValueToBeSearched, aRegExp, this.mIsCaseSensitive);
    }

    private boolean applyRegExp(String aValueToBeSearched, String aRegExp, boolean isCaseSensitive) {
        int comparisonResult = 0;
        comparisonResult = !isCaseSensitive ? aValueToBeSearched.toLowerCase().indexOf(aRegExp.toLowerCase()) : aValueToBeSearched.indexOf(aRegExp);
        return comparisonResult != -1;
    }

    public int getqueryType() {
        return 10;
    }

    public String printExpression() {
        String expression = (String)this.getSearchParameter(REG_EXPR_PARAM_NAME).getValue() + " " + ((this.getSearchParameter(CASE_SENSITIVE).getValue() == null ? true : (Boolean)this.getSearchParameter(CASE_SENSITIVE).getValue()) ? "CASE_SENSITIVE" : "");
        return expression;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

