/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.queryexpr;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.util.SUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class CompositeQueryExpression
implements LogQueryExpression {
    public static final long serialVersionUID = SUID.getID();
    public static final int EXPRESSION_TYPE = 100;
    private List mChildren = new ArrayList();

    public MonitoredDataDefinition getMonitoredDataDef() {
        return null;
    }

    public Collection getChildren() {
        return Collections.unmodifiableCollection(this.mChildren);
    }

    public void setChildren(Collection someChildren) {
        if (someChildren != null) {
            this.mChildren = new ArrayList(someChildren);
        }
    }

    public void addChildren(Collection someChildren) {
        if (someChildren != null) {
            this.mChildren.addAll(someChildren);
        }
    }

    public void addChild(LogQueryExpression expression) {
        this.mChildren.add(expression);
    }

    public abstract boolean evaluate(LogRecord var1);

    public Collection getSearchParameters() {
        HashSet parameters = new HashSet();
        Iterator itr = this.getChildren().iterator();
        while (itr.hasNext()) {
            LogQueryExpression expr = (LogQueryExpression)itr.next();
            parameters.addAll(expr.getSearchParameters());
        }
        return Collections.unmodifiableCollection(parameters);
    }

    public ParameterDescriptor getSearchParameter(String paramName) {
        Iterator itr = this.getChildren().iterator();
        while (itr.hasNext()) {
            LogQueryExpression expr = (LogQueryExpression)itr.next();
            ParameterDescriptor paramDesc = expr.getSearchParameter(paramName);
            if (paramDesc == null) continue;
            return paramDesc;
        }
        return null;
    }

    public int getqueryType() {
        return 100;
    }

    public boolean hasChildren() {
        return this.getChildren() != null && this.getChildren().size() > 0;
    }

    public abstract String printExpression();
}

