/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.queryexpr;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.queryexpr.SingleQueryExpression;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.SUID;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;

public class BetweenDateExpression
extends SingleQueryExpression {
    public static final long serialVersionUID = SUID.getID();
    public static final String OPERATION_DISPLAY_NAME = "Search within a date range";
    public static final String FROM_DATE = "Enter Date From";
    public static final String TO_DATE = "To";
    public static final int EXPRESSION_TYPE = 40;
    private TimeZone userTimeZone = TimeZone.getDefault();
    private Locale userLocale = Locale.getDefault();
    private LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    static /* synthetic */ Class class$java$lang$String;

    public BetweenDateExpression(MonitoredDataDefinition aDataDef) {
        super(aDataDef, OPERATION_DISPLAY_NAME);
        ParameterDescriptor paramFrom = new ParameterDescriptor(FROM_DATE, class$java$lang$String == null ? (class$java$lang$String = BetweenDateExpression.class$("java.lang.String")) : class$java$lang$String);
        ParameterDescriptor paramTo = new ParameterDescriptor(TO_DATE, class$java$lang$String == null ? (class$java$lang$String = BetweenDateExpression.class$("java.lang.String")) : class$java$lang$String);
        ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        parameters.add(paramFrom);
        parameters.add(paramTo);
        this.setSearchParameters(parameters);
    }

    public boolean evaluate(LogRecord aLogRecord) {
        MonitoredData md = null;
        if (this.mMonitoredDataDef == null) {
            return true;
        }
        String regExpFromDate = (String)this.getSearchParameter(FROM_DATE).getValue();
        String regExpToDate = (String)this.getSearchParameter(TO_DATE).getValue();
        if (regExpFromDate == null && regExpToDate != null || regExpFromDate != null && regExpToDate == null) {
            try {
                throw new IllegalArgumentException(LocalizableTextFormatter.formatString((ResourceAccessor)this.resourceAccessor, (String)"EITHER_FROM_DATE_OR_TO_DATE_IS_NULL", null, (Locale)this.userLocale, (TimeZone)this.userTimeZone));
            }
            catch (LocalizationException le) {
                throw new IllegalArgumentException("Either the from date or the to date is null. Either both should have values or both should be null");
            }
        }
        if (regExpFromDate == null && regExpToDate == null) {
            return true;
        }
        md = aLogRecord.getMonitoredDataByKey("time");
        String valueToBeSearched = "";
        if (md != null) {
            valueToBeSearched = md.getValueAsString();
        }
        return this.applyRegExp(valueToBeSearched, regExpFromDate, regExpToDate);
    }

    private boolean applyRegExp(String aValueToBeSearched, String regExpFromDate, String regExpToDate) {
        return false;
    }

    public int getqueryType() {
        return 40;
    }

    public String printExpression() {
        String expression = "Between " + (String)this.getSearchParameter(FROM_DATE).getValue() + " and " + (String)this.getSearchParameter(TO_DATE).getValue();
        return expression;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

