/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller.jmx;

import com.sap.engine.frame.RuntimeProperties;
import com.sap.tc.logging.FormatterType;
import com.sapmarkets.bam.application.LogAttributeDescriptor;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.jmx.connector.LVServer;
import com.sapmarkets.bam.logcontroller.BAMLogReader;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.InvalidLogQuerySessionException;
import com.sapmarkets.bam.logcontroller.LogInfo;
import com.sapmarkets.bam.logcontroller.LogPropertyReader;
import com.sapmarkets.bam.logcontroller.LogQueryBrowser;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogQuerySession;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.logcontroller.ReaderSettings;
import com.sapmarkets.bam.logcontroller.jmx.LogControllerFacadeMBean;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LVVersion;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.ReadLogRecordException;
import com.sapmarkets.bam.util.Tracer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class LogControllerFacade
implements LogControllerFacadeMBean {
    private static final LVVersion VERSION = new LVVersion(2);
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$logcontroller$jmx$LogControllerFacade == null ? (class$com$sapmarkets$bam$logcontroller$jmx$LogControllerFacade = LogControllerFacade.class$("com.sapmarkets.bam.logcontroller.jmx.LogControllerFacade")) : class$com$sapmarkets$bam$logcontroller$jmx$LogControllerFacade);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$logcontroller$jmx$LogControllerFacade == null ? (class$com$sapmarkets$bam$logcontroller$jmx$LogControllerFacade = LogControllerFacade.class$("com.sapmarkets.bam.logcontroller.jmx.LogControllerFacade")) : class$com$sapmarkets$bam$logcontroller$jmx$LogControllerFacade);
    private Map logQueries = new HashMap();
    private Map logQueryTimestamp = new HashMap();
    private long expiration;
    public static final long DEFAULT_EXPIRATION = 43200000L;
    private static long sessionIDCounter = 0L;
    private String hostName;
    private LVServer server_;
    private Set availableReaders;
    private Set availableHandlers;
    private static final Map mPOSSIBLE_VALUES = new HashMap(2);
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$jmx$LogControllerFacade;

    public LogControllerFacade(LVServer server) {
        this(server, 43200000L);
    }

    public LogControllerFacade(LVServer server, long expiration) {
        this.server_ = server;
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), "Hostname could not be resolved!", e);
        }
        this.hostName = localAddress.getHostName();
        String version = RuntimeProperties.get((int)10);
        if (version == null) {
            version = "";
        }
        VERSION.putAttribute("SERVER_VERSION", version);
        this.expiration = expiration;
    }

    public LVVersion getVersion() {
        return VERSION;
    }

    public Set getLogInfos() {
        int clusterNodeID = this.getClusterNodeID();
        String pattern = "*:SAP_J2EEClusterNode=" + (clusterNodeID == 0 ? "\"\"" : new Integer(clusterNodeID).toString()) + ",j2eeType=" + LogTypeEnumeration.LVLOG_TYPE.toString() + ",*";
        try {
            ObjectName objNamePattern = new ObjectName(pattern);
            return this.getLogInfosWithPattern(objNamePattern);
        }
        catch (MalformedObjectNameException ex) {
            LOG.logException(ex);
            return new HashSet();
        }
    }

    private Set getLogInfosWithPattern(ObjectName objNamePattern) {
        HashSet<LogInfo> logInfos = new HashSet<LogInfo>();
        Set<ObjectName> objNames = this.server_.getMBeanServer().queryNames(objNamePattern, null);
        Iterator<ObjectName> iter = objNames.iterator();
        while (iter.hasNext()) {
            ObjectName objName = iter.next();
            try {
                LogInfo logInfo = this.getLogInfo(objName);
                logInfos.add(logInfo);
            }
            catch (InstanceNotFoundException ex) {
                LOG.logException(ex);
            }
            catch (IntrospectionException ex) {
                LOG.logException(ex);
            }
            catch (ReflectionException ex) {
                LOG.logException(ex);
            }
        }
        return logInfos;
    }

    private Set getAttributeDescriptors(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, MBeanException, AttributeNotFoundException {
        HashSet<LogAttributeDescriptor> attributeDescriptors = new HashSet<LogAttributeDescriptor>();
        MBeanServer server = this.server_.getMBeanServer();
        MBeanAttributeInfo[] attributeInfos = server.getMBeanInfo(name).getAttributes();
        Map attributeDescriptions = (Map)server.getAttribute(name, "AttributeDescriptions");
        int i = 0;
        while (i < attributeInfos.length) {
            String description = (String)attributeDescriptions.get(attributeInfos[i].getName());
            LogAttributeDescriptor attribute = new LogAttributeDescriptor(attributeInfos[i].getName(), attributeInfos[i].getType(), description, attributeInfos[i].isWritable());
            Object[] possibleValues = (Object[])mPOSSIBLE_VALUES.get(attributeInfos[i].getName());
            if (possibleValues != null) {
                attribute.setPossibleValues(Collections.unmodifiableList(Arrays.asList(possibleValues)));
            }
            attributeDescriptors.add(attribute);
            ++i;
        }
        return attributeDescriptors;
    }

    public LogInfo getLogInfo(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        ObjectName name = this.server_.getMBeanServer().getObjectInstance(objName).getObjectName();
        LogInfo logInfo = new LogInfo(name, this.getHostName(), this.getClusterNodeName(), this.server_.getMBeanServerID());
        logInfo.setMetaDataOfReaders(this.getMetaDataOfReaders());
        MBeanInfo mbeanInfo = this.server_.getMBeanServer().getMBeanInfo(objName);
        MBeanAttributeInfo[] attributeInfos = mbeanInfo.getAttributes();
        int i = 0;
        while (i < attributeInfos.length) {
            try {
                Object value = this.server_.getMBeanServer().getAttribute(objName, attributeInfos[i].getName());
                logInfo.putAttribute(attributeInfos[i].getName(), value);
                Set attrDescriptors = this.getAttributeDescriptors(objName);
                logInfo.setAttributeDescriptors(attrDescriptors);
            }
            catch (MBeanException ex) {
                LOG.logException(ex);
            }
            catch (AttributeNotFoundException ex) {
                LOG.logException(ex);
            }
            ++i;
        }
        return logInfo;
    }

    public List getLogInfos(List objNames) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        ArrayList<LogInfo> logInfos = new ArrayList<LogInfo>();
        Iterator itr = objNames.iterator();
        while (itr.hasNext()) {
            ObjectName objName = (ObjectName)itr.next();
            LogInfo logInfo = this.getLogInfo(objName);
            logInfos.add(logInfo);
        }
        return logInfos;
    }

    private LogQuerySession createLogQuerySession() {
        return new LogQuerySession(sessionIDCounter++);
    }

    private void cleanupLogQueries() {
        LogQuerySession session;
        HashSet<LogQuerySession> cleanupQueries = new HashSet<LogQuerySession>();
        Iterator<Object> iter = this.logQueryTimestamp.keySet().iterator();
        while (iter.hasNext()) {
            session = (LogQuerySession)iter.next();
            long timestamp = (Long)this.logQueryTimestamp.get(session);
            if (System.currentTimeMillis() - timestamp <= this.expiration) continue;
            cleanupQueries.add(session);
        }
        iter = cleanupQueries.iterator();
        while (iter.hasNext()) {
            session = (LogQuerySession)iter.next();
            this.logQueryTimestamp.remove(session);
            this.logQueries.remove(session);
            TRACE.traceInfo("Removed session: " + session.getSessionID());
        }
    }

    private void updateTimestamp(LogQuerySession session) {
        this.logQueryTimestamp.put(session, new Long(System.currentTimeMillis()));
    }

    public int getClusterNodeID() {
        return this.server_.getClusterNodeID();
    }

    public String getClusterNodeName() {
        return this.server_.getClusterNodeName();
    }

    public LogQuerySession createLogQuerySession(List logDescriptors, LogQueryExpression logQueryExpression, DownloadSpecs downloadSpecs) {
        try {
            this.cleanupLogQueries();
            ArrayList<BAMLogReader> someBAMLogReaders = new ArrayList<BAMLogReader>();
            int i = 0;
            while (i < logDescriptors.size()) {
                LogDescriptor logDescr = (LogDescriptor)logDescriptors.get(i);
                someBAMLogReaders.add(LogPropertyReader.getBAMLogReader(logDescr));
                ++i;
            }
            LogQuerySession session = this.createLogQuerySession();
            LogQueryBrowser logQuery = new LogQueryBrowser(logQueryExpression, someBAMLogReaders, downloadSpecs);
            this.logQueries.put(session, logQuery);
            TRACE.traceInfo("Created session: " + session.getSessionID());
            this.updateTimestamp(session);
            return session;
        }
        catch (RuntimeException ex) {
            LOG.logException(ex);
            throw ex;
        }
    }

    public void closeLogQuerySession(LogQuerySession session) throws InvalidLogQuerySessionException {
        TRACE.traceInfo("Closing session: " + session.getSessionID());
        this.logQueryTimestamp.remove(session);
        LogQueryBrowser logQuery = (LogQueryBrowser)this.logQueries.get(session);
        if (logQuery == null) {
            throw new InvalidLogQuerySessionException(LOG.getLocation(), "INVALID_QUERY_SESSION", new Object[]{new Long(session.getSessionID())});
        }
        logQuery.closeBrowser();
        this.logQueries.remove(session);
    }

    public LogQueryExpression getLogQueryExpression(LogQuerySession session) throws InvalidLogQuerySessionException {
        LogQueryBrowser logQuery = this.updateLogQuerySession(session);
        return logQuery.getLogQueryExpression();
    }

    public LogRecordDefinition getLogRecordDefinition(LogQuerySession session) throws InvalidLogQuerySessionException {
        LogQueryBrowser logQuery = this.updateLogQuerySession(session);
        return logQuery.getLogRecordDefinition();
    }

    public LogQueryResultset getNext(LogQuerySession session, int numRecords) throws InvalidLogQuerySessionException, ReadLogRecordException {
        LogQueryBrowser logQuery = this.updateLogQuerySession(session);
        return logQuery.getNext(numRecords);
    }

    public LogQueryResultset getOldest(LogQuerySession session, int numRecords) throws InvalidLogQuerySessionException, ReadLogRecordException {
        LogQueryBrowser logQuery = this.updateLogQuerySession(session);
        return logQuery.getOldest(numRecords);
    }

    public LogQueryResultset getPrevious(LogQuerySession session, int numRecords) throws InvalidLogQuerySessionException, ReadLogRecordException {
        LogQueryBrowser logQuery = this.updateLogQuerySession(session);
        return logQuery.getPrevious(numRecords);
    }

    public LogQueryResultset getLatest(LogQuerySession session, int numRecords) throws InvalidLogQuerySessionException, ReadLogRecordException {
        LogQueryBrowser logQuery = this.updateLogQuerySession(session);
        return logQuery.getLatest(numRecords);
    }

    private LogQueryBrowser updateLogQuerySession(LogQuerySession session) throws InvalidLogQuerySessionException {
        LogQueryBrowser logQuery = (LogQueryBrowser)this.logQueries.get(session);
        if (logQuery == null) {
            throw new InvalidLogQuerySessionException(LOG.getLocation(), "INVALID_QUERY_SESSION", new Object[]{new Long(session.getSessionID())});
        }
        this.updateTimestamp(session);
        return logQuery;
    }

    public MetaDataOfReaders getMetaDataOfReaders() {
        MetaDataOfReaders metaDataOfReaders = new MetaDataOfReaders();
        try {
            List readers = ReaderSettings.getReaderSettings().getReaderIDs();
            Iterator iter = readers.iterator();
            while (iter.hasNext()) {
                LogRecordDefinition logRecordDefinition;
                String readerID = (String)iter.next();
                LogPropertyReader lpr = new LogPropertyReader(readerID);
                LogRecordDefinition lrd = logRecordDefinition = lpr.getLogRecordDefinition();
                metaDataOfReaders.add(readerID, lrd);
            }
        }
        catch (IOException flEx) {
            throw new BAMRuntimeException(LOG.getLocation(), flEx);
        }
        metaDataOfReaders.setAvailableReaders(this.availableReaders);
        return metaDataOfReaders;
    }

    public void setHandlersAndReaders(Set handlers, Set readers) {
        this.availableHandlers = handlers;
        this.availableReaders = readers;
    }

    public Set getAvailableHandlers() {
        return this.availableHandlers;
    }

    public void stopRunning(LogQuerySession session) throws InvalidLogQuerySessionException {
        LogQueryBrowser logQuery = this.updateLogQuerySession(session);
        logQuery.stopRunning();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostname) {
        this.hostName = hostname;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String[] severityNames = new String[]{"Debug", "Info", "Warning", "Error", "Fatal", "None"};
        mPOSSIBLE_VALUES.put("Severity", severityNames);
        mPOSSIBLE_VALUES.put("FormatterType", FormatterType.ALLTYPES.toArray(new FormatterType[0]));
    }
}

