/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.sql.trace.SQLTraceLogRecord;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sapmarkets.bam.logcontroller.AbstractBAMLogReader;
import com.sapmarkets.bam.logcontroller.LogAttribute;
import com.sapmarkets.bam.util.LVDate;
import com.sapmarkets.bam.util.LVTime;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import java.util.HashMap;

public class SQLTraceLogReader
extends AbstractBAMLogReader {
    private static final int numRec = 1;

    public SQLTraceLogReader(IReadableLog aFileLog) {
        this.init(LogTypeEnumeration.SQL_TRACE.toString(), aFileLog);
    }

    protected HashMap createLogAttributes(LogRecord msgRecord) {
        final SQLTraceLogRecord logRecord = (SQLTraceLogRecord)msgRecord;
        HashMap<String, LogAttribute> la = new HashMap<String, LogAttribute>();
        la.put("datasource", new LogAttribute(){

            public Object getValue() {
                return SQLTraceLogReader.this.mLogID;
            }
        });
        la.put("severity", new LogAttribute(){

            public Object getValue() {
                return new String(Severity.toString((int)logRecord.getSeverity()));
            }
        });
        la.put("time", new LogAttribute(){

            public Object getValue() {
                return new LVTime(logRecord.getTime().getTime());
            }
        });
        la.put("date", new LogAttribute(){

            public Object getValue() {
                return new LVDate(logRecord.getTime().getTime());
            }
        });
        la.put("loc", new LogAttribute(){

            public Object getValue() {
                return logRecord.getLocationName();
            }
        });
        la.put("message", new LogAttribute(){

            public Object getValue() {
                return logRecord.getMsgClear();
            }
        });
        la.put("Message_ID", new LogAttribute(){

            public Object getValue() {
                return logRecord.getId().toString();
            }
        });
        la.put("source_name", new LogAttribute(){

            public Object getValue() {
                return logRecord.getSourceName();
            }
        });
        la.put("thread", new LogAttribute(){

            public Object getValue() {
                return logRecord.getThreadName();
            }
        });
        la.put("dbid", new LogAttribute(){

            public Object getValue() {
                return logRecord.getDbId();
            }
        });
        la.put("duration", new LogAttribute(){

            public Object getValue() {
                return Long.toString(logRecord.getDuration());
            }
        });
        la.put("errcode", new LogAttribute(){

            public Object getValue() {
                return logRecord.getErrCode();
            }
        });
        la.put("gentime", new LogAttribute(){

            public Object getValue() {
                return logRecord.getGentime();
            }
        });
        la.put("inparam", new LogAttribute(){

            public Object getValue() {
                return logRecord.getInParam();
            }
        });
        la.put("program", new LogAttribute(){

            public Object getValue() {
                return logRecord.getProgram();
            }
        });
        la.put("pstmtid", new LogAttribute(){

            public Object getValue() {
                return logRecord.getPStmtId();
            }
        });
        la.put("result", new LogAttribute(){

            public Object getValue() {
                return logRecord.getResult();
            }
        });
        la.put("rsid", new LogAttribute(){

            public Object getValue() {
                return logRecord.getRsId();
            }
        });
        la.put("varsperbatch", new LogAttribute(){

            public Object getValue() {
                return Integer.toString(logRecord.getVarsPerBatch());
            }
        });
        return la;
    }
}

