/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sap.tc.logging.perf.ISatRecord;
import com.sap.tc.logging.perf.PerfLogRecord;
import com.sapmarkets.bam.logcontroller.AbstractBAMLogReader;
import com.sapmarkets.bam.logcontroller.LogAttribute;
import com.sapmarkets.bam.util.Duration;
import com.sapmarkets.bam.util.LVDate;
import com.sapmarkets.bam.util.LVTime;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.MilliSecondsDuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class SATLogReader
extends AbstractBAMLogReader {
    private static final int numRec = 1;
    Duration duration;

    public SATLogReader(IReadableLog log) {
        this.init(LogTypeEnumeration.SAT_TRACE.toString(), log);
    }

    protected HashMap createLogAttributes(LogRecord msgRecord) {
        final PerfLogRecord perfLogRecord = (PerfLogRecord)msgRecord;
        final ISatRecord satLogRecord = perfLogRecord.getSatRecord();
        HashMap<String, LogAttribute> la = new HashMap<String, LogAttribute>();
        la.put("datasource", new LogAttribute(){

            public Object getValue() {
                return SATLogReader.this.mLogID;
            }
        });
        la.put("severity", new LogAttribute(){

            public Object getValue() {
                return new String(Severity.toString((int)perfLogRecord.getSeverity()));
            }
        });
        la.put("date", new LogAttribute(){

            public Object getValue() {
                return new LVDate(perfLogRecord.getTime().getTime());
            }
        });
        la.put("time", new LogAttribute(){

            public Object getValue() {
                return new LVTime(perfLogRecord.getTime().getTime());
            }
        });
        la.put("loc", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getLocationName();
            }
        });
        la.put("message", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getMsgClear();
            }
        });
        la.put("Message_ID", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getId().toString();
            }
        });
        la.put("source_name", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getSourceName();
            }
        });
        la.put("thread", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getThreadName();
            }
        });
        la.put("application", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getApplication();
            }
        });
        la.put("numberOfSubRecs", new LogAttribute(){

            public Object getValue() {
                return Integer.toString(satLogRecord.getNumberOfSubRecords());
            }
        });
        la.put("rectype", new LogAttribute(){

            public Object getValue() {
                return Integer.toString(satLogRecord.getRecType());
            }
        });
        la.put("seqnumber", new LogAttribute(){

            public Object getValue() {
                return Integer.toString(satLogRecord.getSeqNumber());
            }
        });
        la.put("level", new LogAttribute(){

            public Object getValue() {
                return Integer.toString(satLogRecord.getLevel());
            }
        });
        la.put("name", new LogAttribute(){

            public Object getValue() {
                return satLogRecord.getName();
            }
        });
        la.put("username", new LogAttribute(){

            public Object getValue() {
                return satLogRecord.getUserName();
            }
        });
        la.put("state", new LogAttribute(){

            public Object getValue() {
                return Integer.toString(satLogRecord.getState());
            }
        });
        la.put("grossCPUTime", new LogAttribute(){

            public Object getValue() {
                if (satLogRecord.getGrossCpuTime() == -1L) {
                    return "N/A";
                }
                return new MilliSecondsDuration(satLogRecord.getGrossCpuTime()).getDuration();
            }
        });
        la.put("netCPUTime", new LogAttribute(){

            public Object getValue() {
                if (satLogRecord.getNetCpuTime() == -1L) {
                    return "N/A";
                }
                return new MilliSecondsDuration(satLogRecord.getNetCpuTime()).getDuration();
            }
        });
        la.put("startTSTime", new LogAttribute(){

            public Object getValue() {
                return new LVTime(satLogRecord.getStartTS());
            }
        });
        la.put("startTSDate", new LogAttribute(){

            public Object getValue() {
                return new LVDate(satLogRecord.getStartTS());
            }
        });
        la.put("grossTime", new LogAttribute(){

            public Object getValue() {
                long grossTime = satLogRecord.getGrossTime();
                if (grossTime == 0L) {
                    return "";
                }
                if (grossTime == -1L) {
                    return "N/A";
                }
                return new MilliSecondsDuration(grossTime).getDuration();
            }
        });
        la.put("netTime", new LogAttribute(){

            public Object getValue() {
                long netTime = satLogRecord.getNetTime();
                if (netTime == 0L) {
                    return "";
                }
                if (netTime == -1L) {
                    return "N/A";
                }
                return new MilliSecondsDuration(netTime).getDuration();
            }
        });
        la.put("outData", new LogAttribute(){

            public Object getValue() {
                int outData = satLogRecord.getOutData();
                if (outData == 0) {
                    return "";
                }
                if (outData == -1) {
                    return "N/A";
                }
                return Integer.toString(outData);
            }
        });
        la.put("descr", new LogAttribute(){

            public Object getValue() {
                return satLogRecord.getDescr();
            }
        });
        la.put("props", new LogAttribute(){

            public Object getValue() {
                ArrayList<String> propList = new ArrayList<String>();
                if (satLogRecord.getProps() != null) {
                    Iterator itr = ((Hashtable)satLogRecord.getProps()).values().iterator();
                    while (itr.hasNext()) {
                        Object o = itr.next();
                        propList.add(new String(o.toString()));
                    }
                }
                return propList;
            }
        });
        la.put("className", new LogAttribute(){

            public Object getValue() {
                return satLogRecord.getClassName();
            }
        });
        la.put("classVersion", new LogAttribute(){

            public Object getValue() {
                return satLogRecord.getClassVersion();
            }
        });
        la.put("dsrTransaction", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getDsrTransaction();
            }
        });
        la.put("sessionId", new LogAttribute(){

            public Object getValue() {
                return perfLogRecord.getSession();
            }
        });
        return la;
    }
}

