/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sapmarkets.bam.logcontroller.AbstractBAMLogReader;
import com.sapmarkets.bam.logcontroller.LogAttribute;
import com.sapmarkets.bam.util.LVDate;
import com.sapmarkets.bam.util.LVTime;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;

public class SAPJavaLogReader
extends AbstractBAMLogReader {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$logcontroller$SAPJavaLogReader == null ? (class$com$sapmarkets$bam$logcontroller$SAPJavaLogReader = SAPJavaLogReader.class$("com.sapmarkets.bam.logcontroller.SAPJavaLogReader")) : class$com$sapmarkets$bam$logcontroller$SAPJavaLogReader);
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$SAPJavaLogReader;

    protected HashMap createLogAttributes(final LogRecord msgRecord) {
        HashMap<String, LogAttribute> la = new HashMap<String, LogAttribute>();
        la.put("datasource", new LogAttribute(){

            public Object getValue() {
                return SAPJavaLogReader.this.mLogID;
            }
        });
        la.put("category", new LogAttribute(){

            public Object getValue() {
                if (msgRecord.getLocationName().startsWith(msgRecord.getSourceName())) {
                    String result = "";
                    Iterator i = msgRecord.getRelatives().iterator();
                    while (i.hasNext()) {
                        result = result + (String)i.next();
                    }
                    return result;
                }
                return msgRecord.getSourceName();
            }
        });
        la.put("severity", new LogAttribute(){

            public Object getValue() {
                return new String(Severity.toString((int)msgRecord.getSeverity()));
            }
        });
        la.put("time", new LogAttribute(){

            public Object getValue() {
                return new LVTime(msgRecord.getTime().getTime());
            }
        });
        la.put("date", new LogAttribute(){

            public Object getValue() {
                return new LVDate(msgRecord.getTime().getTime());
            }
        });
        la.put("loc", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getLocationName();
            }
        });
        la.put("message", new LogAttribute(){

            public Object getValue() {
                String messageClear = msgRecord.getMsgClear();
                try {
                    if (messageClear == null) {
                        messageClear = "";
                    }
                    if (msgRecord.getMsgType() == 1) {
                        messageClear = MessageFormat.format(messageClear, msgRecord.getArgs().toArray());
                    }
                }
                catch (IllegalArgumentException ex) {
                    messageClear = messageClear + msgRecord.getArgs().toString();
                }
                if (messageClear.length() == 0 && msgRecord.getMsgCode().length() != 0) {
                    messageClear = msgRecord.getMsgCode();
                }
                return messageClear;
            }
        });
        la.put("Message_ID", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getId().toString();
            }
        });
        la.put("source_name", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getSourceName();
            }
        });
        la.put("thread", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getThreadName();
            }
        });
        la.put("application", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getApplication();
            }
        });
        la.put("argObjs", new LogAttribute(){

            public Object getValue() {
                String argObjs = "";
                if (msgRecord.getArgs() != null) {
                    Iterator itr = msgRecord.getArgs().iterator();
                    while (itr.hasNext()) {
                        argObjs = argObjs + itr.next().toString() + ",";
                    }
                }
                return argObjs;
            }
        });
        la.put("args", new LogAttribute(){

            public Object getValue() {
                String args = "";
                if (msgRecord.getArgs() != null) {
                    Iterator itr = msgRecord.getArgs().iterator();
                    while (itr.hasNext()) {
                        args = args + itr.next().toString() + ",";
                    }
                }
                return args;
            }
        });
        la.put("dsrComponent", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getDsrComponent();
            }
        });
        la.put("dsrTransaction", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getDsrTransaction();
            }
        });
        la.put("dsrUser", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getDsrUser();
            }
        });
        la.put("source", new LogAttribute(){

            public Object getValue() {
                String source = "";
                if (msgRecord.getSourceName() != null) {
                    source = msgRecord.getSourceName();
                }
                return source;
            }
        });
        la.put("threadObject", new LogAttribute(){

            public Object getValue() {
                String thread = "";
                if (msgRecord.getThreadName() != null) {
                    thread = msgRecord.getThreadName();
                }
                return thread;
            }
        });
        la.put("indent", new LogAttribute(){

            public Object getValue() {
                return new String("" + msgRecord.getGroupIndent());
            }
        });
        la.put("level", new LogAttribute(){

            public Object getValue() {
                return new String("" + msgRecord.getGroupLevel());
            }
        });
        la.put("messageCode", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getMsgCode();
            }
        });
        la.put("messageType", new LogAttribute(){

            public Object getValue() {
                return new String("" + msgRecord.getMsgType());
            }
        });
        la.put("relatives", new LogAttribute(){

            public Object getValue() {
                String relatives = "";
                if (msgRecord.getRelatives() != null) {
                    Iterator itr = msgRecord.getRelatives().iterator();
                    while (itr.hasNext()) {
                        relatives = relatives + (String)itr.next();
                        if (!itr.hasNext()) continue;
                        relatives = relatives + ", ";
                    }
                }
                return relatives;
            }
        });
        la.put("resourceBundleName", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getResourceBundleName();
            }
        });
        la.put("session", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getSession();
            }
        });
        la.put("transaction", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getTransaction();
            }
        });
        la.put("user", new LogAttribute(){

            public Object getValue() {
                return msgRecord.getUser();
            }
        });
        return la;
    }

    public SAPJavaLogReader(IReadableLog fileLog) {
        this.init(LogTypeEnumeration.SAPJLOG.toString(), fileLog);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

