/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.logcontroller.MetaDataOfReader;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.ResourceInFileOrJar;
import com.sapmarkets.bam.util.XMLHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReaderSettings {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$logcontroller$ReaderSettings == null ? (class$com$sapmarkets$bam$logcontroller$ReaderSettings = ReaderSettings.class$("com.sapmarkets.bam.logcontroller.ReaderSettings")) : class$com$sapmarkets$bam$logcontroller$ReaderSettings);
    private static ReaderSettings instance;
    private static final String DEFAULT_FILE_NAME = "ReaderSettings.xml";
    private List readers;
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$ReaderSettings;

    private ReaderSettings(String resourceName) throws FileNotFoundException {
        Element mRoot;
        InputStream aConfigStream = new ResourceInFileOrJar(resourceName).getInputStream();
        if (null == aConfigStream) {
            throw new BAMRuntimeException(mLogger.getLocation(), "ERROR_READING_READERS_SETTINGS");
        }
        try {
            mRoot = XMLHelper.buildDOMFromXML(aConfigStream).getDocumentElement();
        }
        catch (Exception anException) {
            throw new BAMRuntimeException(mLogger.getLocation(), "EXCEPTION_WHILE_READING_READERS_SETTINGS", new Object[]{anException.toString()}, anException);
        }
        this.readReaderSettings(mRoot);
    }

    public static synchronized ReaderSettings getReaderSettings(String resourceName) throws IOException {
        if (instance == null) {
            instance = new ReaderSettings(resourceName);
        }
        return instance;
    }

    public static synchronized ReaderSettings getReaderSettings() throws IOException {
        return ReaderSettings.getReaderSettings(DEFAULT_FILE_NAME);
    }

    public Collection createMDD(String readerID) {
        List mddList = this.getMetaDataOfReader(readerID).getMonitoredDataDefinitions();
        return Collections.unmodifiableList(mddList);
    }

    public List getReaders() {
        return this.readers;
    }

    public void setReaders(List aList) {
        this.readers = aList;
    }

    public List getReaderIDs() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.readers.iterator();
        while (iter.hasNext()) {
            MetaDataOfReader reader = (MetaDataOfReader)iter.next();
            result.add(reader.getReaderID());
        }
        return result;
    }

    public MetaDataOfReader getMetaDataOfReader(String readerID) {
        Iterator iter = this.readers.iterator();
        while (iter.hasNext()) {
            MetaDataOfReader reader = (MetaDataOfReader)iter.next();
            if (!readerID.equals(reader.getReaderID())) continue;
            return reader;
        }
        return null;
    }

    private void readReaderSettings(Node aNode) {
        this.readers = new ArrayList();
        List l = XMLHelper.getChildNodesByTag(aNode, "Readers");
        int i = 0;
        while (i < l.size()) {
            Node node = (Node)l.get(i);
            this.readReaders(node);
            ++i;
        }
    }

    private void readReaders(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "Reader");
        int i = 0;
        while (i < l.size()) {
            Node node = (Node)l.get(i);
            this.readers.add(new MetaDataOfReader(node));
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

