/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.XMLHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Node;

public class MonitoredDataDefinitionFactory {
    private static MonitoredDataDefinitionFactory mMDDFactory;
    private String displayFormat;
    private String displayName;
    private boolean displayStatus;
    private String displayType;
    private String monitoredDataDefinitionID;
    private String monitoredDataDefinitionType;
    private List operations = new ArrayList();
    private boolean sequencible;
    private boolean isFastSearchable;
    private int order;
    private int width;
    private boolean displayMultipleLines;

    public static MonitoredDataDefinitionFactory getInstance() {
        if (mMDDFactory == null) {
            mMDDFactory = new MonitoredDataDefinitionFactory();
        }
        return mMDDFactory;
    }

    public MonitoredDataDefinition getMonitoredDataDefinition(Node aNode) throws BAMAppException {
        this.operations.clear();
        this.readAttributesAndTextValues(aNode);
        this.readDisplayProperties(aNode);
        this.readOperations(aNode);
        return new MonitoredDataDefinition(this.monitoredDataDefinitionID, this.displayName, this.operations, this.sequencible, this.isFastSearchable, this.displayStatus, this.displayType, this.displayFormat, this.monitoredDataDefinitionType, this.order, this.width, this.displayMultipleLines);
    }

    private void readAttributesAndTextValues(Node aNode) {
        Properties p = XMLHelper.getAttributes(aNode);
        this.monitoredDataDefinitionID = p.getProperty("ID");
        this.monitoredDataDefinitionType = p.getProperty("Type");
        this.sequencible = "true".equals(p.getProperty("Sequencible"));
        this.isFastSearchable = "true".equalsIgnoreCase(p.getProperty("isFastSearchable"));
    }

    private void readDisplayProperties(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "Display");
        Node node = (Node)l.get(0);
        Properties displayProperties = XMLHelper.getAttributes(node);
        this.displayName = displayProperties.getProperty("Name");
        this.displayType = displayProperties.getProperty("Type");
        this.displayFormat = displayProperties.getProperty("Format");
        this.displayStatus = "true".equals(displayProperties.getProperty("Status"));
        this.order = Integer.parseInt(displayProperties.getProperty("Order"));
        this.width = Integer.parseInt(displayProperties.getProperty("Width"));
        this.displayMultipleLines = displayProperties.getProperty("MultiLine", "false").equals("true");
    }

    private void readOperations(Node aNode) throws BAMAppException {
        List l = XMLHelper.getChildNodesByTag(aNode, "Operations");
        if (l.isEmpty()) {
            return;
        }
        Node node = (Node)l.get(0);
        l = XMLHelper.getChildNodesByTag(node, "OperationClass");
        int i = 0;
        while (i < l.size()) {
            node = (Node)l.get(i);
            this.operations.add(XMLHelper.getTextBetweenTags(node).trim());
            ++i;
        }
    }
}

