/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.logcontroller.Monitorable;
import com.sapmarkets.bam.queryexpr.LogQueryExpressionDescriptor;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.SUID;
import com.sapmarkets.bam.util.XMLHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Node;

public class MonitoredDataDefinition
implements Monitorable,
Serializable {
    public static final long serialVersionUID = SUID.getID();
    private String displayFormat;
    private String displayName;
    private boolean isDefaultDisplay;
    private String displayType;
    private List logQueryExpressionDescriptors = new ArrayList();
    private String monitoredDataDefinitionID;
    private String monitoredDataDefinitionType;
    private List operations = new ArrayList();
    private boolean sequencible;
    private boolean isFastSearchable;
    private int order;
    private int width;
    private boolean displayMultiLine;

    public MonitoredDataDefinition(String aDefinitionID, String aDefinitionDescriptor, List aOperationClassNames, boolean isSequencible, boolean fastSearchable, boolean is_DefaultDisplay, String display_Type, String aDisplayFormat, String aMDDType, int orderPos, int dispWidth, boolean multiline) throws BAMAppException {
        this.monitoredDataDefinitionID = aDefinitionID;
        this.displayName = aDefinitionDescriptor;
        this.sequencible = isSequencible;
        this.isFastSearchable = fastSearchable;
        this.isDefaultDisplay = is_DefaultDisplay;
        this.displayType = display_Type;
        this.displayFormat = aDisplayFormat;
        this.monitoredDataDefinitionType = aMDDType;
        this.order = orderPos;
        this.width = dispWidth;
        this.displayMultiLine = multiline;
        Iterator operationsItr = aOperationClassNames.iterator();
        this.logQueryExpressionDescriptors = new ArrayList();
        while (operationsItr.hasNext()) {
            this.logQueryExpressionDescriptors.add(new LogQueryExpressionDescriptor((String)operationsItr.next()));
        }
    }

    public boolean equals(Object obj) {
        MonitoredDataDefinition mdd;
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass() && this.monitoredDataDefinitionID.equals((mdd = (MonitoredDataDefinition)obj).getMonitoredDataDefinitionID());
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isDefaultDisplay() {
        return this.isDefaultDisplay;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String getMonitoredDataDefinitionID() {
        return this.monitoredDataDefinitionID;
    }

    public String getMonitoredDataDefinitionType() {
        return this.monitoredDataDefinitionType;
    }

    public List getOperations() {
        return this.operations;
    }

    public List getPossibleQueryExpressionDescriptions() {
        return this.logQueryExpressionDescriptors;
    }

    public boolean isSequencible() {
        return this.sequencible;
    }

    public int hashCode() {
        return this.monitoredDataDefinitionID.hashCode();
    }

    private void readDisplayProperties(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "Display");
        Node node = (Node)l.get(0);
        Properties displayProperties = XMLHelper.getAttributes(node);
        this.displayName = displayProperties.getProperty("Name");
        this.displayType = displayProperties.getProperty("Type");
        this.displayFormat = displayProperties.getProperty("Format");
        this.displayMultiLine = displayProperties.getProperty("MultiLine", "false").equals("true");
        this.isDefaultDisplay = "true".equals(displayProperties.getProperty("Status"));
    }

    private void readOperations(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "Operations");
        if (l.isEmpty()) {
            return;
        }
        Node node = (Node)l.get(0);
        Iterator i = XMLHelper.getChildNodesByTag(node, "OperationClass").iterator();
        while (i.hasNext()) {
            node = (Node)i.next();
        }
    }

    public String toString() {
        return "MDD: ID: [" + this.getMonitoredDataDefinitionID() + "] Description[" + this.getDisplayName() + "] Sequencible[" + this.isSequencible() + "] Expr. Descr.[" + this.getPossibleQueryExpressionDescriptions() + "] DefaultDisplay [" + this.isDefaultDisplay() + "] DisplayType [" + this.getDisplayType() + "]";
    }

    public int getOrder() {
        return this.order;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isFastSearchable() {
        return this.isFastSearchable;
    }

    public boolean isDisplayMultiLine() {
        return this.displayMultiLine;
    }
}

