/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MetaDataOfReader;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.SUID;
import com.sapmarkets.bam.util.Tracer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class MetaDataOfReaders
implements Serializable {
    private static Logger LOG = new Logger(class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders == null ? (class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders = MetaDataOfReaders.class$("com.sapmarkets.bam.logcontroller.MetaDataOfReaders")) : class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders);
    public static final long serialVersionUID = SUID.getID();
    private Map mReadersAndDefinitions = new HashMap();
    private Set availableReaders;
    private LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders;

    public void add(String key, LogRecordDefinition aLRD) {
        if (key == null) {
            throw new SAPIllegalArgumentException(Location.getLocation((Class)(class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders == null ? (class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders = MetaDataOfReaders.class$("com.sapmarkets.bam.logcontroller.MetaDataOfReaders")) : class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders)), "com.sap.exception.standard_0001", new Object[]{"key"});
        }
        if (aLRD == null) {
            throw new SAPIllegalArgumentException(Location.getLocation((Class)(class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders == null ? (class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders = MetaDataOfReaders.class$("com.sapmarkets.bam.logcontroller.MetaDataOfReaders")) : class$com$sapmarkets$bam$logcontroller$MetaDataOfReaders)), "com.sap.exception.standard_0001", new Object[]{"LRDModel"});
        }
        this.mReadersAndDefinitions.put(key, aLRD);
    }

    public Set getReaderIds() {
        return this.mReadersAndDefinitions.keySet();
    }

    public LogRecordDefinition getDefinitionForReader(String readerId) {
        Set readers = this.mReadersAndDefinitions.keySet();
        if (!readers.contains(readerId)) {
            try {
                throw new IllegalArgumentException(LocalizableTextFormatter.formatString((ResourceAccessor)this.resourceAccessor, (String)"INVALID_READER_ID", null, (Locale)Locale.getDefault(), (TimeZone)TimeZone.getDefault()));
            }
            catch (LocalizationException le) {
                throw new IllegalArgumentException("The readerId passed to the MetaDataOfReaders.getDefinitionForReader is an invalid ID.");
            }
        }
        return (LogRecordDefinition)this.mReadersAndDefinitions.get(readerId);
    }

    public void setAvailableReaders(Set readers) {
        this.availableReaders = readers;
    }

    public Set getAvailableReaders() {
        return this.availableReaders;
    }

    public MetaDataOfReader getReader(String format) throws IllegalArgumentException {
        if (this.availableReaders == null || this.availableReaders.size() == 0) {
            new Tracer("com.sapmarkets.bam.logcontroller.MetaDataOfReaders").traceInfo("MetaDataOfReader.getReader: No available readers found for format " + format);
            return null;
        }
        Map formats = this.getFileReadingCapableFormatsAndAssociatedReaders();
        if (!formats.containsKey(format)) {
            throw new IllegalArgumentException("Reader format '" + format + "' unknown.");
        }
        return (MetaDataOfReader)formats.get(format);
    }

    public List getDescriptionsOfAvailableFileReadingEnabledReaders() {
        if (this.availableReaders == null || this.availableReaders.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.availableReaders.iterator();
        while (iter.hasNext()) {
            MetaDataOfReader element = (MetaDataOfReader)iter.next();
            if (!element.isFileReadingCapable()) continue;
            result.add(element.getReaderDescription());
        }
        return result;
    }

    public List getFileReadingCapableFormats() {
        if (this.availableReaders == null || this.availableReaders.size() == 0) {
            return null;
        }
        ArrayList result = new ArrayList();
        Iterator iter = this.availableReaders.iterator();
        while (iter.hasNext()) {
            MetaDataOfReader element = (MetaDataOfReader)iter.next();
            if (!element.isFileReadingCapable() || element.getSupportedFormats() == null) continue;
            result.addAll(element.getSupportedFormats());
        }
        return result;
    }

    public Map getFileReadingCapableFormatsAndAssociatedReaders() {
        if (this.availableReaders == null || this.availableReaders.size() == 0) {
            return null;
        }
        HashMap<String, MetaDataOfReader> result = new HashMap<String, MetaDataOfReader>();
        Iterator iter = this.availableReaders.iterator();
        while (iter.hasNext()) {
            MetaDataOfReader element = (MetaDataOfReader)iter.next();
            if (!element.isFileReadingCapable() || element.getSupportedFormats() == null) continue;
            List supportedFormats = element.getSupportedFormats();
            Iterator iterator = supportedFormats.iterator();
            while (iterator.hasNext()) {
                String format = (String)iterator.next();
                result.put(format, element);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

