/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.sql.trace.SQLTraceXMLFormatter;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.XMLFormatter;
import com.sap.tc.logging.exceptions.UnsupportedFormatException;
import com.sap.tc.logging.perf.PerfFormatter;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinitionFactory;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.SUID;
import com.sapmarkets.bam.util.XMLHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class MetaDataOfReader
implements Serializable {
    public static final String ASCII_FORMAT = "ASCIIFormat";
    public static final String LIST_FORMAT = "ListFormat";
    public static final String XML_FORMAT = "XMLFormat";
    public static final String TRACE_FORMAT = "TraceFormat";
    public static final String SAT_TRACE_FORMAT = "PerfFormatter";
    public static final String SQL_TRACE_FORMAT = "SQLTraceFormat";
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    public static final long serialVersionUID = SUID.getID();
    private static Locale userLocale = Locale.getDefault();
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private boolean fileReadingCapable;
    private Map mapOfSupportedFormats;
    private String mBeanClassName;
    private List monitoredDataDefinitions;
    private Class[] parameterTypesForReaderConstruction;
    private String readerClassName;
    private String readerDescription;
    private String readerID;
    private List supportedFormats;
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$MetaDataOfReader;

    public MetaDataOfReader() {
    }

    public MetaDataOfReader(Node aNode) {
        this.readAttributesAndTextValues(aNode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MetaDataOfReader other = (MetaDataOfReader)o;
            if (this.readerID != null) {
                return this.readerID.equals(other.readerID);
            }
        }
        return false;
    }

    public Object[] fetchParameterValuesForReaderInstantiation(String file, String format) throws UnsupportedFormatException {
        if (ASCII_FORMAT.equals(format)) {
            return new Object[]{new FileLog(file, (Formatter)new TraceFormatter())};
        }
        if (LIST_FORMAT.equals(format)) {
            return new Object[]{new FileLog(file, (Formatter)new ListFormatter())};
        }
        if (XML_FORMAT.equals(format)) {
            return new Object[]{new FileLog(file, (Formatter)new XMLFormatter())};
        }
        if (TRACE_FORMAT.equals(format)) {
            return new Object[]{new FileLog(file, (Formatter)new TraceFormatter())};
        }
        if (SAT_TRACE_FORMAT.equals(format)) {
            return new Object[]{new FileLog(file, (Formatter)new PerfFormatter())};
        }
        if (SQL_TRACE_FORMAT.equals(format)) {
            return new Object[]{new FileLog(file, (Formatter)new SQLTraceXMLFormatter())};
        }
        try {
            throw new UnsupportedFormatException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"UNSUPPORTED_LOG_RECORD_FORMAT", (Object[])new Object[]{format}, (Locale)userLocale, (TimeZone)userTimeZone));
        }
        catch (LocalizationException le) {
            throw new UnsupportedFormatException(format + " is not one of the formats that can be handled by Log Viewer!");
        }
    }

    public Map getMapOfSupportedFormats() {
        return this.mapOfSupportedFormats;
    }

    public String getFormatID(String formatClass) {
        Set keys = this.mapOfSupportedFormats.keySet();
        Iterator iterKeys = keys.iterator();
        while (iterKeys.hasNext()) {
            String key = (String)iterKeys.next();
            String value = (String)this.mapOfSupportedFormats.get(key);
            if (!value.equals(formatClass)) continue;
            return key;
        }
        return null;
    }

    public String getMBeanClassName() {
        return this.mBeanClassName;
    }

    public List getMonitoredDataDefinitions() {
        return this.monitoredDataDefinitions;
    }

    public Class[] getParameterTypesForReaderConstruction() {
        return this.parameterTypesForReaderConstruction;
    }

    public String getReaderClassName() {
        return this.readerClassName;
    }

    public String getReaderDescription() {
        return this.readerDescription;
    }

    public String getReaderID() {
        return this.readerID;
    }

    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public int hashCode() {
        if (this.readerID == null) {
            return 0;
        }
        int result = 17;
        result = 37 * result + this.readerID.hashCode();
        return result;
    }

    public boolean isFileReadingCapable() {
        return this.fileReadingCapable;
    }

    private void readAttributesAndTextValues(Node aNode) {
        Properties p = XMLHelper.getAttributes(aNode);
        this.readerID = p.getProperty("ID");
        this.fileReadingCapable = "true".equals(p.getProperty("FileReadingCapable"));
        this.monitoredDataDefinitions = new ArrayList();
        this.readMonitoredDataDefinitions(aNode);
        this.mapOfSupportedFormats = new HashMap();
        this.supportedFormats = new ArrayList();
        this.readSupportedFormats(aNode);
        this.readParameterTypesForReaderConstruction(aNode);
        this.readMBeanClassName(aNode);
        this.readReaderClassName(aNode);
        this.readReaderDescription(aNode);
    }

    private void readMBeanClassName(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "MBeanClass");
        Node node = (Node)l.get(0);
        this.mBeanClassName = XMLHelper.getTextBetweenTags(node).trim();
    }

    private void readMonitoredDataDefinitions(Node aNode) {
        Node node = (Node)XMLHelper.getChildNodesByTag(aNode, "MonitoredDataDefinitions").get(0);
        List l = XMLHelper.getChildNodesByTag(node, "MonitoredDataDefinition");
        Iterator i = l.iterator();
        while (i.hasNext()) {
            try {
                this.monitoredDataDefinitions.add(MonitoredDataDefinitionFactory.getInstance().getMonitoredDataDefinition((Node)i.next()));
            }
            catch (BAMAppException e) {
                throw new BAMRuntimeException(Location.getLocation((Class)(class$com$sapmarkets$bam$logcontroller$MetaDataOfReader == null ? (class$com$sapmarkets$bam$logcontroller$MetaDataOfReader = MetaDataOfReader.class$("com.sapmarkets.bam.logcontroller.MetaDataOfReader")) : class$com$sapmarkets$bam$logcontroller$MetaDataOfReader)), (Throwable)((Object)e));
            }
        }
    }

    private void readParameterTypesForReaderConstruction(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "ParameterTypesForReaderConstruction");
        Node node = (Node)l.get(0);
        l = XMLHelper.getChildNodesByTag(node, "ParameterTypeForReaderConstruction");
        this.parameterTypesForReaderConstruction = new Class[l.size()];
        int i = 0;
        while (i < l.size()) {
            node = (Node)l.get(i);
            String className = XMLHelper.getTextBetweenTags(node).trim();
            try {
                this.parameterTypesForReaderConstruction[i] = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new BAMRuntimeException(Location.getLocation((Class)(class$com$sapmarkets$bam$logcontroller$MetaDataOfReader == null ? (class$com$sapmarkets$bam$logcontroller$MetaDataOfReader = MetaDataOfReader.class$("com.sapmarkets.bam.logcontroller.MetaDataOfReader")) : class$com$sapmarkets$bam$logcontroller$MetaDataOfReader)), e);
            }
            ++i;
        }
    }

    private void readReaderClassName(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "ReaderClass");
        Node node = (Node)l.get(0);
        this.readerClassName = XMLHelper.getTextBetweenTags(node).trim();
    }

    private void readReaderDescription(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "ReaderDescription");
        Node node = (Node)l.get(0);
        this.readerDescription = XMLHelper.getTextBetweenTags(node).trim();
    }

    private void readSupportedFormats(Node aNode) {
        List l = XMLHelper.getChildNodesByTag(aNode, "SupportedFormats");
        Node node = (Node)l.get(0);
        l = XMLHelper.getChildNodesByTag(node, "SupportedFormat");
        int i = 0;
        while (i < l.size()) {
            node = (Node)l.get(i);
            this.mapOfSupportedFormats.put(XMLHelper.getAttributeValue(node, "ID"), XMLHelper.getAttributeValue(node, "Class"));
            this.supportedFormats.add(XMLHelper.getAttributeValue(node, "ID"));
            ++i;
        }
    }

    public void setFileReadingCapable(boolean value) {
        this.fileReadingCapable = value;
    }

    public void setMapOfSupportedFormats(Map aMap) {
        this.mapOfSupportedFormats = aMap;
    }

    public void setMBeanClassName(String mBeanClassName) {
        this.mBeanClassName = mBeanClassName;
    }

    public void setMonitoredDataDefinitions(List aList) {
        this.monitoredDataDefinitions = aList;
    }

    public void setParameterTypesForReaderConstruction(Class[] parameterTypesForReaderConstruction) {
        this.parameterTypesForReaderConstruction = parameterTypesForReaderConstruction;
    }

    public void setReaderClassName(String readerClassName) {
        this.readerClassName = readerClassName;
    }

    public void setReaderDescription(String aString) {
        this.readerDescription = aString;
    }

    public void setReaderID(String readerID) {
        this.readerID = readerID;
    }

    public void setSupportedFormats(List supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

