/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.j2ee.services.logviewer.LogViewer;
import com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServer;
import com.sapmarkets.bam.jmxadapter.asciilog.impl.ASCIILogFileProperties;
import com.sapmarkets.bam.util.BAMConfigurationHandler;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class ManualInitLogging {
    public static final String USAGE = "Usage: java -cp classpath ManualInitLogging [-dumpProps propfilename] logviewer_properties_file [start|stop]";
    private static boolean isStandaloneJVM__ = false;
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$ManualInitLogging$RegistryKiller;
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$ManualInitLogging;

    private static void registerRegistryKiller(Properties props) throws NamingException, RemoteException {
        RegistryKillerImpl killer = new RegistryKillerImpl(Thread.currentThread());
        InitialContext ctx = new InitialContext(props);
        ctx.rebind("RegistryKiller", (Object)killer);
    }

    private static void killRegistry(Properties props) throws NamingException, RemoteException {
        InitialContext ctx = new InitialContext(props);
        RegistryKiller killer = (RegistryKiller)PortableRemoteObject.narrow((Object)ctx.lookup("RegistryKiller"), (Class)(class$com$sapmarkets$bam$logcontroller$ManualInitLogging$RegistryKiller == null ? (class$com$sapmarkets$bam$logcontroller$ManualInitLogging$RegistryKiller = ManualInitLogging.class$("com.sapmarkets.bam.logcontroller.ManualInitLogging$RegistryKiller")) : class$com$sapmarkets$bam$logcontroller$ManualInitLogging$RegistryKiller));
        killer.killRegistry();
    }

    public static void setStandaloneJVM(boolean isStandlaoneJVM) {
        isStandaloneJVM__ = isStandlaoneJVM;
    }

    public static boolean isStandaloneJVM() {
        return isStandaloneJVM__;
    }

    public static void main(String[] args) throws Exception {
        ManualInitLogging.setStandaloneJVM(true);
        if (args.length < 2) {
            System.err.println(USAGE);
            System.exit(1);
        }
        boolean dumpProps = false;
        String dumpPropFilename = "";
        int argptr = 0;
        if (args[argptr].equals("-dumpProps")) {
            dumpProps = true;
            dumpPropFilename = args[++argptr];
        }
        Properties configProps = new Properties();
        int n = ++argptr;
        ++argptr;
        String propFilename = args[n];
        try {
            configProps.load(new FileInputStream(new File(propFilename)));
        }
        catch (FileNotFoundException ex) {
            System.err.println("Property file [" + propFilename + "] could not be found (" + ex.getMessage() + ")!");
        }
        new BAMConfigurationHandler(configProps);
        Logger LOG = new Logger(class$com$sapmarkets$bam$logcontroller$ManualInitLogging == null ? (class$com$sapmarkets$bam$logcontroller$ManualInitLogging = ManualInitLogging.class$("com.sapmarkets.bam.logcontroller.ManualInitLogging")) : class$com$sapmarkets$bam$logcontroller$ManualInitLogging);
        Tracer TRACE = new Tracer(class$com$sapmarkets$bam$logcontroller$ManualInitLogging == null ? (class$com$sapmarkets$bam$logcontroller$ManualInitLogging = ManualInitLogging.class$("com.sapmarkets.bam.logcontroller.ManualInitLogging")) : class$com$sapmarkets$bam$logcontroller$ManualInitLogging);
        Properties logViewerProps = BAMConfigurationHandler.getLogviewerProperties();
        int port = ManualInitLogging.extractPort(logViewerProps);
        try {
            if ("stop".equals(args[argptr])) {
                TRACE.traceInfo("Stopping Log Viewer registry on port " + port);
                ManualInitLogging.killRegistry(logViewerProps);
                System.exit(0);
            } else if (!"start".equals(args[argptr])) {
                System.out.println(USAGE);
                System.exit(1);
            }
            TRACE.traceInfo("Starting registry on port " + port);
            System.out.println("Starting registry on port " + port);
            try {
                LocateRegistry.createRegistry(port);
            }
            catch (ExportException ex) {
                String mess = "Registry port " + port + " is in use! Please verify the server properties file for the key Logviewer_java.naming.provider.url and adjust the port if necessary (" + ex.getMessage() + ")";
                LOG.logError(mess);
                System.err.println(mess);
                System.exit(42);
            }
            ManualInitLogging.registerRegistryKiller(logViewerProps);
        }
        catch (NamingException ex) {
            TRACE.logException(ex);
            String err = "\nError: Unable to establish connection to the server. [" + ex.toString() + "]";
            err = err + "Please make sure the server is started.";
            err = err + "Initial Context properties were read from " + propFilename + ".";
            err = err + "Normally, they should be as follows:";
            err = err + "java.naming.factory.initial=com.sun.jndi.rmi.registry.RegistryContextFactory.";
            err = err + "java.naming.provider.url = rmi://localhost:1099";
            err = err + "-------------------------------------------";
            err = err + "Actual values: ";
            err = err + "java.naming.factory.initial: " + ((Hashtable)logViewerProps).get("java.naming.factory.initial");
            err = err + "java.naming.provider.url: " + ((Hashtable)logViewerProps).get("java.naming.provider.url");
            System.err.println(err);
            LOG.logError(err);
            System.exit(1);
        }
        ASCIILogFileProperties theASCIILogFileProperties = new ASCIILogFileProperties(BAMConfigurationHandler.getLogviewerProperties());
        LogViewer logViewer = new LogViewer();
        int socketPort = ManualInitLogging.fixSocketPort(logViewerProps);
        if (dumpProps) {
            ManualInitLogging.dumpProperties(socketPort, port, dumpPropFilename);
        }
        RMIConnectorServer server = logViewer.start();
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException ex) {
            LOG.logInfo("Server stopped on port " + port);
            System.out.println("Server stopped.");
            System.exit(0);
        }
    }

    public static int fetchNextUnusedPort(String host, int startFrom) throws UnknownHostException, IOException {
        int i = startFrom;
        while (i < 65535) {
            try {
                Socket s = new Socket(host, i);
            }
            catch (ConnectException e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int fixSocketPort(Properties p) throws UnknownHostException, IOException {
        int sockPort = 0;
        String sockString = p.getProperty("socketPort");
        if (sockString != null) {
            sockPort = Integer.parseInt(sockString);
        }
        if (sockPort == 0) {
            sockPort = ManualInitLogging.fetchNextUnusedPort("localhost", 5465);
        }
        p.setProperty("socketPort", new Integer(sockPort).toString());
        return sockPort;
    }

    static void dumpProperties(int socketPort, int RMIPort, String propFilename) {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(propFilename));
                out.println("# Properties to by used by com.sapmarkets.bam.util.LogviewerTestSetup (for testing purposes)");
                out.println("# IP address of test Log Viewer server");
                out.println("host=localhost");
                out.println("# P4 or JRMP port for Registry RMI connection");
                out.println("port=" + RMIPort);
                out.println("# J2EE or Standalone for ConnectionProtocol selection.");
                out.println("protocol=Standalone");
                out.println("# Port where the socket log registration listens.");
                out.println("socketport=" + socketPort);
            }
            catch (IOException e) {
                System.err.println("Could not write properties file [" + e.getMessage() + "].");
                Object var6_5 = null;
                if (out != null) {
                    out.close();
                }
            }
            Object var6_4 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private static int extractPort(Properties props) throws UnknownHostException, IOException {
        int result = 0;
        String host = "localhost";
        String url = (String)((Hashtable)props).get("java.naming.provider.url");
        if (url == null) {
            result = 1099;
            url = "rmi://localhost:1099";
        } else {
            String portString = url.substring(url.lastIndexOf(58) + 1);
            result = Integer.parseInt(portString);
            host = url.substring(6, url.lastIndexOf(58));
        }
        if (result <= 0) {
            result = ManualInitLogging.fetchNextUnusedPort(host, 1099);
            props.setProperty("java.naming.provider.url", url.substring(0, url.lastIndexOf(58) + 1) + result);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RegistryKillerImpl
    extends PortableRemoteObject
    implements RegistryKiller {
        private static Thread mainThread;

        public RegistryKillerImpl(Thread mainThread) throws RemoteException {
            RegistryKillerImpl.mainThread = mainThread;
        }

        public void killRegistry() {
            mainThread.interrupt();
        }
    }

    public static interface RegistryKiller
    extends Remote {
        public void killRegistry() throws RemoteException;
    }
}

