/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.tc.logging.Location;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MDDNotFoundException;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.util.BAMRuntimeException;
import java.util.Comparator;

public class LogRecordComparator
implements Comparator {
    public int compare(Object logRecord1, Object logRecord2) {
        MonitoredData md2;
        MonitoredData md1;
        LogRecord lr1 = (LogRecord)logRecord1;
        LogRecord lr2 = (LogRecord)logRecord2;
        if (lr1 == null && lr2 == null) {
            return 0;
        }
        if (lr1 == null) {
            return -1;
        }
        if (lr2 == null) {
            return 1;
        }
        LogRecordDefinition lrDef1 = lr1.getLogRecordDefinition();
        LogRecordDefinition lrDef2 = lr2.getLogRecordDefinition();
        try {
            md1 = lr1.getSpecificMonitoredData(lrDef1.getSequence());
            md2 = lr2.getSpecificMonitoredData(lrDef2.getSequence());
        }
        catch (MDDNotFoundException e) {
            throw new BAMRuntimeException(Location.getLocation((String)"com.sapmarkets.bam.logcontroller"), "LOG_RECORDS_FROM_NONCOMPARABLE_DATA_SOURCES", (Throwable)((Object)e));
        }
        if (md1 == null) {
            return -1;
        }
        if (md2 == null) {
            return 1;
        }
        Comparable date1 = (Comparable)md1.getValue();
        Comparable date2 = (Comparable)md2.getValue();
        return date1.compareTo(date2);
    }
}

