/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.SUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LogRecord
implements Serializable {
    private List someMonitoredData;
    private LogRecordDefinition mLogRecordDefinition;
    public static final long serialVersionUID = SUID.getID();

    public LogRecord(List monitoredData, LogRecordDefinition logRecordDefinition) {
        this.mLogRecordDefinition = logRecordDefinition;
        this.someMonitoredData = monitoredData;
    }

    public LogRecord(LogRecord logRecord, LogRecordDefinition combinedLogRecordDefinition) {
        this.mLogRecordDefinition = combinedLogRecordDefinition;
        this.someMonitoredData = new ArrayList();
        Collection someMDDs = this.mLogRecordDefinition.getMonitoredDataDefinitions();
        Iterator i = someMDDs.iterator();
        while (i.hasNext()) {
            MonitoredDataDefinition aMDD = (MonitoredDataDefinition)i.next();
            MonitoredData m = logRecord.getSpecificMonitoredData(aMDD);
            if (m != null) {
                this.someMonitoredData.add(m);
                continue;
            }
            this.someMonitoredData.add(new MonitoredData("", aMDD));
        }
    }

    public List getMonitoredData() {
        return this.someMonitoredData;
    }

    public MonitoredData getMonitoredDataAt(int i) {
        return (MonitoredData)this.someMonitoredData.get(i);
    }

    public MonitoredData getSpecificMonitoredData(MonitoredDataDefinition mdd) {
        MonitoredData md = null;
        int i = 0;
        while (md == null && i < this.someMonitoredData.size()) {
            MonitoredData cm = (MonitoredData)this.someMonitoredData.get(i);
            if (cm.getDefinition().equals(mdd)) {
                md = cm;
            }
            ++i;
        }
        return md;
    }

    public MonitoredData getMonitoredDataByKey(String key) {
        Iterator itr = this.someMonitoredData.iterator();
        while (itr.hasNext()) {
            MonitoredData md = (MonitoredData)itr.next();
            boolean hasKey = md.getDefinition().getMonitoredDataDefinitionID().equalsIgnoreCase(key);
            if (!hasKey) continue;
            return md;
        }
        return null;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.mLogRecordDefinition;
    }

    public MonitoredData getMonitoredData(String mddId) {
        MonitoredData monitoredData = null;
        int i = 0;
        while (i < this.someMonitoredData.size()) {
            MonitoredData md = (MonitoredData)this.someMonitoredData.get(i);
            if (md.getDefinition().getMonitoredDataDefinitionID().equals(mddId)) {
                monitoredData = md;
                break;
            }
            ++i;
        }
        return monitoredData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Collection mdds = this.mLogRecordDefinition.getMonitoredDataDefinitions();
            Iterator itr = mdds.iterator();
            while (itr.hasNext()) {
                MonitoredDataDefinition mdd = (MonitoredDataDefinition)itr.next();
                MonitoredData mdd1 = this.getMonitoredData(mdd.getMonitoredDataDefinitionID());
                MonitoredData mdd2 = ((LogRecord)obj).getMonitoredData(mdd.getMonitoredDataDefinitionID());
                if (mdd1 == null || mdd2 == null) {
                    return false;
                }
                if (mdd1.equals(mdd2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String result = "{LR (" + this.getMonitoredData().size() + " MDDs):\n";
        Iterator i = this.getMonitoredData().iterator();
        while (i.hasNext()) {
            result = result + ((MonitoredData)i.next()).toString();
        }
        return result + "}";
    }

    public int hashCode() {
        int result = 17;
        Iterator itr = this.someMonitoredData.iterator();
        while (itr.hasNext()) {
            MonitoredData md = (MonitoredData)itr.next();
            if (md.getValue() == null) continue;
            result = result * 37 + md.hashCode();
        }
        return result;
    }
}

