/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.exception.BaseException;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.QueryResultSet;
import com.sapmarkets.bam.util.SUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LogQueryResultset
implements QueryResultSet {
    private List mLogRecordList = Collections.synchronizedList(new ArrayList());
    private LogRecordDefinition mLogRecordDefinition;
    private List caughtExceptions;
    private long counterOfRecordsRead;
    private boolean isTimedOut;
    private boolean isLatest = false;
    private boolean isOldest = false;
    public static final long serialVersionUID = SUID.getID();

    public LogQueryResultset(LogRecordDefinition aLogRecordDefinition) {
        this.mLogRecordDefinition = aLogRecordDefinition;
        this.caughtExceptions = new ArrayList();
    }

    public List getResult() {
        return this.mLogRecordList;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.mLogRecordDefinition;
    }

    public void appendLogrecords(Collection logRecordModels) {
        this.mLogRecordList.addAll(logRecordModels);
    }

    public void appendLogrecord(LogRecord lr) {
        this.mLogRecordList.add(lr);
    }

    public boolean hadExceptionsDuringReading() {
        return this.caughtExceptions != null && this.caughtExceptions.size() > 0;
    }

    public int size() {
        return this.mLogRecordList.size();
    }

    public void setCounterOfRecordsRead(long counter) {
        this.counterOfRecordsRead = counter;
    }

    public long getCounterOfRecordsRead() {
        return this.counterOfRecordsRead;
    }

    public List getExceptionsDuringReading() {
        return this.caughtExceptions;
    }

    public void addCaughtExceptions(List e) {
        this.caughtExceptions.addAll(e);
    }

    public void addCaughtException(Throwable ex) {
        this.caughtExceptions.add(ex);
    }

    public void addBaseException(BaseException e) {
        this.caughtExceptions.add(e);
    }

    public void setTimedOut(boolean timedOut) {
        this.isTimedOut = timedOut;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public boolean isOldest() {
        return this.isOldest;
    }

    public void setLatest(boolean b) {
        this.isLatest = b;
    }

    public void setOldest(boolean b) {
        this.isOldest = b;
    }

    public String toString() {
        return "LogQueryResultSet: size=" + this.mLogRecordList.size() + " Exceptions: " + this.caughtExceptions.toString();
    }
}

