/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.application.MergeEngine;
import com.sapmarkets.bam.logcontroller.BAMLogReader;
import com.sapmarkets.bam.logcontroller.BAMLogReaderRecordSource;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogQueryBrowser {
    private LogQueryExpression expression;
    private List recordSources;
    private boolean isFastSearchable;
    private String[] fastSearchFor;
    private DownloadSpecs downloadSpecs;
    private MergeEngine mergeEngine;

    public LogQueryBrowser(LogQueryExpression anExpr, List bamlogReaders, DownloadSpecs aDownloadSpecs) {
        this.expression = anExpr;
        this.downloadSpecs = aDownloadSpecs == null ? new DownloadSpecs(0L, false) : aDownloadSpecs;
        this.recordSources = new ArrayList();
        Iterator itr = bamlogReaders.iterator();
        while (itr.hasNext()) {
            BAMLogReader bamlogReader = (BAMLogReader)itr.next();
            BAMLogReaderRecordSource recordSource = new BAMLogReaderRecordSource(bamlogReader, anExpr, this.downloadSpecs);
            this.recordSources.add(recordSource);
        }
        this.mergeEngine = new MergeEngine(this.recordSources, this.downloadSpecs);
    }

    public LogQueryExpression getLogQueryExpression() {
        return this.expression;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.mergeEngine.getLogRecordDefinition();
    }

    public LogQueryResultset getNext(int numRecords) {
        return this.mergeEngine.getNext(numRecords);
    }

    public LogQueryResultset getOldest(int numRecords) {
        return this.mergeEngine.getOldest(numRecords);
    }

    public LogQueryResultset getPrevious(int numRecords) {
        return this.mergeEngine.getPrevious(numRecords);
    }

    public LogQueryResultset getLatest(int numRecords) {
        return this.mergeEngine.getLatest(numRecords);
    }

    public void stopRunning() {
        this.mergeEngine.stopBrowsing();
    }

    public void closeBrowser() {
        Iterator itr = this.recordSources.iterator();
        while (itr.hasNext()) {
            BAMLogReaderRecordSource recordSource = (BAMLogReaderRecordSource)itr.next();
            recordSource.close();
        }
    }
}

