/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.jmx.connector.LVMBeanServer;
import com.sapmarkets.bam.jmx.connector.LVMBeanServerFactory;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class LogMBeanPing {
    private static void printLogsInfo(LVMBeanServer mbeanServer, String type) throws Exception {
        ObjectName objNamePattern = new ObjectName("*:type=" + type + ",*");
        Set<ObjectName> names = mbeanServer.queryNames(objNamePattern, null);
        int counter = 0;
        Iterator itr = names.iterator();
        while (itr.hasNext()) {
            ObjectName name = (ObjectName)itr.next();
            String logName = (String)mbeanServer.getAttribute(name, "LogName");
            String logPath = (String)mbeanServer.getAttribute(name, "LogPath");
            System.out.println("LogName: " + logName);
            System.out.println("    LogPath: " + logPath);
            System.out.println("    ObjectName: " + name + "\n");
            ++counter;
        }
        System.out.println(type + ": " + counter + "\n");
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 1) {
            System.err.println("Invalid argument");
            System.err.println("Usage: LogMBeanPing <path of startupLoggin.properties>");
            return;
        }
        try {
            String startPropFile = args[0];
            Properties configProps = new Properties();
            configProps.load(new FileInputStream(startPropFile));
            LVMBeanServer mbeanServer = LVMBeanServerFactory.createJRMPLVMBeanServer(configProps);
            System.out.println("MBeans: " + mbeanServer.getMBeanCount() + "\n");
            LogMBeanPing.printLogsInfo(mbeanServer, LogTypeEnumeration.SAPJLOG.toString());
            LogMBeanPing.printLogsInfo(mbeanServer, LogTypeEnumeration.ASCII_LOG.toString());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

