/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.util.SUID;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;

public class LogInfo
implements Serializable {
    public static final long serialVersionUID = SUID.getID();
    private String mbeanServerID;
    private Map attributes;
    private ObjectName objectName;
    private String hostName;
    private String clusterNodeName;
    private MetaDataOfReaders readers;
    private Set attributeDescriptors;

    public LogInfo(ObjectName name, String hostName, String clusterNodeName, String mbeanServerID) {
        this.mbeanServerID = mbeanServerID;
        this.objectName = name;
        this.hostName = hostName;
        this.clusterNodeName = clusterNodeName;
        this.attributes = new HashMap();
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void putAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void putAllAttribute(List attributeList) {
        Iterator iter = attributeList.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            this.attributes.put(attr.getName(), attr.getValue());
        }
    }

    public Map getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getClusterNodeName() {
        return this.clusterNodeName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Set getAttributeDescriptors() {
        return this.attributeDescriptors;
    }

    public void setAttributeDescriptors(Set set) {
        this.attributeDescriptors = set;
    }

    public void setMetaDataOfReaders(MetaDataOfReaders readers) {
        this.readers = readers;
    }

    public MetaDataOfReaders getMetaDataOfReaders() {
        return this.readers;
    }

    public String getMbeanServerID() {
        return this.mbeanServerID;
    }
}

