/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.exception.BaseException;
import com.sap.tc.logging.Location;
import com.sapmarkets.bam.application.RecordSource;
import com.sapmarkets.bam.logcontroller.BAMLogReader;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.GrepExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BAMLogReaderRecordSource
implements RecordSource {
    private BAMLogReader bamlogReader;
    private LogQueryExpression expression;
    private DownloadSpecs downloadSpecs;
    private boolean isFastSearchable;
    private String[] fastSearchFor;
    private long durationForExecution;
    static /* synthetic */ Class class$java$lang$String;

    public BAMLogReaderRecordSource(BAMLogReader bamlogReader, LogQueryExpression expression, DownloadSpecs downloadSpecs) {
        this.bamlogReader = bamlogReader;
        this.expression = expression == null ? new GrepExpression(null) : expression;
        this.downloadSpecs = downloadSpecs;
        this.initFastSearch();
        if (downloadSpecs.shouldApplyDownloadSpecs()) {
            this.durationForExecution = downloadSpecs.getTimeBeforeServerReturns();
        }
    }

    private void initFastSearch() {
        ArrayList fastSearchContainer = new ArrayList();
        if (this.expression.getqueryType() != 20 && this.expression.hasChildren()) {
            fastSearchContainer.addAll(this.getFastSearchParametersOutOfExpression(this.expression.getChildren()));
        }
        if (fastSearchContainer.size() > 0) {
            this.isFastSearchable = true;
            this.fastSearchFor = new String[fastSearchContainer.size()];
            int i = 0;
            while (i < fastSearchContainer.size()) {
                this.fastSearchFor[i] = (String)fastSearchContainer.get(i);
                ++i;
            }
        }
    }

    private List getFastSearchParametersOutOfExpression(Collection expressions) {
        ArrayList<String> searchFor = new ArrayList<String>();
        Iterator itr = expressions.iterator();
        while (itr.hasNext()) {
            Collection paramDescr;
            MonitoredDataDefinition mdd;
            LogQueryExpression expr = (LogQueryExpression)itr.next();
            if (expr.hasChildren()) {
                searchFor.addAll(this.getFastSearchParametersOutOfExpression(expr.getChildren()));
                continue;
            }
            if (expr.getqueryType() == 20 || expr.getqueryType() == 30 || (mdd = expr.getMonitoredDataDef()) == null || !mdd.isFastSearchable() || !mdd.getMonitoredDataDefinitionType().equalsIgnoreCase("String") || (paramDescr = expr.getSearchParameters()) == null) continue;
            Iterator paramItr = paramDescr.iterator();
            while (paramItr.hasNext()) {
                ParameterDescriptor descr = (ParameterDescriptor)paramItr.next();
                if (descr == null || descr.getType() != (class$java$lang$String == null ? BAMLogReaderRecordSource.class$("java.lang.String") : class$java$lang$String) || descr.getValue() == null) continue;
                searchFor.add(descr.getValue().toString());
            }
        }
        return searchFor;
    }

    public LogQueryResultset getLatest(int numRecords) {
        ReadHelper readHelper = new ReadHelper(){
            boolean isFirstRead = true;

            List doRead() {
                List logrecords = new ArrayList();
                if (BAMLogReaderRecordSource.this.isFastSearchable) {
                    logrecords = BAMLogReaderRecordSource.this.bamlogReader.getPreviousMatch(BAMLogReaderRecordSource.this.fastSearchFor);
                } else if (this.isFirstRead) {
                    logrecords = BAMLogReaderRecordSource.this.bamlogReader.readLatest();
                    this.isFirstRead = false;
                } else {
                    logrecords = BAMLogReaderRecordSource.this.bamlogReader.readPrevious();
                }
                return logrecords;
            }

            int getDirection() {
                return 4;
            }
        };
        return this.read(numRecords, readHelper);
    }

    public LogQueryResultset getOldest(int numRecords) {
        ReadHelper readHelper = new ReadHelper(){
            boolean isFirstRead = true;

            List doRead() {
                List logrecords = new ArrayList();
                if (BAMLogReaderRecordSource.this.isFastSearchable) {
                    logrecords = BAMLogReaderRecordSource.this.bamlogReader.getNextMatch(BAMLogReaderRecordSource.this.fastSearchFor);
                } else if (this.isFirstRead) {
                    logrecords = BAMLogReaderRecordSource.this.bamlogReader.readOldest();
                    this.isFirstRead = false;
                } else {
                    logrecords = BAMLogReaderRecordSource.this.bamlogReader.readNext();
                }
                return logrecords;
            }

            int getDirection() {
                return 3;
            }
        };
        return this.read(numRecords, readHelper);
    }

    private LogQueryResultset read(int numRecords, ReadHelper readHelper) {
        LogQueryResultset resultSet = new LogQueryResultset(this.getLogRecordDefinition());
        this.bamlogReader.resetExceptions();
        int counter = 0;
        long startTime = System.currentTimeMillis();
        while (resultSet.getResult().size() < numRecords) {
            List logrecords = readHelper.doRead();
            LogRecord logrecord = null;
            if (logrecords != null && logrecords.size() > 0) {
                logrecord = (LogRecord)logrecords.get(0);
            }
            ++counter;
            if (logrecord == null) break;
            if (this.expression.evaluate(logrecord)) {
                resultSet.appendLogrecord(logrecord);
            }
            if (!this.downloadSpecs.shouldApplyDownloadSpecs() || System.currentTimeMillis() <= startTime + this.durationForExecution) continue;
            resultSet.setTimedOut(true);
            break;
        }
        resultSet.setCounterOfRecordsRead(counter);
        Iterator iter = this.bamlogReader.getExceptionsDuringReading().iterator();
        while (iter.hasNext()) {
            Throwable ex = (Throwable)iter.next();
            resultSet.addBaseException(new BaseException(Location.getLocation(ex.getClass()), ex));
        }
        if (!resultSet.isTimedOut() && resultSet.getResult().size() < numRecords) {
            if (readHelper.getDirection() == 4 || readHelper.getDirection() == 3) {
                resultSet.setLatest(true);
                resultSet.setOldest(true);
            } else if (readHelper.getDirection() == 1) {
                resultSet.setOldest(true);
            } else if (readHelper.getDirection() == 2) {
                resultSet.setLatest(true);
            }
        }
        return resultSet;
    }

    public LogQueryResultset getNext(int numRecords) {
        ReadHelper readHelper = new ReadHelper(){

            List doRead() {
                List logrecords = new ArrayList();
                logrecords = BAMLogReaderRecordSource.this.isFastSearchable ? BAMLogReaderRecordSource.this.bamlogReader.getNextMatch(BAMLogReaderRecordSource.this.fastSearchFor) : BAMLogReaderRecordSource.this.bamlogReader.readNext();
                return logrecords;
            }

            int getDirection() {
                return 2;
            }
        };
        return this.read(numRecords, readHelper);
    }

    public LogQueryResultset getPrevious(int numRecords) {
        ReadHelper readHelper = new ReadHelper(){

            List doRead() {
                List logrecords = new ArrayList();
                logrecords = BAMLogReaderRecordSource.this.isFastSearchable ? BAMLogReaderRecordSource.this.bamlogReader.getPreviousMatch(BAMLogReaderRecordSource.this.fastSearchFor) : BAMLogReaderRecordSource.this.bamlogReader.readPrevious();
                return logrecords;
            }

            int getDirection() {
                return 1;
            }
        };
        return this.read(numRecords, readHelper);
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.bamlogReader.getLogRecordDefinition();
    }

    public void close() {
        this.bamlogReader.closeLog();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private abstract class ReadHelper {
        public static final int PREVIOUS = 1;
        public static final int NEXT = 2;
        public static final int OLDEST = 3;
        public static final int LATEST = 4;

        private ReadHelper() {
        }

        abstract int getDirection();

        abstract List doRead();
    }
}

