/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.logcontroller;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sap.tc.logging.reader.ReadableLog;
import com.sapmarkets.bam.application.LogId;
import com.sapmarkets.bam.logcontroller.BAMLogReader;
import com.sapmarkets.bam.logcontroller.LogAttribute;
import com.sapmarkets.bam.logcontroller.LogPropertyReader;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MDDNotFoundException;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LogDataSourceException;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.ReadLogRecordException;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public abstract class AbstractBAMLogReader
implements BAMLogReader {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$logcontroller$AbstractBAMLogReader == null ? (class$com$sapmarkets$bam$logcontroller$AbstractBAMLogReader = AbstractBAMLogReader.class$("com.sapmarkets.bam.logcontroller.AbstractBAMLogReader")) : class$com$sapmarkets$bam$logcontroller$AbstractBAMLogReader);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$logcontroller$AbstractBAMLogReader == null ? (class$com$sapmarkets$bam$logcontroller$AbstractBAMLogReader = AbstractBAMLogReader.class$("com.sapmarkets.bam.logcontroller.AbstractBAMLogReader")) : class$com$sapmarkets$bam$logcontroller$AbstractBAMLogReader);
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private static Locale userLocale = Locale.getDefault();
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    protected static final int numRec = 1;
    static final String READROTATIONFILEEXCEPTION = "ReadRotatingFilesException";
    protected LogId mLogID;
    protected IReadableLog readableLog;
    protected LogRecordDefinition logRecordDefinition;
    private String mLogType;
    private List exceptions = new ArrayList();
    private Exception lastException = null;
    boolean fatalException = false;
    boolean isFastSearchEnabled = true;
    boolean checkedForFastSearchAvailability = false;
    private static Set readableLogs = new HashSet();
    static /* synthetic */ Class class$com$sapmarkets$bam$logcontroller$AbstractBAMLogReader;

    public void init(String logType, IReadableLog readableLog) {
        this.readableLog = readableLog;
        this.fatalException = false;
        this.mLogType = logType;
        LogPropertyReader lpr = new LogPropertyReader(logType);
        this.logRecordDefinition = lpr.getLogRecordDefinition();
        if (this.logRecordDefinition == null) {
            try {
                throw new IllegalStateException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"LOG_RECORD_DEFINITION_IS_NULL", (Object[])new Object[]{logType}, (Locale)userLocale, (TimeZone)userTimeZone));
            }
            catch (LocalizationException le) {
                throw new IllegalStateException("The LogRecordDefinition is null for " + logType + ".");
            }
        }
    }

    public void resetExceptions() {
        this.exceptions = new ArrayList();
        this.lastException = null;
        this.fatalException = false;
    }

    public void clearExceptions() {
        this.exceptions.clear();
        this.lastException = null;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.logRecordDefinition;
    }

    public boolean hadExceptionsDuringReading() {
        return this.exceptions != null && this.exceptions.size() > 0;
    }

    public List getExceptionsDuringReading() {
        return this.exceptions;
    }

    public void addException(Throwable e) {
        this.exceptions.add(e);
        this.lastException = (Exception)e;
    }

    protected List createLogRecords(ILoggingResultSet records) throws ReadLogRecordException {
        if (!records.isValid()) {
            Exception ex = records.getException();
            if (ex.getClass().getName().equalsIgnoreCase(READROTATIONFILEEXCEPTION)) {
                records = this.handleRotatingReadException(records);
            }
            this.handleDataSourceException(ex);
            this.fatalException = true;
        }
        ArrayList<LogRecord> someLogRecords = new ArrayList<LogRecord>();
        int i = 0;
        while (i < records.getSize()) {
            List md = this.createMD((com.sap.tc.logging.LogRecord)records.getResults().get(i));
            someLogRecords.add(new LogRecord(md, this.getLogRecordDefinition()));
            ++i;
        }
        return someLogRecords;
    }

    public List getNextMatch(String[] match) {
        LogRecordReaderMatch lr = new LogRecordReaderMatch(match){

            public ILoggingResultSet doRead() throws Exception {
                ILoggingResultSet resultSet = AbstractBAMLogReader.this.readableLog.readOldestMsgRecords(1);
                return resultSet;
            }

            public ILoggingResultSet doReadMatch() throws Exception {
                return AbstractBAMLogReader.this.readableLog.getNextMatch(this.theMatchStrings, true);
            }
        };
        return lr.readAndConvertRecords();
    }

    public List getPreviousMatch(String[] match) {
        LogRecordReaderMatch lr = new LogRecordReaderMatch(match){

            public ILoggingResultSet doRead() throws Exception {
                ILoggingResultSet resultSet = AbstractBAMLogReader.this.readableLog.readPrevMsgRecords(1);
                return resultSet;
            }

            public ILoggingResultSet doReadMatch() throws Exception {
                return AbstractBAMLogReader.this.readableLog.getPreviousMatch(this.theMatchStrings, true);
            }
        };
        return lr.readAndConvertRecords();
    }

    public List readOldest() {
        LogRecordReader lr = new LogRecordReader(){

            public ILoggingResultSet doRead() throws Exception {
                ILoggingResultSet resultSet = AbstractBAMLogReader.this.readableLog.readOldestMsgRecords(1);
                return resultSet;
            }
        };
        return lr.readAndConvertRecords();
    }

    public List readLatest() {
        LogRecordReader lr = new LogRecordReader(){

            public ILoggingResultSet doRead() throws Exception {
                ILoggingResultSet resultSet = AbstractBAMLogReader.this.readableLog.readLatestMsgRecords(1);
                return resultSet;
            }
        };
        return lr.readAndConvertRecords();
    }

    public List readNext() {
        LogRecordReader lr = new LogRecordReader(){

            public ILoggingResultSet doRead() throws Exception {
                ILoggingResultSet resultSet = AbstractBAMLogReader.this.readableLog.readNextMsgRecords(1);
                return resultSet;
            }
        };
        return lr.readAndConvertRecords();
    }

    public List readPrevious() {
        LogRecordReader lr = new LogRecordReader(){

            public ILoggingResultSet doRead() throws Exception {
                ILoggingResultSet resultSet = AbstractBAMLogReader.this.readableLog.readPrevMsgRecords(1);
                return resultSet;
            }
        };
        return lr.readAndConvertRecords();
    }

    public LogId getLogId() {
        return this.mLogID;
    }

    void setLogId(LogId logId) {
        this.mLogID = logId;
    }

    public String getLogDisplayName() {
        if (this.readableLog.getName() == null) {
            return "";
        }
        return this.readableLog.getName();
    }

    public String getLogName() {
        return this.readableLog.getPattern();
    }

    public String getAbsoluteLogPattern() {
        String logParent = this.readableLog.getParent() == null ? "." : this.readableLog.getParent();
        String dirname = "";
        try {
            dirname = new File(logParent).getCanonicalPath();
        }
        catch (IOException exception) {
            LOG.logWarning("Problem while getting the absolute path for the log " + this.readableLog + exception);
            dirname = new File(logParent).getAbsolutePath();
        }
        String pattern = this.readableLog.getPattern();
        pattern = pattern.substring(pattern.lastIndexOf(File.separator) + 1);
        pattern = pattern.substring(pattern.lastIndexOf("/") + 1);
        return dirname + File.separator + pattern;
    }

    public int getFileCount() {
        return this.readableLog.getCnt();
    }

    public int getFileLimit() {
        return this.readableLog.getLimit();
    }

    public static IReadableLog createReadableLog(IReadableLog readableLog) {
        IReadableLog rl = readableLog.createReadableLog();
        readableLogs.add(rl);
        return rl;
    }

    public static IReadableLog createReadableLog(FileLog fileLog) {
        IReadableLog rl = ReadableLog.createReadableLog((FileLog)fileLog);
        readableLogs.add(rl);
        return rl;
    }

    public static void closeReadableLog(FileLog filelog) {
        String fileLogName = filelog.getName();
        Iterator itr = readableLogs.iterator();
        while (itr.hasNext()) {
            IReadableLog rl = (IReadableLog)itr.next();
            String readableLogPath = rl.getPattern();
            if (!readableLogPath.equals(fileLogName)) continue;
            TRACE.traceDebug("Invoking closeReadableLog: " + rl.getName());
            rl.close();
        }
    }

    public BAMLogReader createBAMLogReader(LogId logId) {
        AbstractBAMLogReader copyAbstractBAMLogReader = null;
        try {
            copyAbstractBAMLogReader = (AbstractBAMLogReader)super.clone();
            copyAbstractBAMLogReader.readableLog = (ReadableLog)AbstractBAMLogReader.createReadableLog(this.readableLog);
        }
        catch (CloneNotSupportedException e) {
            LOG.logFatal("createBAMLogReader() Failed to copy FileLog: " + e);
            throw new BAMRuntimeException(LOG.getLocation(), "CLONE_NOT_CREATED", new Object[]{"AbstractBAMLogReader"}, e);
        }
        copyAbstractBAMLogReader.setLogId(logId);
        return copyAbstractBAMLogReader;
    }

    public FormatterType getFormatterType() {
        return this.readableLog.getFormatter().getFormatterType();
    }

    public String getSeverity() {
        return Severity.toString((int)this.readableLog.getEffectiveSeverity());
    }

    public void setSeverity(String newSev) {
        int newSevInt = Severity.parse((String)newSev.toUpperCase());
        this.readableLog.setEffectiveSeverity(newSevInt);
    }

    public String getEncoding() {
        return this.readableLog.getEncoding();
    }

    public void setEncoding(String newEnc) {
        this.readableLog.setEncoding(newEnc);
    }

    public Exception getExceptionOfLastRead() {
        return this.lastException;
    }

    protected abstract HashMap createLogAttributes(com.sap.tc.logging.LogRecord var1);

    protected List createMD(com.sap.tc.logging.LogRecord msgRecord) {
        ArrayList<MonitoredData> md = new ArrayList<MonitoredData>();
        HashMap la = this.createLogAttributes(msgRecord);
        MonitoredDataDefinition monitoredDataDefinition = null;
        ArrayList mdd = new ArrayList(this.getLogRecordDefinition().getMonitoredDataDefinitions());
        Iterator itr = ((AbstractList)mdd).iterator();
        while (itr.hasNext()) {
            try {
                monitoredDataDefinition = (MonitoredDataDefinition)itr.next();
                LogAttribute logAttribute = (LogAttribute)la.get(monitoredDataDefinition.getMonitoredDataDefinitionID());
                MonitoredData monitoredData = new MonitoredData(logAttribute.getValue(), monitoredDataDefinition);
                md.add(monitoredData);
            }
            catch (MDDNotFoundException e) {
                LOG.logError("An monitored data definition could not be found. See exception after this!");
                LOG.logException((Throwable)((Object)e));
            }
            catch (Throwable e) {
                String logrecord = msgRecord != null ? "Logging LogRecord=[msg=" + msgRecord.getMsgClear() + " ID=" + msgRecord.getId() + "]" : "Logging LogRecord is NULL! [BUG]";
                LOG.logError("Problem reading LogRecord - ignoring. Logging exception in next error.\nLog filename: " + (this.readableLog.getFileName() != null ? this.readableLog.getFileName() : "null") + "MDD: [" + monitoredDataDefinition + "]" + "LR: " + logrecord);
                LOG.logException(e);
            }
        }
        return md;
    }

    public String getLogType() {
        return this.mLogType;
    }

    public boolean hasFatalExceptions() {
        return this.fatalException;
    }

    public void handleDataSourceNotFoundException(Exception ex) {
        String dataSource = this.getLogName();
        this.addException((Throwable)((Object)new LogDataSourceException(LOG.getLocation(), "FILE_NOT_FOUND", ex, dataSource)));
    }

    public void handleDataSourceException(Exception ex) {
        String dataSource = this.getLogName();
        this.addException((Throwable)((Object)new LogDataSourceException(LOG.getLocation(), "DATA_SOURCE_ERROR", ex, dataSource)));
    }

    protected ILoggingResultSet handleRotatingReadException(ILoggingResultSet records) throws ReadLogRecordException {
        try {
            records = this.readableLog.readOldestMsgRecords(1);
        }
        catch (IllegalArgumentException e) {
            throw new ReadLogRecordException(LOG.getLocation(), e.toString(), e);
        }
        catch (FileNotFoundException e) {
            throw new ReadLogRecordException(LOG.getLocation(), e.toString(), e);
        }
        catch (IOException e) {
            throw new ReadLogRecordException(LOG.getLocation(), e.toString(), e);
        }
        catch (SecurityException e) {
            throw new ReadLogRecordException(LOG.getLocation(), e.toString(), e);
        }
        catch (NullPointerException e) {
            throw new ReadLogRecordException(LOG.getLocation(), e.toString(), e);
        }
        catch (Exception e) {
            throw new ReadLogRecordException(LOG.getLocation(), e.toString(), e);
        }
        return records;
    }

    public String getDataSourceName() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), "UNRESOLVABLE_HOST_NAME", e);
        }
        String hostname = localAddress.getHostName();
        return hostname + ":" + this.getLogName();
    }

    public int getNumberOfLogRecordsWritten() {
        return this.readableLog.getNumberOfLogRecordsWritten();
    }

    public long getLastModified() {
        try {
            if (this.getLog() != null) {
                return this.getLog().getLastModified();
            }
            return 0L;
        }
        catch (IOException e) {
        }
        catch (Throwable thr) {
            LOG.logError("SAP Log Reader caught a problem: " + thr.getMessage() + "\nWill continue and log exception. Please contact SAP support for an updated logging parser!");
        }
        return 0L;
    }

    public boolean areLoggingAttributesEditable() {
        return this.readableLog.areLoggingAttributesEditable();
    }

    public long length() {
        try {
            return this.readableLog.getFileLength();
        }
        catch (Exception e) {
            this.addException(e);
            return -1L;
        }
    }

    public IReadableLog getLog() {
        return this.readableLog;
    }

    public void closeLog() {
        this.readableLog.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private abstract class LogRecordReaderMatch
    extends LogRecordReader {
        String[] theMatchStrings;
        boolean caseSensitive;
        static /* synthetic */ Class array$Ljava$lang$String;

        LogRecordReaderMatch(String[] match) {
            this.theMatchStrings = match;
        }

        abstract ILoggingResultSet doReadMatch() throws Exception;

        void checkCompatibility() {
            if (!AbstractBAMLogReader.this.checkedForFastSearchAvailability) {
                AbstractBAMLogReader.this.checkedForFastSearchAvailability = true;
                try {
                    Class[] params = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = LogRecordReaderMatch.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                    Method method = AbstractBAMLogReader.this.readableLog.getClass().getMethod("getPreviousMatch", params);
                }
                catch (NoSuchMethodException e) {
                    LOG.logWarning("There is no getNextMatch method in Logging. This could mean, that logging needs to be updated. Turning off fast search.");
                    AbstractBAMLogReader.this.isFastSearchEnabled = false;
                }
            }
        }

        public ILoggingResultSet getRecords() throws Exception {
            if (AbstractBAMLogReader.this.isFastSearchEnabled) {
                return this.doReadMatch();
            }
            return this.doRead();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private abstract class LogRecordReader {
        private LogRecordReader() {
        }

        void checkCompatibility() {
        }

        abstract ILoggingResultSet doRead() throws Exception;

        public List readAndConvertRecords() {
            this.checkCompatibility();
            AbstractBAMLogReader.this.clearExceptions();
            ILoggingResultSet someRecords = null;
            ArrayList resultLogRecords = null;
            try {
                someRecords = this.getRecords();
                resultLogRecords = AbstractBAMLogReader.this.createLogRecords(someRecords);
            }
            catch (ReadLogRecordException e) {
                LOG.logWarning("There was a problem reading log records in '" + AbstractBAMLogReader.this.getLogDisplayName() + "' exception: " + (Object)((Object)e));
                AbstractBAMLogReader.this.handleDataSourceException((Exception)((Object)e));
                AbstractBAMLogReader.this.fatalException = true;
            }
            catch (IllegalArgumentException e) {
                LOG.logWarning("There was a problem reading '" + AbstractBAMLogReader.this.getLogDisplayName() + "' [IA] exception: " + e);
                AbstractBAMLogReader.this.handleDataSourceException(e);
                AbstractBAMLogReader.this.fatalException = true;
            }
            catch (FileNotFoundException e) {
                LOG.logWarning("There was a problem reading '" + AbstractBAMLogReader.this.getLogDisplayName() + "' [FNF] exception: " + e);
                AbstractBAMLogReader.this.handleDataSourceNotFoundException(e);
                AbstractBAMLogReader.this.fatalException = true;
            }
            catch (IOException e) {
                LOG.logWarning("There was a problem reading '" + AbstractBAMLogReader.this.getLogDisplayName() + "' [IO] exception: " + e);
                AbstractBAMLogReader.this.handleDataSourceException(e);
                AbstractBAMLogReader.this.fatalException = true;
            }
            catch (SecurityException e) {
                LOG.logWarning("There was a problem reading '" + AbstractBAMLogReader.this.getLogDisplayName() + "' [S] exception: " + e);
                AbstractBAMLogReader.this.handleDataSourceException(e);
                AbstractBAMLogReader.this.fatalException = true;
            }
            catch (NullPointerException e) {
                LOG.logWarning("There was a problem reading '" + AbstractBAMLogReader.this.getLogDisplayName() + "' [NP] exception: " + e);
                AbstractBAMLogReader.this.handleDataSourceException(e);
                AbstractBAMLogReader.this.fatalException = true;
            }
            catch (Exception e) {
                LOG.logWarning("There was a problem reading '" + AbstractBAMLogReader.this.getLogDisplayName() + "' [Exss] exception: " + e);
                AbstractBAMLogReader.this.handleDataSourceException(e);
                AbstractBAMLogReader.this.fatalException = true;
            }
            if (resultLogRecords == null) {
                LOG.logWarning("No log records could be retrieved due to a problem with the log. The file may not (yet) exist or may be of the wrong format. Refer to the previous warning message for the cause.");
                resultLogRecords = new ArrayList();
            }
            return resultLogRecords;
        }

        ILoggingResultSet getRecords() throws Exception {
            return this.doRead();
        }
    }
}

