/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter.util;

import com.sapmarkets.bam.jmxadapter.util.LogFilesFromProperties;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.SUID;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class MonitorablePaths
extends ArrayList
implements Serializable {
    public static final long serialVersionUID = SUID.getID();
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmxadapter$util$MonitorablePaths == null ? (class$com$sapmarkets$bam$jmxadapter$util$MonitorablePaths = MonitorablePaths.class$("com.sapmarkets.bam.jmxadapter.util.MonitorablePaths")) : class$com$sapmarkets$bam$jmxadapter$util$MonitorablePaths);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmxadapter$util$MonitorablePaths == null ? (class$com$sapmarkets$bam$jmxadapter$util$MonitorablePaths = MonitorablePaths.class$("com.sapmarkets.bam.jmxadapter.util.MonitorablePaths")) : class$com$sapmarkets$bam$jmxadapter$util$MonitorablePaths);
    private List mPathList;
    static final String MONITORABLEPATHKEY = "MonitorablePath";
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$util$MonitorablePaths;

    public MonitorablePaths(Properties serviceProperties) {
        LogFilesFromProperties.setPathSeparator(serviceProperties);
        this.mPathList = new ArrayList();
        Enumeration e = ((Hashtable)serviceProperties).keys();
        if (((Hashtable)serviceProperties).containsKey(MONITORABLEPATHKEY)) {
            String path = serviceProperties.getProperty(MONITORABLEPATHKEY);
            TRACE.traceInfo("MonitorablePaths: Loading path '" + path + "' from property key '" + MONITORABLEPATHKEY + "'");
            if (path != null) {
                StringTokenizer pathTok = new StringTokenizer(path, LogFilesFromProperties.getPathSeparator());
                while (pathTok.hasMoreElements()) {
                    this.addPath((String)pathTok.nextElement());
                }
            } else {
                LOG.logWarning("MonitorablePaths: No paths found under key Logviewer_MonitorablePath");
            }
        } else {
            LOG.logWarning("MonitorablePaths: No paths found (key should be Logviewer_MonitorablePath)");
        }
    }

    private void addPath(String path) {
        TRACE.traceInfo("MonitorablePaths: Added path " + path);
        if (path != null) {
            this.mPathList.add(new PathElement(path));
        }
    }

    public boolean contains(File file) {
        Iterator i = this.mPathList.iterator();
        while (i.hasNext()) {
            if (!((PathElement)i.next()).match(file)) continue;
            return true;
        }
        return false;
    }

    public List getMonitorablePaths() {
        ArrayList<File> result = new ArrayList<File>(this.mPathList.size());
        Iterator i = this.mPathList.iterator();
        while (i.hasNext()) {
            result.add(((PathElement)i.next()).mPath);
        }
        return result;
    }

    public String toString() {
        return this.mPathList.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MonitorablePaths test = (MonitorablePaths)obj;
        return this.mPathList == test.mPathList || this.mPathList != null && this.mPathList.equals(test.mPathList);
    }

    public int hashCode() {
        return this.mPathList.hashCode();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        if (null != fields.getObjectStreamClass().getField("mPathList")) {
            stream.defaultReadObject();
        } else {
            stream.defaultReadObject();
            this.mPathList = new ArrayList(this.size());
            Iterator i = ((AbstractList)this).iterator();
            while (i.hasNext()) {
                this.addPath(i.next().toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PathElement
    implements Serializable {
        private File mPath;
        private boolean mAndBelow;

        PathElement(String path) {
            this.mAndBelow = path.indexOf("...") != -1;
            this.mPath = new File(this.mAndBelow ? path.substring(0, path.length() - 3) : path);
        }

        boolean match(File someFile) {
            try {
                if (someFile == null) {
                    return false;
                }
                TRACE.traceDebug("PathElement matching " + someFile.getCanonicalPath() + " against " + this.toString());
                if (someFile.getCanonicalPath().equals(this.mPath.getCanonicalPath()) || someFile.getParentFile() != null && someFile.getParentFile().equals(this.mPath)) {
                    return true;
                }
                if (this.mAndBelow && someFile.getCanonicalPath().startsWith(this.mPath.getCanonicalPath())) {
                    return true;
                }
            }
            catch (IOException exception) {
                TRACE.traceDebug("IO exception getting canonical path. Directory may not exist" + exception.getMessage());
            }
            return false;
        }

        public String toString() {
            try {
                return this.mPath.getCanonicalPath() + (this.mAndBelow ? "..." : "");
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return "error";
            }
        }
    }
}

