/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter.util;

import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class LogFilesFromProperties {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmxadapter$util$LogFilesFromProperties == null ? (class$com$sapmarkets$bam$jmxadapter$util$LogFilesFromProperties = LogFilesFromProperties.class$("com.sapmarkets.bam.jmxadapter.util.LogFilesFromProperties")) : class$com$sapmarkets$bam$jmxadapter$util$LogFilesFromProperties);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmxadapter$util$LogFilesFromProperties == null ? (class$com$sapmarkets$bam$jmxadapter$util$LogFilesFromProperties = LogFilesFromProperties.class$("com.sapmarkets.bam.jmxadapter.util.LogFilesFromProperties")) : class$com$sapmarkets$bam$jmxadapter$util$LogFilesFromProperties);
    private static String mPathSeparator = null;
    public static final String PATHSEPARATOR_PROPERTYNAME = "PathSeparator";
    private String mPath = null;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$util$LogFilesFromProperties;

    public LogFilesFromProperties(Properties propertiesFromJ2EE, String keyName) {
        if (((Hashtable)propertiesFromJ2EE).containsKey(keyName)) {
            this.mPath = propertiesFromJ2EE.getProperty(keyName);
        } else {
            LOG.logWarning("LogFilesFromProperties: No logs found (key should be Logviewer_" + keyName + ")");
        }
        LogFilesFromProperties.setPathSeparator(propertiesFromJ2EE);
    }

    public static void setPathSeparator(Properties p) {
        if (((Hashtable)p).containsKey(PATHSEPARATOR_PROPERTYNAME)) {
            LogFilesFromProperties.setPathSeparator(p.getProperty(PATHSEPARATOR_PROPERTYNAME));
        } else {
            LogFilesFromProperties.setPathSeparator(System.getProperty("path.separator"));
        }
    }

    public List getLogFiles() {
        ArrayList result = new ArrayList();
        if (this.mPath != null) {
            StringTokenizer pathTok = new StringTokenizer(this.mPath, mPathSeparator);
            while (pathTok.hasMoreElements()) {
                this.addPath(result, new File((String)pathTok.nextElement()));
            }
        } else {
            LOG.logWarning("LogFilesFromProperties: No logs found under path" + this.mPath);
        }
        return result;
    }

    private void addPath(List result, File path) {
        TRACE.traceInfo("LogFilesFromProperties: Adding log path: " + path);
        if (path.toString().indexOf("...") != -1) {
            this.addDirectory(result, new File(path.toString().substring(0, path.toString().length() - 3)), true);
        } else if (path.isDirectory()) {
            this.addDirectory(result, path, false);
        } else {
            result.add(path.toString());
            TRACE.traceInfo("LogFilesFromProperties: Adding file: " + path);
        }
    }

    private void addDirectory(List result, File directory, boolean andSubdirs) {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = files.length - 1;
            while (i >= 0) {
                if (files[i].isDirectory()) {
                    if (andSubdirs) {
                        this.addDirectory(result, files[i], true);
                    }
                } else {
                    result.add(files[i].toString());
                    TRACE.traceInfo("LogFilesFromProperties: Adding file: " + files[i]);
                }
                --i;
            }
        }
    }

    public static String getPathSeparator() {
        return mPathSeparator;
    }

    public static void setPathSeparator(String pathsep) {
        mPathSeparator = pathsep;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

