/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter.util;

import com.sap.jmx.ObjectNameFactory;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewer;
import com.sapmarkets.bam.jmx.connector.LVServer;
import com.sapmarkets.bam.jmx.connector.rmi.IntegratedLVServer;
import com.sapmarkets.bam.jmxadapter.asciilog.impl.FileSelection;
import com.sapmarkets.bam.jmxadapter.sapjlog.AbstractFileLogHandler;
import com.sapmarkets.bam.jmxadapter.util.LogDirectoryMBean;
import com.sapmarkets.bam.jmxadapter.util.MonitorablePaths;
import com.sapmarkets.bam.logcontroller.AbstractBAMLogReader;
import com.sapmarkets.bam.logcontroller.MetaDataOfReader;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LogDirectoryReadingException;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LogDirectory
extends DefaultHandler
implements LogDirectoryMBean {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmxadapter$util$LogDirectory == null ? (class$com$sapmarkets$bam$jmxadapter$util$LogDirectory = LogDirectory.class$("com.sapmarkets.bam.jmxadapter.util.LogDirectory")) : class$com$sapmarkets$bam$jmxadapter$util$LogDirectory);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmxadapter$util$LogDirectory == null ? (class$com$sapmarkets$bam$jmxadapter$util$LogDirectory = LogDirectory.class$("com.sapmarkets.bam.jmxadapter.util.LogDirectory")) : class$com$sapmarkets$bam$jmxadapter$util$LogDirectory);
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    private static Locale userLocale = Locale.getDefault();
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private MBeanServer mMBeanServer;
    private MonitorablePaths mMonitorablePaths = null;
    private List mWriteDirectory = new ArrayList();
    private List mReadAndRegisterDirectory = new ArrayList();
    private List tempDirectory = Collections.synchronizedList(new ArrayList());
    private boolean isNewFile;
    private OutputStreamWriter mWriter;
    private boolean mTurnOffDirectoryWriting;
    private InputStream logDirectoryInputStream;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$util$LogDirectory;

    public LogDirectory(MBeanServer aMBeanServer, Properties propertiesFromJ2EE) {
        this.mMBeanServer = aMBeanServer;
        this.mMonitorablePaths = new MonitorablePaths(propertiesFromJ2EE);
        this.loadWritableDirectory(propertiesFromJ2EE);
        this.openWriteableDirectory(propertiesFromJ2EE);
        this.loadReadableDirectory(propertiesFromJ2EE);
    }

    private void openWriteableDirectory(Properties propertiesFromJ2EE) {
        if (propertiesFromJ2EE.getProperty("LogDirectoryWriteToFile") == null) {
            LOG.logWarning("Logviewer_LogDirectoryWriteToFile property not defined. Log-Directory writing turned OFF");
            this.mTurnOffDirectoryWriting = true;
            return;
        }
        File logDirectoryWriteToFile = new File(propertiesFromJ2EE.getProperty("LogDirectoryWriteToFile"));
        try {
            if (logDirectoryWriteToFile.length() == 0L) {
                this.isNewFile = true;
            }
            this.mWriter = new FileWriter(logDirectoryWriteToFile.getCanonicalPath(), true);
        }
        catch (IOException ioEx) {
            this.mTurnOffDirectoryWriting = true;
            LOG.logWarning("Directory for writing " + logDirectoryWriteToFile + " was not accessible. Directory writing turned OFF. Exception: " + ioEx);
        }
    }

    /*
     * Loose catch block
     */
    private void loadWritableDirectory(Properties propertiesFromJ2EE) {
        block20: {
            File logDirectoryWriteToFile;
            RandomAccessFile raf;
            block19: {
                if (propertiesFromJ2EE.getProperty("LogDirectoryWriteToFile") == null) {
                    TRACE.traceInfo("Logviewer_LogDirectoryWriteToFile property not defined. Can't read writeable directory.");
                    return;
                }
                raf = null;
                logDirectoryWriteToFile = null;
                byte[] logDirectory = null;
                logDirectoryWriteToFile = new File(propertiesFromJ2EE.getProperty("LogDirectoryWriteToFile"));
                raf = new RandomAccessFile(logDirectoryWriteToFile.getAbsolutePath(), "r");
                this.logDirectoryInputStream = new FileInputStream(logDirectoryWriteToFile);
                logDirectory = new byte[(int)raf.length()];
                raf.read(logDirectory);
                String ld = new String(logDirectory);
                ld = LogDirectory.appendTags(ld);
                if (logDirectoryWriteToFile.length() <= 0L) break block19;
                this.mWriteDirectory = this.parse(new ByteArrayInputStream(ld.getBytes()));
            }
            Object var8_7 = null;
            try {
                if (this.logDirectoryInputStream != null) {
                    this.logDirectoryInputStream.close();
                }
                if (raf != null) {
                    raf.close();
                }
                break block20;
            }
            catch (IOException exception12) {
                TRACE.traceInfo("Problems while accessing directory." + exception12);
            }
            break block20;
            {
                catch (FileNotFoundException exception) {
                    TRACE.traceInfo("The 'WriteTo' directory file [" + logDirectoryWriteToFile + "] was not found. ex=" + exception);
                    Object var8_8 = null;
                    try {
                        if (this.logDirectoryInputStream != null) {
                            this.logDirectoryInputStream.close();
                        }
                        if (raf != null) {
                            raf.close();
                        }
                        break block20;
                    }
                    catch (IOException exception12) {
                        TRACE.traceInfo("Problems while accessing directory." + exception12);
                    }
                    break block20;
                }
                catch (IOException exception1) {
                    LOG.logWarning("Problems while accessing directory. ex=" + exception1);
                    Object var8_9 = null;
                    try {
                        if (this.logDirectoryInputStream != null) {
                            this.logDirectoryInputStream.close();
                        }
                        if (raf != null) {
                            raf.close();
                        }
                        break block20;
                    }
                    catch (IOException exception12) {
                        TRACE.traceInfo("Problems while accessing directory." + exception12);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (this.logDirectoryInputStream != null) {
                        this.logDirectoryInputStream.close();
                    }
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException exception12) {
                    TRACE.traceInfo("Problems while accessing directory." + exception12);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void loadReadableDirectory(Properties propertiesFromJ2EE) {
        block15: {
            block16: {
                RandomAccessFile raf;
                block14: {
                    File propFile;
                    String propFilename = propertiesFromJ2EE.getProperty("LogDirectoryReadFromFile");
                    if (propFilename == null || !(propFile = new File(propFilename)).exists()) break block16;
                    raf = null;
                    raf = new RandomAccessFile(propFile.getAbsolutePath(), "r");
                    byte[] logDirectory = null;
                    logDirectory = new byte[(int)raf.length()];
                    raf.read(logDirectory);
                    String ld = new String(logDirectory);
                    ld = LogDirectory.appendTags(ld);
                    if (propFile.length() <= 0L) break block14;
                    this.mReadAndRegisterDirectory = this.parse(new ByteArrayInputStream(ld.getBytes()));
                }
                Object var8_9 = null;
                try {
                    if (raf != null) {
                        raf.close();
                    }
                    break block15;
                }
                catch (IOException exception12) {
                    TRACE.traceInfo("Problems while accessing directory. Directory will be turned OFF " + exception12);
                }
                break block15;
                {
                    catch (FileNotFoundException exception) {
                        TRACE.traceInfo("The directory file was not found. Directory will not be read. Ex=  " + exception);
                        Object var8_10 = null;
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                            break block15;
                        }
                        catch (IOException exception12) {
                            TRACE.traceInfo("Problems while accessing directory. Directory will be turned OFF " + exception12);
                        }
                        break block15;
                    }
                    catch (IOException exception1) {
                        TRACE.traceInfo("Problems while accessing directory. Directory will not be read. Ex= " + exception1);
                        Object var8_11 = null;
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                            break block15;
                        }
                        catch (IOException exception12) {
                            TRACE.traceInfo("Problems while accessing directory. Directory will be turned OFF " + exception12);
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException exception12) {
                        TRACE.traceInfo("Problems while accessing directory. Directory will be turned OFF " + exception12);
                    }
                    throw throwable;
                }
            }
            TRACE.traceInfo("Logviewer_LogDirectoryReadFromFile property not defined. Directory not read.");
        }
    }

    public static String appendTags(String ld) {
        StringBuffer ldBuf = null;
        ldBuf = !ld.startsWith("<logs>") ? new StringBuffer("<logs>" + ld) : new StringBuffer(ld);
        if (!ld.endsWith("</logs>")) {
            ldBuf.append("</logs>");
        }
        return ldBuf.toString();
    }

    private void changeUser(ObjectName objectName, User user) {
        try {
            TRACE.traceInfo("changeUser: " + user.toString());
            this.mMBeanServer.invoke(objectName, "changeUser", new Object[]{new User("Removable")}, new String[]{"com.sapmarkets.bam.application.User"});
        }
        catch (MBeanException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (ReflectionException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (InstanceNotFoundException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
        TRACE.traceInfo("Finished reading the XML document that contains log directories.");
    }

    public void endElement(String nameSpace, String localName, String qName) throws SAXException {
    }

    private IReadableLog getFileLog(MetaDataOfReader reader, String file, String format, int limit, int count) {
        IReadableLog log = null;
        String formatterClassName = null;
        try {
            formatterClassName = (String)reader.getMapOfSupportedFormats().get(format);
            Class<?> formatterClass = Class.forName(formatterClassName);
            Formatter formatter = (Formatter)formatterClass.newInstance();
            FileLog fileLog = count > 0 ? new FileLog(file, limit > 0 ? limit : Integer.MAX_VALUE, count) : new FileLog(file);
            log = AbstractBAMLogReader.createReadableLog(fileLog);
            log.setFormatter(formatter);
        }
        catch (ClassNotFoundException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (IllegalAccessException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), "PROBLEM_INSTANTIATING_CLASS", new Object[]{formatterClassName}, e);
        }
        catch (InstantiationException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        return log;
    }

    private Set getHandlers(String clusterNodeID) {
        ObjectName objectName = null;
        try {
            objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogControllerFacadeMBean", (String)"LogControllerFacade", (String)clusterNodeID, null);
            TRACE.traceInfo("About to get available handlers through LogControllerFacade.  Invoke the method getMetaDataOfReaders on LogControllerFacade through MBeanServer.");
            return (Set)this.mMBeanServer.invoke(objectName, "getAvailableHandlers", new Object[0], new String[0]);
        }
        catch (ReflectionException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (MalformedObjectNameException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (InstanceNotFoundException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (MBeanException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
    }

    private MetaDataOfReader getMetaDataOfReader(String clusterNodeID, String format) {
        ObjectName objectName = null;
        try {
            boolean isReaderNull;
            objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogControllerFacadeMBean", (String)"LogControllerFacade", (String)clusterNodeID, null);
            MetaDataOfReaders readers = (MetaDataOfReaders)this.mMBeanServer.invoke(objectName, "getMetaDataOfReaders", new Object[0], new String[0]);
            MetaDataOfReader reader = readers.getReader(format);
            boolean bl = isReaderNull = reader == null;
            if (isReaderNull) {
                throw new BAMRuntimeException(LOG.getLocation(), new NullPointerException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"META_DATA_OF_READER_IS_NULL", (Object[])new Object[]{format}, (Locale)userLocale, (TimeZone)userTimeZone)));
            }
            return reader;
        }
        catch (LocalizationException e) {
            throw new BAMRuntimeException(LOG.getLocation(), "META_DATA_OF_READER_IS_NULL", new Object[]{format});
        }
        catch (ReflectionException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (MalformedObjectNameException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (InstanceNotFoundException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (MBeanException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
    }

    public List getMonitorableFiles(String query) {
        query = this.insertRightFileSeparator(query);
        List files = new FileSelection(query).getFiles();
        ArrayList<String> result = new ArrayList<String>();
        if (files != null && files.size() > 0) {
            LVServer lvServer = LogViewer.getLVServer();
            int i = 0;
            while (i < files.size()) {
                File file = new File((String)files.get(i));
                if (lvServer.isStandalone()) {
                    if (this.mMonitorablePaths.contains(file.getParentFile())) {
                        result.add(file.toString());
                    }
                } else {
                    result.add(file.toString());
                }
                ++i;
            }
        }
        return result;
    }

    private String insertRightFileSeparator(String source) {
        char fileSeparator = File.separatorChar;
        if (fileSeparator == '\\') {
            return source.replace('/', '\\');
        }
        return source.replace('\\', '/');
    }

    private boolean isFileMonitorable(String fileName) {
        LVServer lvServer = LogViewer.getLVServer();
        while (lvServer == null) {
            try {
                Object[] objectArray = LogViewer.lvServerLock;
                synchronized (objectArray) {
                    LogViewer.lvServerLock.wait();
                    lvServer = LogViewer.getLVServer();
                }
            }
            catch (InterruptedException exception) {
                LOG.logError("exception");
            }
        }
        if (lvServer.isStandalone() && !(lvServer instanceof IntegratedLVServer) && !this.mMonitorablePaths.contains(new File(fileName))) {
            LOG.logWarning("Tried to add '" + fileName + "'. This log does not belong to one of the monitorable paths (" + this.mMonitorablePaths + ")  Please check the properties of the server.");
            return false;
        }
        TRACE.traceDebug("The file '" + fileName + "' is in the monitorable path list.");
        return true;
    }

    public List parse(InputStream aStream) throws LogDirectoryReadingException {
        this.tempDirectory.clear();
        XMLReader reader = null;
        SAXParserFactory saxParserFactory = null;
        SAXParser parser = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            saxParserFactory = SAXParserFactory.newInstance();
            parser = saxParserFactory.newSAXParser();
            Thread.currentThread().setContextClassLoader(cl);
            reader = parser.getXMLReader();
            reader.setContentHandler(this);
            InputSource source = new InputSource(aStream);
            reader.parse(source);
        }
        catch (IOException ioe) {
            LOG.logError("Could not read LogDirectory [" + ioe.getMessage() + "]");
            throw new LogDirectoryReadingException(LOG.getLocation(), "EXCEPTION_CAUGHT", new Object[]{"IOException", aStream}, ioe);
        }
        catch (ParserConfigurationException pce) {
            LOG.logError("Could not read LogDirectory [" + pce.getMessage() + "]");
            LOG.logException(pce);
            throw new LogDirectoryReadingException(LOG.getLocation(), "EXCEPTION_CAUGHT", new Object[]{"ParserConfigurationException", aStream}, pce);
        }
        catch (SAXException se) {
            TRACE.traceInfo("XML parsing hit exception: " + se.getMessage() + ". Ignoring - probably missing </logs> tag.");
        }
        TRACE.traceInfo("Log Directory read " + this.tempDirectory.size() + " logs.");
        TRACE.traceDebug("Log Directory read " + this.tempDirectory.size() + " logs. Contents: " + this.tempDirectory.toString());
        return new ArrayList(this.tempDirectory);
    }

    public List registerLogsFromLogDirectory(User user, Boolean fromLogging) {
        return this.registerLogsFromLogDirectory(this.mReadAndRegisterDirectory, null, user, fromLogging);
    }

    public List parseAndRegisterLogsFromLogDirectory(String logDirectory, String clusterNodeID, User user) {
        TRACE.traceDebug("registerLogsFromLogDirectory: " + logDirectory + " clusternodeID=" + clusterNodeID);
        if (logDirectory != null) {
            return this.registerLogsFromLogDirectory(this.parse(new ByteArrayInputStream(logDirectory.getBytes())), clusterNodeID, user, false);
        }
        return new ArrayList();
    }

    private List registerLogsFromLogDirectory(List logDirectory, String clusterNodeID, User user, boolean fromLogDirectory) {
        ArrayList<LogRegistrationResult> lst = new ArrayList<LogRegistrationResult>();
        List list = logDirectory;
        synchronized (list) {
            int i = logDirectory.size() - 1;
            while (i >= 0) {
                int limit;
                int count;
                String archiveDirectory;
                String formatType;
                String pattern;
                block13: {
                    String s;
                    Map map;
                    block12: {
                        map = (Map)logDirectory.get(i);
                        pattern = (String)map.get("pattern");
                        formatType = (String)map.get("formattype");
                        archiveDirectory = (String)map.get("archivedirectory");
                        count = -1;
                        limit = -1;
                        try {
                            s = (String)map.get("filelimit");
                            if (s != null) {
                                limit = Integer.parseInt(s);
                            }
                        }
                        catch (NumberFormatException e) {
                            if (limit != -1) break block12;
                            limit = 0;
                        }
                    }
                    try {
                        s = (String)map.get("filecount");
                        count = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        if (count != -1) break block13;
                        count = 0;
                    }
                }
                if (pattern != null && formatType != null && archiveDirectory == null) {
                    TRACE.traceInfo("LogDirectory registering: " + pattern + " format=" + formatType + " clusterNodeID=" + clusterNodeID);
                    LogRegistrationResult result = this.registerToMonitor(pattern, formatType, limit, count, clusterNodeID, user, fromLogDirectory);
                    if (result != null) {
                        lst.add(result);
                    }
                } else {
                    TRACE.traceInfo("LogDirectory NOT registering (null pattern or format): " + pattern + " format=" + formatType + " clusterNodeID=" + clusterNodeID);
                }
                --i;
            }
        }
        return lst;
    }

    public String getFormatterType(String logFileName) {
        IReadableLog readableLog = AbstractBAMLogReader.createReadableLog(new FileLog(logFileName));
        if (readableLog.getHeader() != null && !readableLog.getHeader().equals("")) {
            String formatType = readableLog.getFormatter().getFormatterType().toString();
            TRACE.traceInfo("The format for the log file " + logFileName + "was= " + formatType);
            return formatType;
        }
        TRACE.traceInfo("The format for the log file " + logFileName + "was= " + FormatterType.UNDEFINEDFORMAT.toString() + " Since the header was not defined");
        return FormatterType.UNDEFINEDFORMAT.toString();
    }

    private LogRegistrationResult register(IReadableLog log, String clusterNodeID, boolean fromLogDirectory) {
        LogRegistrationResult result = null;
        Iterator iterator = this.getHandlers(clusterNodeID).iterator();
        while (iterator.hasNext()) {
            result = ((AbstractFileLogHandler)iterator.next()).registerLogMBean(log, fromLogDirectory, LogTypeEnumeration.LVLOG_TYPE);
            if (result.getStatus() != 2) break;
        }
        return result;
    }

    public LogRegistrationResult registerToMonitor(String file, String format, String clusterNodeID, User user) {
        return this.registerToMonitor(file, format, 0, 0, clusterNodeID, user);
    }

    public LogRegistrationResult registerToMonitor(String file, String format, int limit, int count, String clusterNodeID, User user) {
        return this.registerToMonitor(file, format, limit, count, clusterNodeID, user, false);
    }

    public LogRegistrationResult registerToMonitor(String file, String format, int limit, int count, String clusterNodeID, User user, boolean fromLogDirectory) {
        if (this.isFileMonitorable(file = this.insertRightFileSeparator(file))) {
            IReadableLog log = null;
            LogRegistrationResult result = null;
            MetaDataOfReader reader = null;
            try {
                reader = this.getMetaDataOfReader(clusterNodeID, format);
            }
            catch (IllegalArgumentException ex) {
                try {
                    result = new LogRegistrationResult(null, -1, file, format);
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                return result;
            }
            log = this.getFileLog(reader, file, format, limit, count);
            result = this.register(log, clusterNodeID, fromLogDirectory);
            ObjectName objectName = result.getObjectName();
            if (objectName != null && result.getStatus() == 0) {
                this.changeUser(objectName, user);
            }
            return result;
        }
        return new LogRegistrationResult(null, 3, file, format);
    }

    public List getMonitorablePaths() {
        return this.mMonitorablePaths.getMonitorablePaths();
    }

    public Set getArchiveDirectories(String logPattern) {
        HashSet<String[]> archiveDirectories = new HashSet<String[]>();
        Iterator itr = this.mReadAndRegisterDirectory.iterator();
        while (itr.hasNext()) {
            Map logEntry = (Map)itr.next();
            String thisLogPattern = (String)logEntry.get("pattern");
            String archiveDirectory = (String)logEntry.get("archivedirectory");
            String j2eeDirectory = (String)logEntry.get("j2eedirectory");
            try {
                String canonicalLogPattern = new File(logPattern).getCanonicalPath();
                String thisCanonicalLogPattern = new File(j2eeDirectory != null ? j2eeDirectory + File.separatorChar + thisLogPattern : thisLogPattern).getCanonicalPath();
                if (!canonicalLogPattern.equals(thisCanonicalLogPattern) || archiveDirectory == null) continue;
                archiveDirectories.add(new String[]{archiveDirectory, thisLogPattern});
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return archiveDirectories;
    }

    public void write(String pattern, String logFormat, Integer limit, Integer count, String archiveDirectory, ObjectName logObjectName) {
        if (this.mTurnOffDirectoryWriting) {
            return;
        }
        LogAttributeHashMap logEntry = new LogAttributeHashMap();
        logEntry.put("formattype", logFormat);
        String patternPath = pattern;
        if (archiveDirectory == null) {
            patternPath = new File(pattern).getAbsolutePath();
        }
        logEntry.put("pattern", patternPath);
        logEntry.put("filelimit", limit);
        logEntry.put("filecount", count);
        logEntry.put("archivedirectory", archiveDirectory);
        String j2eeDirectory = archiveDirectory == null ? null : System.getProperty("com.sap.jvmdir");
        logEntry.put("j2eedirectory", j2eeDirectory);
        TRACE.traceInfo("Writing LogDirectory entry: pattern=[" + pattern + "] filelimit=[" + limit + "] count=[" + count + "] archivedirectory=[" + archiveDirectory + "] j2eedirectory=[" + j2eeDirectory + "]");
        if (!this.mWriteDirectory.contains(logEntry)) {
            this.mWriteDirectory.add(logEntry);
            try {
                if (this.isNewFile) {
                    String startTag = "<logs> \n";
                    this.mWriter.write(startTag);
                    this.isNewFile = false;
                }
                LogDirectory.writeOneLogDirectoryEntry(this.mWriter, patternPath, logFormat, limit, count, archiveDirectory, j2eeDirectory, logObjectName);
                this.mWriter.flush();
            }
            catch (IOException ioEx) {
                LOG.logError("Error writing log directory entry" + ioEx.getMessage());
                throw new BAMRuntimeException(LOG.getLocation(), "Error while writing to directory.");
            }
        }
    }

    public static void writeOneLogDirectoryEntry(OutputStreamWriter writer, String pattern, String logFormat, Integer limit, Integer count, String archiveDirectory, String j2eeDirectory, ObjectName logObjectName) throws IOException {
        String outData = "<log pattern= \"" + pattern + "\"" + " formattype= \"" + logFormat + "\"" + (limit > 0 ? " filelimit= \"" + limit + "\"" : "") + " filecount= \"" + count + "\"" + (archiveDirectory == null ? "" : " archivedirectory= \"" + archiveDirectory + "\"") + (j2eeDirectory == null ? "" : " j2eedirectory= \"" + j2eeDirectory + "\"") + " objectName= \"" + URLEncoder.encode(logObjectName.toString()) + "\"" + "/> \n";
        TRACE.traceInfo("Wrote LogDirectory entry:" + outData);
        writer.write(outData);
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String nameSpace, String localName, String qName, Attributes attributes) throws SAXException {
        if (!"log".equalsIgnoreCase(localName)) {
            return;
        }
        LogAttributeHashMap map = new LogAttributeHashMap();
        int i = 0;
        while (i < attributes.getLength()) {
            map.put(attributes.getLocalName(i).toLowerCase(), attributes.getValue(i));
            ++i;
        }
        this.tempDirectory.add(map);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class LogAttributeHashMap
    extends HashMap {
        public boolean equals(Object obj1, Object obj2) {
            return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map other = (Map)o;
            String thisPattern = (String)this.get("pattern");
            String thisFormatType = (String)this.get("formattype");
            String thisArchiveDirectory = (String)this.get("archivedirectory");
            String otherPattern = (String)other.get("pattern");
            String otherFormatType = (String)other.get("formattype");
            String otherArchiveDirectory = (String)other.get("archivedirectory");
            return this.equals(thisPattern, otherPattern) && this.equals(thisFormatType, otherFormatType) && this.equals(thisArchiveDirectory, otherArchiveDirectory);
        }

        public int hashCode() {
            int result = 153;
            String thisPattern = (String)this.get("pattern");
            String thisFormatType = (String)this.get("formattype");
            String thisArchiveDirectory = (String)this.get("archivedirectory");
            if (thisPattern != null) {
                result += 7 * thisPattern.hashCode();
            }
            if (thisFormatType != null) {
                result += 11 * thisFormatType.hashCode();
            }
            if (thisArchiveDirectory != null) {
                result += 13 * thisArchiveDirectory.hashCode();
            }
            return result;
        }
    }
}

