/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter.sapjlog;

import com.sap.tc.logging.EventDispatcher;
import com.sap.tc.logging.EventDispatcherFactory;
import com.sap.tc.logging.EventListener;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sap.tc.logging.reader.ReadableLog;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.jmxadapter.LogTypeConfigurator;
import com.sapmarkets.bam.jmxadapter.asciilog.impl.ASCIILogFileProperties;
import com.sapmarkets.bam.jmxadapter.sapjlog.ASCIILogHandler;
import com.sapmarkets.bam.jmxadapter.sapjlog.LogListener;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;

public class LogTypeConfiguratorImpl
implements LogTypeConfigurator {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmxadapter$sapjlog$LogTypeConfiguratorImpl == null ? (class$com$sapmarkets$bam$jmxadapter$sapjlog$LogTypeConfiguratorImpl = LogTypeConfiguratorImpl.class$("com.sapmarkets.bam.jmxadapter.sapjlog.LogTypeConfiguratorImpl")) : class$com$sapmarkets$bam$jmxadapter$sapjlog$LogTypeConfiguratorImpl);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmxadapter$sapjlog$LogTypeConfiguratorImpl == null ? (class$com$sapmarkets$bam$jmxadapter$sapjlog$LogTypeConfiguratorImpl = LogTypeConfiguratorImpl.class$("com.sapmarkets.bam.jmxadapter.sapjlog.LogTypeConfiguratorImpl")) : class$com$sapmarkets$bam$jmxadapter$sapjlog$LogTypeConfiguratorImpl);
    private static Set readers = new HashSet();
    private Set handlers = new HashSet();
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$sapjlog$LogTypeConfiguratorImpl;

    public Set getHandlers() {
        return this.handlers;
    }

    public Set configure(Properties props, MBeanServer mbeanServer, Properties propertiesFromJ2EE) {
        Iterator iter = ((Hashtable)props).keySet().iterator();
        EventDispatcher evtDispatcher = EventDispatcherFactory.getEventDispatcher();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("sapjlog.handler")) continue;
            String logHandlerName = (String)((Hashtable)props).get(key);
            try {
                Class<?> clazz = Class.forName(logHandlerName);
                LogListener logHandler = (LogListener)clazz.newInstance();
                Set readerMetaData = logHandler.configure(props, mbeanServer, propertiesFromJ2EE);
                if (readerMetaData != null && readerMetaData.size() > 0) {
                    readers.addAll(readerMetaData);
                }
                evtDispatcher.addListener((EventListener)logHandler);
                this.handlers.add(logHandler);
                LogTypeConfigurator.socketLogRegistrationDispatcher.addLoglistener(logHandler);
            }
            catch (ClassNotFoundException ex) {
                throw new BAMRuntimeException(LOG.getLocation(), "Unable to configure handler: " + logHandlerName, ex);
            }
            catch (InstantiationException ex) {
                throw new BAMRuntimeException(LOG.getLocation(), "Unable to configure handler: " + logHandlerName, ex);
            }
            catch (IllegalAccessException ex) {
                throw new BAMRuntimeException(LOG.getLocation(), "Unable to configure handler: " + logHandlerName, ex);
            }
        }
        this.registerASCIILogs(propertiesFromJ2EE);
        return readers;
    }

    public void registerASCIILogs(Properties propertiesFromJ2EE) {
        ASCIILogFileProperties props = new ASCIILogFileProperties(propertiesFromJ2EE);
        List logFiles = props.getASCIILogFiles();
        if (logFiles.isEmpty()) {
            return;
        }
        ASCIILogHandler alh = null;
        Iterator e = this.handlers.iterator();
        while (e.hasNext()) {
            LogListener listener = (LogListener)e.next();
            if (!(listener instanceof ASCIILogHandler)) continue;
            alh = (ASCIILogHandler)listener;
            break;
        }
        TRACE.traceInfo("Registering ASCII logs: " + logFiles.toString());
        if (alh != null) {
            Iterator iter = logFiles.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                TRACE.traceDebug("ASCII path registering: log " + fileName);
                ReadableLog fileLog = new ReadableLog(fileName);
                fileLog.setFormatter((Formatter)new TraceFormatter());
                LogRegistrationResult result = alh.registerLogMBean((IReadableLog)fileLog);
                TRACE.traceDebug("ASCII path registration result: " + result.toString());
            }
        } else {
            LOG.logWarning("No handler found to register ASCII-type logs: " + logFiles.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

