/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter.sapjlog;

import com.sap.engine.services.jmx.exception.JmxSecurityException;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import com.sap.jmx.ObjectNameFactory;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.NewLogEvent;
import com.sap.tc.logging.ReleaseLogEvent;
import com.sap.tc.logging.RemoveLogEvent;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewer;
import com.sapmarkets.bam.jmx.connector.J2EELVServer;
import com.sapmarkets.bam.jmx.connector.LVServer;
import com.sapmarkets.bam.jmxadapter.AbstractLogMBean;
import com.sapmarkets.bam.jmxadapter.ArchiveInfo;
import com.sapmarkets.bam.jmxadapter.ArchiveLogMBean;
import com.sapmarkets.bam.jmxadapter.sapjlog.LogListener;
import com.sapmarkets.bam.jmxadapter.util.JMXMBeanHelper;
import com.sapmarkets.bam.jmxadapter.util.LogDirectory;
import com.sapmarkets.bam.logcontroller.AbstractBAMLogReader;
import com.sapmarkets.bam.logcontroller.MetaDataOfReader;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class AbstractFileLogHandler
implements LogListener {
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmxadapter$sapjlog$AbstractFileLogHandler == null ? (class$com$sapmarkets$bam$jmxadapter$sapjlog$AbstractFileLogHandler = AbstractFileLogHandler.class$("com.sapmarkets.bam.jmxadapter.sapjlog.AbstractFileLogHandler")) : class$com$sapmarkets$bam$jmxadapter$sapjlog$AbstractFileLogHandler);
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmxadapter$sapjlog$AbstractFileLogHandler == null ? (class$com$sapmarkets$bam$jmxadapter$sapjlog$AbstractFileLogHandler = AbstractFileLogHandler.class$("com.sapmarkets.bam.jmxadapter.sapjlog.AbstractFileLogHandler")) : class$com$sapmarkets$bam$jmxadapter$sapjlog$AbstractFileLogHandler);
    protected MBeanServer mbeanServer;
    protected static Properties propertiesFromJ2EE;
    protected String supportedFormatID;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$sapjlog$AbstractFileLogHandler;

    public Set configure(Properties props, MBeanServer theMBeanServer, Properties thePropertiesFromJ2EE) {
        this.mbeanServer = theMBeanServer;
        propertiesFromJ2EE = thePropertiesFromJ2EE;
        MetaDataOfReader reader = this.getMetaDataOfReader();
        TRACE.traceInfo("Configuring reader " + (reader != null ? reader.getReaderDescription() + " " + reader.getReaderClassName() : "(null)"));
        HashSet<MetaDataOfReader> result = new HashSet<MetaDataOfReader>();
        result.add(reader);
        return result;
    }

    public LogRegistrationResult registerLogMBean(IReadableLog log) {
        return this.registerLogMBean(log, true, LogTypeEnumeration.LVLOG_TYPE);
    }

    public LogRegistrationResult registerArchiveLogMBean(IReadableLog log, ArchiveInfo archiveInfo) {
        return this.registerArchiveLogMBean(log, true, LogTypeEnumeration.LVLOG_TYPE, archiveInfo);
    }

    public abstract boolean checkFormatterType(FormatterType var1);

    public abstract AbstractLogMBean createMBean(IReadableLog var1);

    public ArchiveLogMBean createArchiveMBean(IReadableLog log, ArchiveInfo archiveInfo) {
        throw new UnsupportedOperationException("No archive support for this log: " + log.getFileName());
    }

    public LogRegistrationResult registerLogMBean(IReadableLog log, boolean logFromLogging, LogTypeEnumeration logType) {
        LogRegistrationResult result = null;
        boolean isCorrectFormatter = this.checkFormatterType(log.getFormatter().getFormatterType());
        if (log.getFormatter().isParsable() && isCorrectFormatter) {
            AbstractLogMBean logMBean = this.createMBean(log);
            result = this.registerLogAsMBean(log, logMBean, logType);
        } else {
            result = new LogRegistrationResult(null, 2, log.getPattern(), log.getFormatter().getFormatterType().toString());
        }
        return result;
    }

    public LogRegistrationResult registerArchiveLogMBean(IReadableLog log, boolean logFromLogging, LogTypeEnumeration logType, ArchiveInfo archiveInfo) {
        LogRegistrationResult result = null;
        boolean isCorrectFormatter = this.checkFormatterType(log.getFormatter().getFormatterType());
        if (log.getFormatter().isParsable() && isCorrectFormatter) {
            ArchiveLogMBean logMBean = this.createArchiveMBean(log, archiveInfo);
            result = this.registerLogAsMBean(log, logMBean, logType);
        } else {
            result = new LogRegistrationResult(null, 2, log.getPattern(), log.getFormatter().getFormatterType().toString());
        }
        return result;
    }

    public LogRegistrationResult registerLogAsMBean(IReadableLog log, final AbstractLogMBean logMBean, LogTypeEnumeration logType) {
        String displayName = log.getName() == null ? log.getPattern() : log.getName();
        String logName = log.getPattern();
        ObjectName objectName = null;
        try {
            objectName = ObjectNameFactory.getNameForServerChildPerNode((String)logType.toString(), (String)JMXMBeanHelper.validateObjectName(logName), null, null);
            if (!this.mbeanServer.isRegistered(objectName)) {
                TRACE.traceInfo("Registering Log:[" + displayName + "] with Formatter: [" + log.getFormatter().getFormatterType().toString() + "]" + "ObjectName: " + objectName);
                final ObjectName objName = objectName;
                PrivilegedExceptionAction privAct = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return AbstractFileLogHandler.this.mbeanServer.registerMBean(logMBean, objName).getObjectName();
                    }
                };
                objectName = (ObjectName)AccessController.doPrivileged(privAct);
                if (logType != LogTypeEnumeration.ARCHIVE_TYPE) {
                    this.addToDirectory(log.getPattern(), log.getLimit(), log.getCnt(), null, objectName);
                }
                TRACE.traceInfo("Registered Log:[" + log.getPattern() + "] with Formatter: [" + log.getFormatter().getFormatterType().toString() + "]" + "ObjectName: " + objectName);
                return new LogRegistrationResult(objectName, 0, log.getPattern(), log.getFormatter().getFormatterType().toString());
            }
            final ObjectName objName = objectName;
            PrivilegedExceptionAction privAct = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AbstractFileLogHandler.this.mbeanServer.getObjectInstance(objName).getObjectName();
                }
            };
            objectName = (ObjectName)AccessController.doPrivileged(privAct);
            return new LogRegistrationResult(objectName, 1, log.getPattern(), log.getFormatter().getFormatterType().toString());
        }
        catch (MalformedObjectNameException e) {
            LOG.logException(e);
            LogRegistrationResult result = new LogRegistrationResult(objectName, -1, log.getPattern(), log.getFormatter().getFormatterType().toString());
            result.addException(e);
            return result;
        }
        catch (JmxSecurityException ex) {
            LOG.logException(ex);
            LogRegistrationResult result = new LogRegistrationResult(objectName, -1, log.getPattern(), log.getFormatter().getFormatterType().toString());
            result.addException(ex);
            return result;
        }
        catch (SecurityException ex) {
            LOG.logException(ex);
            LogRegistrationResult result = new LogRegistrationResult(objectName, -1, log.getPattern(), log.getFormatter().getFormatterType().toString());
            result.addException(ex);
            return result;
        }
        catch (PrivilegedActionException ex) {
            LOG.logException(ex);
            LogRegistrationResult result = new LogRegistrationResult(objectName, -1, log.getPattern(), log.getFormatter().getFormatterType().toString());
            result.addException(ex);
            return result;
        }
    }

    public Set getArchiveDirectories(String logPattern) {
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogDirectoryMBean", (String)"LogDirectory", null, null);
            return (Set)this.mbeanServer.invoke(objectName, "getArchiveDirectories", new Object[]{logPattern}, new String[]{"java.lang.String"});
        }
        catch (MalformedObjectNameException ex) {
            LOG.logException(ex);
            throw new BAMRuntimeException(LOG.getLocation(), ex);
        }
        catch (ReflectionException e) {
            TRACE.traceInfo("While obtaining archive directories through MBeanServer, reflection exception is caught.");
            TRACE.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (InstanceNotFoundException e) {
            TRACE.traceInfo("While obtaining archive directories through MBeanServer, instance not found exception is caught. It implies that LogDirectoryMBean is not registered.");
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
        catch (MBeanException e) {
            TRACE.traceInfo("While obtaining archive directories through MBeanServer, MBean exception is caught.");
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), e);
        }
    }

    private void addToDirectory(String pattern, int limit, int count, String archiveDirectory, ObjectName logObjectName) {
        LVServer lvServer = LogViewer.getLVServer();
        LogDirectory logDirectory = LogViewer.getLVServer().getLogDirectory();
        logDirectory.write(pattern, this.supportedFormatID, new Integer(limit), new Integer(count), archiveDirectory, logObjectName);
    }

    public LogRegistrationResult registerLogMBean(NewLogEvent event) {
        if (event == null) {
            try {
                throw new IllegalArgumentException(LocalizableTextFormatter.formatString((ResourceAccessor)LogViewerResourceAccessor.getInstance(), (String)"LOG_EVENT_CANNOT_BE_NULL", null, (Locale)Locale.getDefault(), (TimeZone)TimeZone.getDefault()));
            }
            catch (LocalizationException le) {
                throw new IllegalArgumentException("LogEvent cannot be null (registerSAPJLogMBean).");
            }
        }
        Log log = event.getNewLog();
        if (log instanceof FileLog) {
            IReadableLog readableLog = AbstractBAMLogReader.createReadableLog((FileLog)log);
            return this.registerLogMBean(readableLog);
        }
        TRACE.traceInfo("Cannot register log name '" + log.getName() + "' desc= '" + log.getDescription() + "' [no ReadableLog interface]. Log will not be registered!");
        return new LogRegistrationResult(null, -1, null, null);
    }

    public void handleEvent(ReleaseLogEvent event) {
        try {
            FileLog fl = event.getFileLog();
            TRACE.traceDebug("Received ReleaseLogEvent for FileLog " + fl.getName() + "; Type: " + fl.getFormatter().getFormatterType());
            if (!this.checkFormatterType(fl.getFormatter().getFormatterType())) {
                return;
            }
            TRACE.traceInfo("Matched type: " + fl.getFormatter().getFormatterType());
            AbstractBAMLogReader.closeReadableLog(fl);
            LVServer lvServer = LogViewer.getLVServer();
            if (!(lvServer instanceof J2EELVServer)) {
                return;
            }
            LogConfigurator lc = (LogConfigurator)((J2EELVServer)lvServer).getLogConfigurator();
            String archiveDirectory = lc.getArchiveLogDirectory();
            TRACE.traceInfo("Archive Log Directory: " + archiveDirectory);
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)LogTypeEnumeration.LVLOG_TYPE.toString(), (String)JMXMBeanHelper.validateObjectName(fl.getPattern()), null, null);
            this.addToDirectory(fl.getPattern(), fl.getLimit(), fl.getCnt(), archiveDirectory, objectName);
        }
        catch (Throwable ex) {
            LOG.logOriginalException(ex);
        }
    }

    public void handleEvent(NewLogEvent event) {
        try {
            this.registerLogMBean(event);
        }
        catch (JmxSecurityException ex) {
            LOG.logOriginalException((Throwable)((Object)new BAMRuntimeException(LOG.getLocation(), "JMX_SECURITY_VIOLATION", ex)));
        }
        catch (Throwable ex) {
            LOG.logOriginalException((Throwable)((Object)new BAMRuntimeException(LOG.getLocation(), "UNABLE_TO_REGISTER_NEW_LOG", ex)));
        }
    }

    public void unRegisterLogMBean(RemoveLogEvent event) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, InstanceNotFoundException {
        Log log = event.getRemoveLog();
        if (!(log instanceof FileLog)) {
            return;
        }
        String logName = JMXMBeanHelper.validateObjectName(((FileLog)log).getPattern());
        ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)LogTypeEnumeration.LVLOG_TYPE.toString(), (String)logName, null, null);
        if (this.mbeanServer.isRegistered(objectName)) {
            this.mbeanServer.unregisterMBean(objectName);
        }
        TRACE.traceInfo("Unregistered MBean " + logName);
    }

    public void handleEvent(RemoveLogEvent event) {
        Log log = event.getRemoveLog();
        if (!(log instanceof FileLog)) {
            return;
        }
        FileLog fl = (FileLog)log;
        AbstractBAMLogReader.closeReadableLog(fl);
        try {
            this.unRegisterLogMBean(event);
        }
        catch (JmxSecurityException ex) {
            LOG.logOriginalException((Throwable)((Object)new BAMRuntimeException(LOG.getLocation(), "JMX_SECURITY_VIOLATION", ex)));
        }
        catch (Throwable ex) {
            LOG.logOriginalException((Throwable)((Object)new BAMRuntimeException(LOG.getLocation(), "UNABLE_TO_UNREGISTER_LOG", ex)));
        }
    }

    protected abstract MetaDataOfReader getMetaDataOfReader();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

