/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter.asciilog.impl;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class FileSelection {
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private static Locale userLocale = Locale.getDefault();
    private Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmxadapter$asciilog$impl$FileSelection == null ? (class$com$sapmarkets$bam$jmxadapter$asciilog$impl$FileSelection = FileSelection.class$("com.sapmarkets.bam.jmxadapter.asciilog.impl.FileSelection")) : class$com$sapmarkets$bam$jmxadapter$asciilog$impl$FileSelection);
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    private List directories = new ArrayList();
    private List files = new ArrayList();
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$asciilog$impl$FileSelection;

    public FileSelection(String query) {
        query.replace('\\', File.separatorChar);
        query.replace('/', File.separatorChar);
        StringTokenizerWithDelimiters st = new StringTokenizerWithDelimiters(query, File.separator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf("...") >= 0) {
                if (st.hasMoreTokens()) {
                    String token2 = st.nextToken();
                    this.replaceEllipsesAndStore(token2);
                    continue;
                }
                this.replaceEllipsesAndStore();
                continue;
            }
            if (token.indexOf("*") >= 0) {
                this.replaceStarsAndStore(token);
                continue;
            }
            this.store(token);
        }
    }

    public List getFiles() {
        return this.files;
    }

    private void replaceEllipsesAndStore() {
        ArrayList temp = new ArrayList();
        if (this.directories != null && this.directories.size() > 0) {
            int i = 0;
            while (i < this.directories.size()) {
                File file = new File((String)this.directories.get(i));
                List l = this.getSubdirectoriesAndFiles(file);
                if (l != null && l.size() > 0) {
                    temp.addAll(l);
                }
                ++i;
            }
        }
        this.sortFilesAndDirectories(temp);
    }

    private List getSubdirectoriesAndFiles(File file) {
        File[] possibleDirectories;
        ArrayList<String> temp = new ArrayList<String>();
        File[] possibleFiles = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return new File(file, name).isFile();
            }
        });
        if (possibleFiles != null && possibleFiles.length > 0) {
            int i = 0;
            while (i < possibleFiles.length) {
                temp.add(possibleFiles[i].toString());
                ++i;
            }
        }
        if ((possibleDirectories = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return new File(file, name).isDirectory();
            }
        })) != null && possibleDirectories.length > 0) {
            int j = 0;
            while (j < possibleDirectories.length) {
                List l = this.getSubdirectoriesAndFiles(possibleDirectories[j]);
                if (l != null && l.size() > 0) {
                    temp.addAll(l);
                }
                ++j;
            }
        }
        return temp;
    }

    private void replaceEllipsesAndStore(String nextToken) {
        ArrayList temp = new ArrayList();
        int i = 0;
        while (i < this.directories.size()) {
            File file = new File((String)this.directories.get(i));
            File[] subDirectories = file.listFiles();
            if (subDirectories != null && subDirectories.length > 0) {
                int j = 0;
                while (j < subDirectories.length) {
                    List l;
                    if (subDirectories[j].isDirectory() && (l = this.getSubdirectoriesAndFiles(subDirectories[j], nextToken)) != null && l.size() > 0) {
                        temp.addAll(l);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.sortFilesAndDirectories(temp);
    }

    private List getSubdirectoriesAndFiles(File file, String token) {
        ArrayList<String> temp = new ArrayList<String>();
        if (this.match(file, token)) {
            temp.add(file.toString());
            return temp;
        }
        File[] possibleDirectories = file.listFiles();
        if (possibleDirectories != null && possibleDirectories.length > 0) {
            int j = 0;
            while (j < possibleDirectories.length) {
                List l;
                if (this.match(possibleDirectories[j], token)) {
                    temp = new ArrayList();
                    temp.add(possibleDirectories[j].toString());
                    return temp;
                }
                if (possibleDirectories[j].isDirectory() && (l = this.getSubdirectoriesAndFiles(possibleDirectories[j], token)) != null && l.size() > 0) {
                    temp.addAll(l);
                }
                ++j;
            }
        }
        return temp;
    }

    private boolean match(File file, String token) {
        String fullName = file.toString();
        String fileName = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1);
        return this.isPossible(fileName, token);
    }

    private void replaceStarsAndStore(String token) {
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i < this.directories.size()) {
            File file = new File((String)this.directories.get(i));
            File[] possibleDirectories = file.listFiles();
            if (possibleDirectories != null && possibleDirectories.length > 0) {
                int j = 0;
                while (j < possibleDirectories.length) {
                    String fullName = possibleDirectories[j].toString().substring(possibleDirectories[j].toString().lastIndexOf(File.separatorChar) + 1);
                    if (token.endsWith(File.separator)) {
                        token = token.substring(0, token.length() - 1);
                    }
                    if (this.isPossible(fullName, token)) {
                        temp.add(possibleDirectories[j].toString());
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.sortFilesAndDirectories(temp);
    }

    private boolean isPossible(String fullName, String partialName) {
        int k = -1;
        boolean isStarAtTheBeginning = false;
        int j = 0;
        while (j < partialName.length()) {
            if (partialName.charAt(j) == '*') {
                isStarAtTheBeginning = true;
                if (partialName.length() - 1 == j) {
                    return true;
                }
            } else {
                int i = k + 1;
                while (i < fullName.length()) {
                    if (!isStarAtTheBeginning || fullName.charAt(i) == partialName.charAt(j)) {
                        k = i;
                        isStarAtTheBeginning = false;
                        if (isStarAtTheBeginning || fullName.charAt(i) == partialName.charAt(j)) break;
                        return false;
                    }
                    ++i;
                }
                if (isStarAtTheBeginning && j < partialName.length()) {
                    return false;
                }
            }
            ++j;
        }
        return true;
    }

    private void store(String token) {
        ArrayList<String> temp = new ArrayList<String>();
        if (!this.directories.isEmpty()) {
            int i = 0;
            while (i < this.directories.size()) {
                File file = new File((String)this.directories.get(i), token);
                if (file.isDirectory() || file.isFile()) {
                    temp.add(file.toString());
                }
                ++i;
            }
        } else {
            File file = new File(token);
            if (file.exists()) {
                temp.add(file.toString());
            }
        }
        this.sortFilesAndDirectories(temp);
    }

    private void sortFilesAndDirectories(List mix) {
        this.files.clear();
        this.directories.clear();
        Iterator iter = mix.iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            File file = new File(fileName);
            if (file.isDirectory()) {
                this.directories.add(fileName);
                continue;
            }
            this.files.add(fileName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StringTokenizerWithDelimiters {
        private StringTokenizer st;

        public StringTokenizerWithDelimiters(String source, String delimiter) {
            this.st = new StringTokenizer(source, delimiter, true);
        }

        public boolean hasMoreTokens() {
            return this.st.hasMoreTokens();
        }

        public String nextToken() {
            if (this.st.hasMoreTokens()) {
                String result = this.st.nextToken();
                if (!result.endsWith(File.separator) && this.st.hasMoreTokens()) {
                    String limit = this.st.nextToken();
                    result = result + limit;
                }
                return result;
            }
            try {
                throw new NoSuchElementException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"NO_MORE_ELEMENTS_IN_SOURCE_STRING", null, (Locale)userLocale, (TimeZone)userTimeZone));
            }
            catch (LocalizationException le) {
                throw new NoSuchElementException("No more elements in the source string!");
            }
        }
    }
}

