/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewer;
import com.sapmarkets.bam.jmx.connector.J2EELVServer;
import com.sapmarkets.bam.jmx.connector.LVServer;
import com.sapmarkets.bam.jmxadapter.CCMSTemplateController;
import com.sapmarkets.bam.jmxadapter.CCMSTemplateIndex;
import com.sapmarkets.bam.jmxadapter.PatternValueDefinition;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CCMSTemplate {
    private String dirForTemplates;
    private Properties mTemplateData = new Properties();
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmxadapter$CCMSTemplate == null ? (class$com$sapmarkets$bam$jmxadapter$CCMSTemplate = CCMSTemplate.class$("com.sapmarkets.bam.jmxadapter.CCMSTemplate")) : class$com$sapmarkets$bam$jmxadapter$CCMSTemplate);
    private static final Tracer TRACER = new Tracer(class$com$sapmarkets$bam$jmxadapter$CCMSTemplate == null ? (class$com$sapmarkets$bam$jmxadapter$CCMSTemplate = CCMSTemplate.class$("com.sapmarkets.bam.jmxadapter.CCMSTemplate")) : class$com$sapmarkets$bam$jmxadapter$CCMSTemplate);
    private Map mPatternValueMap;
    private File mLogFile;
    private boolean templateGeneratedFlag = false;
    private String mOffset = "";
    private LVServer mLVServer;
    String mHostname;
    boolean mMultipleFiles = false;
    PatternValueDefinition mPatternValueDefinition = PatternValueDefinition.getPatternValueDefinition();
    private String mServerID;
    private String mClusterNodeID;
    private String mInstanceID;
    private String mNodeType;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$CCMSTemplate;

    public CCMSTemplate(IReadableLog log, String logType) {
        if (log != null && this.mPatternValueDefinition.isCCMSGenerationON()) {
            String absolutePath = null;
            String dirname = ".";
            try {
                dirname = log.getParent() == null ? "." : log.getParent();
            }
            catch (NullPointerException nullPointer) {
                dirname = ".";
            }
            String tempFileName = log.getPattern();
            if (tempFileName == null) {
                LOG.logError("CCMSTemplate generation for log  failed: pattern is NULL!");
                return;
            }
            tempFileName = tempFileName.substring(tempFileName.lastIndexOf(File.separator) + 1);
            tempFileName = tempFileName.substring(tempFileName.lastIndexOf("/") + 1);
            char[] newChars = this.replacePatternsWithwildChars(tempFileName);
            if (log.getCnt() > 1) {
                this.mMultipleFiles = true;
                tempFileName = new String(newChars).trim();
            } else {
                tempFileName = new String(newChars);
            }
            absolutePath = new File(dirname, tempFileName).getAbsolutePath();
            this.mOffset = this.getOffset(dirname);
            if (this.mPatternValueDefinition.shouldGenerateCCMSTemplate(absolutePath)) {
                Map patternValue = this.mPatternValueDefinition.getPropertiesForAReader(logType);
                this.generateTheTemplateData(absolutePath, this.mMultipleFiles, patternValue);
                this.templateGeneratedFlag = true;
                try {
                    CCMSTemplateController.getCommandQueueForCCMS().put((Object)this);
                }
                catch (InterruptedException interEx) {
                    LOG.logWarning("The thread for the command queue was interrupter.");
                    throw new BAMRuntimeException(LOG.getLocation(), interEx);
                }
                catch (NoClassDefFoundError noClass) {
                    LOG.logWarning("Class com.sap.engine.lib.util.concurrent.Channel not found. Plase make sure iq-lib.jar is available.No CCMS Templates will be generated as a result.");
                }
            }
        }
    }

    private void generateTheTemplateData(String absolutePath, boolean isMultipleFiles, Map patternValueMap) {
        this.mPatternValueMap = patternValueMap;
        this.dirForTemplates = this.mPatternValueDefinition.getTemplateDestination();
        File destination = new File(this.dirForTemplates);
        if (!destination.exists() && destination.mkdir()) {
            TRACER.traceInfo("Created directory for ccms templates: [" + destination + "]");
        }
        this.mLogFile = new File(absolutePath);
        String templateFileName = this.mLogFile.getName();
        if (this.mMultipleFiles) {
            StringBuffer tempFileName = new StringBuffer(templateFileName);
            tempFileName.insert(templateFileName.lastIndexOf(46), ".*");
            templateFileName = tempFileName.toString();
        }
        ((Hashtable)this.mTemplateData).put("FILENAME", templateFileName);
        ((Hashtable)this.mTemplateData).put("DIRECTORY", this.mLogFile.getParent());
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.logException(e);
            throw new BAMRuntimeException(LOG.getLocation(), "Host name cannot be resolved", e);
        }
        this.mHostname = localAddress.getHostName();
        String mteClass = "Logs";
        if (this.mOffset != null && !this.mOffset.equals("")) {
            mteClass = mteClass + "_" + this.mOffset;
        }
        ((Hashtable)this.mTemplateData).put("MTE_CLASS", mteClass);
        if (isMultipleFiles) {
            ((Hashtable)this.mTemplateData).put("MONITORNEWESTFILE", new String("1"));
            ((Hashtable)this.mTemplateData).put("MONITOR_LAST_FILEMODIF", new String("1"));
        }
    }

    private void calculateServerID() {
        try {
            Object[] objectArray = LogViewer.lvServerLock;
            synchronized (objectArray) {
                this.mLVServer = LogViewer.getLVServer();
                while (this.mLVServer == null) {
                    LogViewer.lvServerLock.wait();
                    this.mLVServer = LogViewer.getLVServer();
                }
            }
        }
        catch (InterruptedException exception) {
            LOG.logError("exception-" + exception.getMessage());
        }
        if (!this.mLVServer.isStandalone()) {
            ServiceContext serviceContext = ((J2EELVServer)this.mLVServer).getServiceContext();
            this.mClusterNodeID = new Integer(this.mLVServer.getClusterNodeID()).toString();
            this.mInstanceID = new Integer(this.mLVServer.getClusterNodeID() / 100).toString();
            ConfigurationHandler cfgHandler = null;
            try {
                cfgHandler = serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
            }
            catch (ConfigurationException exception1) {
                LOG.logWarning("Error while getting configuration " + (Object)((Object)exception1));
            }
            Configuration instancePropsCfg = null;
            PropertySheet propertySheet = null;
            try {
                instancePropsCfg = cfgHandler.openConfiguration("cluster_data/instance.properties.ID" + this.mInstanceID, 0);
                propertySheet = instancePropsCfg.getPropertySheetInterface();
                String nodeType = propertySheet.getProperties().getProperty("ID" + this.mClusterNodeID + ".Name");
                this.mNodeType = this.getResolvedNodeType(nodeType);
            }
            catch (NameNotFoundException exception2) {
                LOG.logWarning("Error while getting configuration " + (Object)((Object)exception2));
            }
            catch (ConfigurationLockedException exception2) {
                LOG.logWarning("Error while getting configuration " + (Object)((Object)exception2));
            }
            catch (ConfigurationException exception2) {
                LOG.logWarning("Error while getting configuration " + (Object)((Object)exception2));
            }
            String intermediatoryMonitorContext = this.mPatternValueDefinition.getSystemName() + "_" + this.mHostname + "_" + this.mPatternValueDefinition.getNodeInstance() + "_" + this.mNodeType;
            int intermediatoryLength = intermediatoryMonitorContext.length();
            String usefulOffset = "";
            usefulOffset = this.mOffset.length() > 38 - intermediatoryLength ? " " + this.mOffset.substring(0, 38 - intermediatoryLength) : (this.mOffset.length() > 0 ? " " + this.mOffset : "");
            String monitorContext = intermediatoryMonitorContext + usefulOffset;
            if (monitorContext.length() > 40) {
                monitorContext = monitorContext.substring(monitorContext.length() - 40, monitorContext.length());
            }
            if (monitorContext.indexOf(" ") != -1) {
                monitorContext = "\"" + monitorContext + "\"";
            }
            ((Hashtable)this.mTemplateData).put("MONITOR_CONTEXT", monitorContext);
        }
    }

    /*
     * Loose catch block
     */
    public void writeTemplate() {
        this.calculateServerID();
        String lineSeparator = System.getProperty("line.separator");
        FileOutputStream outStream = null;
        String tempFileName = this.mLogFile.getName();
        String filenameWithoutExtension = tempFileName.lastIndexOf(".") != -1 ? tempFileName.substring(0, tempFileName.lastIndexOf(".")) : tempFileName;
        String filename = this.dirForTemplates + File.separator + this.mHostname + "_" + this.mPatternValueDefinition.getSystemName() + "_" + this.mPatternValueDefinition.getNodeInstance() + "_" + this.mNodeType + "_" + (this.mOffset.length() > 0 ? this.mOffset + "_" : "") + filenameWithoutExtension + "_" + "logmon" + ".ini";
        File templateFile = new File(filename);
        boolean templateFileExists = CCMSTemplateIndex.doesTemplateExistForFile(templateFile.getParent(), this.mLogFile);
        if (!templateFileExists) {
            CCMSTemplateIndex.addToCCMSTemplateIndex(this.mLogFile, templateFile);
            if (!templateFile.getParentFile().exists()) {
                templateFile.getParentFile().mkdir();
            }
            try {
                outStream = new FileOutputStream(templateFile);
            }
            catch (FileNotFoundException flEx) {
                LOG.logWarning("INVALID_FILE" + flEx.getMessage());
                throw new BAMRuntimeException(LOG.getLocation(), "INVALID_FILE", new Object[]{filename});
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outStream));
            out.write("LOGFILE_TEMPLATE" + lineSeparator);
            Iterator keyItr = ((Hashtable)this.mTemplateData).keySet().iterator();
            while (keyItr.hasNext()) {
                String key = (String)keyItr.next();
                String value = (String)((Hashtable)this.mTemplateData).get(key);
                out.write(key + "=" + value + lineSeparator);
                ((Writer)out).flush();
            }
            keyItr = this.mPatternValueMap.keySet().iterator();
            int suffixCounter = 0;
            out.write(lineSeparator);
            while (keyItr.hasNext()) {
                String key = (String)keyItr.next();
                String value = (String)this.mPatternValueMap.get(key);
                out.write("PATTERN_" + suffixCounter + "=" + key + lineSeparator);
                out.write("VALUE_" + suffixCounter + "=" + value + lineSeparator);
                ((Writer)out).flush();
                ++suffixCounter;
            }
            out.write("." + lineSeparator);
            ((Writer)out).flush();
            TRACER.traceInfo("written ccms file " + filename);
            Object var14_16 = null;
            try {
                ((Writer)out).close();
            }
            catch (IOException ioEx) {
                LOG.logWarning("INVALID_FILE");
                throw new BAMRuntimeException(LOG.getLocation(), "INVALID_FILE", new Object[]{filename});
            }
            {
                catch (IOException ioEx) {
                    LOG.logWarning("INVALID_FILE[" + filename + "]");
                    throw new BAMRuntimeException(LOG.getLocation(), "INVALID_FILE", new Object[]{filename});
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    ((Writer)out).close();
                }
                catch (IOException ioEx) {
                    LOG.logWarning("INVALID_FILE");
                    throw new BAMRuntimeException(LOG.getLocation(), "INVALID_FILE", new Object[]{filename});
                }
                throw throwable;
            }
        }
    }

    private char[] replacePatternsWithwildChars(String filename) {
        char[] replacedChars = new char[filename.length()];
        int i = 0;
        int newCharCounter = 0;
        while (i < filename.length()) {
            if (filename.charAt(i) == '%') {
                replacedChars[newCharCounter++] = 42;
                ++i;
            } else {
                replacedChars[newCharCounter++] = filename.charAt(i);
            }
            ++i;
        }
        return replacedChars;
    }

    public boolean generatedTemplate() {
        return this.templateGeneratedFlag;
    }

    private String getResolvedNodeType(String nodeType) {
        String ints = "";
        String resolvedType = "";
        if (nodeType.toLowerCase().startsWith("server")) {
            ints = nodeType.toLowerCase().substring(6);
            resolvedType = ints.length() == 1 ? "S0" + ints : "S" + ints;
        } else {
            ints = nodeType.toLowerCase().substring(10);
            resolvedType = "dsp" + ints;
        }
        return resolvedType;
    }

    private String getOffset(String dirname) {
        String offset = "";
        String newOffset = "";
        if (dirname.indexOf("log" + File.separator) != -1) {
            offset = dirname.substring(dirname.lastIndexOf("log" + File.separator) + 4);
            newOffset = offset.replace(File.separatorChar, '_');
        }
        return newOffset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

