/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmxadapter;

import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sapmarkets.bam.application.LogId;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewer;
import com.sapmarkets.bam.jmx.connector.J2EELVServer;
import com.sapmarkets.bam.jmxadapter.AbstractLogMBean;
import com.sapmarkets.bam.jmxadapter.ArchiveInfo;
import com.sapmarkets.bam.jmxadapter.CCMSTemplate;
import com.sapmarkets.bam.jmxadapter.CCMSTemplateController;
import com.sapmarkets.bam.jmxadapter.sapjlog.AbstractFileLogHandler;
import com.sapmarkets.bam.logcontroller.AbstractBAMLogReader;
import com.sapmarkets.bam.logcontroller.BAMLogReader;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class AbstractLog
implements AbstractLogMBean,
NotificationBroadcaster {
    private static final Tracer TRACE__ = new Tracer(class$com$sapmarkets$bam$jmxadapter$AbstractLog == null ? (class$com$sapmarkets$bam$jmxadapter$AbstractLog = AbstractLog.class$("com.sapmarkets.bam.jmxadapter.AbstractLog")) : class$com$sapmarkets$bam$jmxadapter$AbstractLog);
    private static final Logger LOG__ = new Logger(class$com$sapmarkets$bam$jmxadapter$AbstractLog == null ? (class$com$sapmarkets$bam$jmxadapter$AbstractLog = AbstractLog.class$("com.sapmarkets.bam.jmxadapter.AbstractLog")) : class$com$sapmarkets$bam$jmxadapter$AbstractLog);
    public static final String CREATE_READABLELOG_NOTIFICATION = "sapjlog.readablelog.create";
    public static final String SET_SEVERITY_NOTIFICATION = "sapjlog.severity.set";
    public static final String SET_ENCODING_NOTIFICATION = "sapjlog.encoding.set";
    private static final MBeanNotificationInfo CREATE_READABLELOG_NOTIFICATION_INFO = new MBeanNotificationInfo(new String[]{"sapjlog.readablelog.create"}, (class$javax$management$Notification == null ? (class$javax$management$Notification = AbstractLog.class$("javax.management.Notification")) : class$javax$management$Notification).getName(), "Create ReadableLog Notification.");
    private static final MBeanNotificationInfo SET_SEVERITY_NOTIFICATION_INFO = new MBeanNotificationInfo(new String[]{"sapjlog.severity.set"}, (class$javax$management$Notification == null ? (class$javax$management$Notification = AbstractLog.class$("javax.management.Notification")) : class$javax$management$Notification).getName(), "Set Severity Notification.");
    private static final MBeanNotificationInfo SET_ENCODING_NOTIFICATION_INFO = new MBeanNotificationInfo(new String[]{"sapjlog.encoding.set"}, (class$javax$management$Notification == null ? (class$javax$management$Notification = AbstractLog.class$("javax.management.Notification")) : class$javax$management$Notification).getName(), "Set Encoding Notification.");
    private User user = User.NOBODY;
    private BAMLogReader mBAMLogReader;
    private CCMSTemplate mCCMSTemplate;
    private NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private static Map mAttributeDescriptions = new HashMap(10);
    private long notificationSequence = 0L;
    protected AbstractFileLogHandler handler_;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmxadapter$AbstractLog;
    static /* synthetic */ Class class$javax$management$Notification;

    public void init(BAMLogReader bamLogReader) {
        this.mBAMLogReader = bamLogReader;
        TRACE__.traceInfo("Will attempt to instantiate a CCMSTemplate");
        this.mCCMSTemplate = new CCMSTemplate(this.mBAMLogReader.getLog(), this.mBAMLogReader.getLogType());
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public void closeLog() {
        ((AbstractBAMLogReader)this.mBAMLogReader).getLog().close();
    }

    public String getReadableLogPath() {
        return ((AbstractBAMLogReader)this.mBAMLogReader).getLog().getPath();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{CREATE_READABLELOG_NOTIFICATION_INFO, SET_SEVERITY_NOTIFICATION_INFO, SET_ENCODING_NOTIFICATION_INFO};
    }

    public Map getAttributeDescriptions() {
        return mAttributeDescriptions;
    }

    public BAMLogReader createBAMLogReader(LogId logId) {
        return this.mBAMLogReader.createBAMLogReader(logId);
    }

    public FormatterType getFormatterType() {
        try {
            return this.mBAMLogReader.getFormatterType();
        }
        catch (NoClassDefFoundError e) {
            throw new BAMRuntimeException(LOG__.getLocation(), e);
        }
    }

    public String getSpecificLogType() {
        return this.mBAMLogReader.getLogType();
    }

    public int getFileCount() {
        return this.mBAMLogReader.getFileCount();
    }

    public int getFileLimit() {
        return this.mBAMLogReader.getFileLimit();
    }

    public String getLogDisplayName() {
        return this.mBAMLogReader.getLogDisplayName();
    }

    public String getLogName() {
        return this.mBAMLogReader.getLogName();
    }

    public String getAbsoluteLogPattern() {
        return this.mBAMLogReader.getAbsoluteLogPattern();
    }

    public String getSeverity() {
        return this.mBAMLogReader.getSeverity();
    }

    public void setSeverity(String newSev) throws IllegalArgumentException {
        this.mBAMLogReader.setSeverity(newSev);
        Notification notification = new Notification(SET_SEVERITY_NOTIFICATION, (Object)this, ++this.notificationSequence, "Severity set");
        this.broadcaster.sendNotification(notification);
    }

    public String getEncoding() {
        return this.mBAMLogReader.getEncoding();
    }

    public void setEncoding(String newEnc) {
        this.mBAMLogReader.setEncoding(newEnc);
        Notification notification = new Notification(SET_SEVERITY_NOTIFICATION, (Object)this, this.notificationSequence, "Encoding set");
        this.broadcaster.sendNotification(notification);
    }

    public User getUser() {
        return this.user;
    }

    public void changeUser(User user) {
        this.user = user;
    }

    public int getNumberOfLogRecordsWritten() {
        return this.mBAMLogReader.getNumberOfLogRecordsWritten();
    }

    public long getLastModified() {
        return this.mBAMLogReader.getLastModified();
    }

    public boolean getCCMStemplateGeneratedFlag() {
        return this.mCCMSTemplate.generatedTemplate();
    }

    public boolean isLoggingAttributesEditable() {
        return this.mBAMLogReader.areLoggingAttributesEditable();
    }

    public long getLength() {
        return this.mBAMLogReader.length();
    }

    public void createUnconditionalCCMSTemplate(String destinationDirectory) {
        try {
            CCMSTemplateController.getCommandQueueForCCMS().put((Object)new CCMSTemplate(this.mBAMLogReader.getLog(), this.mBAMLogReader.getLogType()));
        }
        catch (InterruptedException interEx) {
            throw new BAMRuntimeException(Location.getLocation((String)"AbstractLog"), interEx);
        }
    }

    private LogRegistrationResult registerArchive(ArchiveInfo archiveInfo) {
        String archivePath = archiveInfo.getArchiveDirecotry();
        String archiveFileName = archiveInfo.getArchiveFileName();
        String archiveExtension = archiveInfo.getArchiveExtension();
        int archiveCount = archiveInfo.getArchiveSize();
        if (TRACE__.isInfoEnabled()) {
            TRACE__.traceInfo("Reading archive: " + archivePath + archiveFileName + ".%g." + archiveExtension + " with count: " + archiveCount);
        }
        IReadableLog log = AbstractBAMLogReader.createReadableLog(new FileLog(archivePath + archiveFileName + ".%g." + archiveExtension, Integer.MAX_VALUE, archiveCount));
        return this.handler_.registerArchiveLogMBean(log, true, LogTypeEnumeration.ARCHIVE_TYPE, archiveInfo);
    }

    protected ArchiveInfo getArchiveInfo(String tmpDir, String zippedArchiveName) throws ZipException, IOException {
        if (TRACE__.isInfoEnabled()) {
            TRACE__.traceInfo("Archive: tmpDir=" + tmpDir + " zippedArchiveName=" + zippedArchiveName);
        }
        ArchiveInfo archiveInfo = null;
        File zipPhysicalFile = new File(zippedArchiveName);
        if (TRACE__.isInfoEnabled()) {
            TRACE__.traceInfo("Archive: " + zipPhysicalFile.getAbsolutePath());
        }
        String zipDirectoryName = tmpDir + zippedArchiveName.replace(':', '~');
        File zipDirectory = new File(zipDirectoryName);
        if (zipPhysicalFile.exists()) {
            ZipFile zipFile = new ZipFile(zipPhysicalFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            if (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String archiveEntryFileName = entry.getName();
                int firstDot = archiveEntryFileName.indexOf(46);
                int secondDot = archiveEntryFileName.indexOf(46, firstDot + 1);
                String archiveName = archiveEntryFileName.substring(0, firstDot);
                String archiveExtension = archiveEntryFileName.substring(secondDot + 1);
                archiveInfo = new ArchiveInfo(zipDirectory + System.getProperty("file.separator"), archiveName, archiveExtension, zipPhysicalFile.lastModified(), zipPhysicalFile, zipFile.size());
            }
            zipFile.close();
            return archiveInfo;
        }
        LOG__.logError("Missing zip file from LogConfigurator: " + zippedArchiveName);
        return null;
    }

    protected Set getArchiveFileNames(String logFilePattern) {
        if (this.handler_ == null) {
            return new HashSet();
        }
        Set archiveDirectories = this.handler_.getArchiveDirectories(logFilePattern);
        if (LogViewer.getLVServer() instanceof J2EELVServer) {
            J2EELVServer lvServer = (J2EELVServer)LogViewer.getLVServer();
            LogConfigurator lc = (LogConfigurator)lvServer.getLogConfigurator();
            if (lc != null) {
                archiveDirectories.add(new String[]{lc.getArchiveLogDirectory(), logFilePattern});
            } else {
                LOG__.logWarning("LogConfigurator is not found. Make sure you have the latest log_configurator.jar");
            }
        }
        if (archiveDirectories == null) {
            return new HashSet();
        }
        HashSet<String> archiveNames = new HashSet<String>();
        Iterator itr = archiveDirectories.iterator();
        while (itr.hasNext()) {
            String[] archiveFileInfo = (String[])itr.next();
            String archiveDirectory = archiveFileInfo[0];
            String logRelativePattern = archiveFileInfo[1];
            String[] archiveFileNames = LogConfigurator.getArchiveFileNames((String)archiveDirectory, (String)logRelativePattern);
            if (TRACE__.isInfoEnabled()) {
                TRACE__.traceInfo("ArchiveDirectory: " + archiveDirectory);
                TRACE__.traceInfo("logRelativePattern: " + logRelativePattern);
                TRACE__.traceInfo("archiveFileNames: " + (archiveFileNames == null ? 0 : archiveFileNames.length));
            }
            if (archiveFileNames == null) continue;
            archiveNames.addAll(Arrays.asList(archiveFileNames));
        }
        return archiveNames;
    }

    protected Map getArchives(String logFilePattern) {
        Set archiveNames = this.getArchiveFileNames(logFilePattern);
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            tmpDir = ".";
        }
        HashMap<String, ArchiveInfo> archives = new HashMap<String, ArchiveInfo>();
        Iterator itr = archiveNames.iterator();
        while (itr.hasNext()) {
            String archiveName = (String)itr.next();
            try {
                ArchiveInfo archiveInfo = this.getArchiveInfo(tmpDir, archiveName);
                if (archiveInfo != null) {
                    archives.put(archiveInfo.getArchiveDirecotry(), archiveInfo);
                    continue;
                }
                LOG__.logError("Problem accessing archive zip [" + logFilePattern + "]");
            }
            catch (ZipException ex) {
                LOG__.logException(ex);
            }
            catch (IOException ex) {
                LOG__.logException(ex);
            }
        }
        return archives;
    }

    public List getArchives() {
        ArrayList<ObjectName> archiveLogs = new ArrayList<ObjectName>();
        Map archives = this.getArchives(this.getLogName());
        Iterator itr = archives.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry archiveEntry = itr.next();
            ArchiveInfo archiveInfo = (ArchiveInfo)archiveEntry.getValue();
            LogRegistrationResult result = this.registerArchive(archiveInfo);
            if (result.getStatus() != 0 && result.getStatus() != 1) continue;
            archiveLogs.add(result.getObjectName());
        }
        return archiveLogs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mAttributeDescriptions.put("Encoding", "Encoding setting of the log");
        mAttributeDescriptions.put("FormatterType", "Formatter type setting of the log");
        mAttributeDescriptions.put("LogName", "Log name");
        mAttributeDescriptions.put("LogPath", "Log path of the log");
        mAttributeDescriptions.put("Severity", "Severity setting of the Log\nPlease note that log entries that have\nalready be written are not affected.");
        mAttributeDescriptions.put("AttributeDescriptions", "Map of attribute name and it's description");
        mAttributeDescriptions.put("SpecificLogType", "This provides the specific log type of the bean - e.g. SAPJLog, etc..");
        mAttributeDescriptions.put("User", "The user who has added this log for monitoring.  If the log is added by the system, the ID of this user will be Nobody.");
        mAttributeDescriptions.put("CCMStemplateGeneratedFlag", "The boolean flag indicates if the ccms template for this log has been generated.");
        mAttributeDescriptions.put("Archives", "List of archives associated with the log");
        mAttributeDescriptions = Collections.unmodifiableMap(mAttributeDescriptions);
    }
}

