/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmx.connector.rmi;

import com.sapmarkets.bam.util.BAMConfigurationHandler;
import com.sapmarkets.bam.util.StreamGobbler;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RMIRegistryManager {
    private static RMIRegistryManager mInstance;
    private Map mProcesses = new HashMap();

    protected RMIRegistryManager() {
    }

    public static synchronized RMIRegistryManager getInstance() {
        if (mInstance == null) {
            mInstance = new RMIRegistryManager();
        }
        return mInstance;
    }

    public void startRegistry(int port) {
        String javaExec = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String className = "com.sapmarkets.bam.jmx.connector.rmi.RMIRegistryManager";
        String[] cmd = new String[]{javaExec, "-classpath", classpath, className, String.valueOf(port)};
        try {
            File logPath = new File(BAMConfigurationHandler.getConfigPath(), "logs");
            logPath.mkdir();
            File stdoutStream = new File(logPath, "stdout_registry_" + port + ".log");
            File stderrStream = new File(logPath, "stderr_registry_" + port + ".log");
            FileOutputStream outputStream = new FileOutputStream(stdoutStream);
            FileOutputStream errorStream = new FileOutputStream(stderrStream);
            Process process = Runtime.getRuntime().exec(cmd);
            Thread.sleep(2000L);
            Map map = this.mProcesses;
            synchronized (map) {
                this.mProcesses.put(new Integer(port), process);
            }
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), "Registry " + port + ".STDERR", errorStream);
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), "Registry " + port + ".STDOUT", outputStream);
            errorGobbler.start();
            outputGobbler.start();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public boolean killRegistry(int port) {
        Map map = this.mProcesses;
        synchronized (map) {
            Process process = (Process)this.mProcesses.get(new Integer(port));
            if (process == null) {
                boolean bl = false;
                return bl;
            }
            process.destroy();
            this.mProcesses.remove(process);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public void killAllRegistries() {
        Map map = this.mProcesses;
        synchronized (map) {
            Iterator itr = this.mProcesses.keySet().iterator();
            while (itr.hasNext()) {
                this.killRegistry((Integer)itr.next());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 1099;
        if (args.length != 0) {
            port = Integer.valueOf(args[0]);
        }
        LocateRegistry.createRegistry(port);
        System.out.println("RMI Registry started on port " + port + ".");
        while (true) {
            Thread.sleep(Long.MAX_VALUE);
        }
    }
}

