/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmx.connector.rmi;

import com.sapmarkets.bam.jmx.connector.rmi.NIServerSocketFactory;
import com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServer;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.rmi.PortableRemoteObject;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;

public class RMIConnectorServerImpl
implements RMIConnectorServer {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmx$connector$rmi$RMIConnectorServerImpl == null ? (class$com$sapmarkets$bam$jmx$connector$rmi$RMIConnectorServerImpl = RMIConnectorServerImpl.class$("com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServerImpl")) : class$com$sapmarkets$bam$jmx$connector$rmi$RMIConnectorServerImpl);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmx$connector$rmi$RMIConnectorServerImpl == null ? (class$com$sapmarkets$bam$jmx$connector$rmi$RMIConnectorServerImpl = RMIConnectorServerImpl.class$("com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServerImpl")) : class$com$sapmarkets$bam$jmx$connector$rmi$RMIConnectorServerImpl);
    public static int SERVER_ID = 168;
    private MBeanServer mMBServer;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmx$connector$rmi$RMIConnectorServerImpl;
    static /* synthetic */ Class class$javax$management$MBeanServer;

    public MBeanServer getMBeanServer() {
        return this.mMBServer;
    }

    public RMIConnectorServerImpl(MBeanServer server, boolean isStandalone, boolean useNI, int NIport) throws IOException {
        if (isStandalone) {
            if (useNI) {
                LOG.logInfo("Logviewer Standalone server is using NI and binding the RMIConnectorServer object to port " + NIport);
                RMISocketFactory.setSocketFactory(new NIServerSocketFactory());
                LiveRef liveref = new LiveRef(new ObjID(SERVER_ID), NIport);
                UnicastServerRef unicastserverref = new UnicastServerRef(liveref);
                unicastserverref.exportObject(this, null);
            } else {
                LOG.logInfo("Logviewer Standalone server is using standard RMI");
                UnicastRemoteObject.exportObject(this);
            }
        } else {
            PortableRemoteObject.exportObject((Remote)this);
        }
        if (server == null) {
            throw new BAMSysRuntimeException(LOG.getLocation(), "NULL_MBEAN_SERVER");
        }
        this.mMBServer = server;
    }

    private String getMBeanServerID() {
        try {
            ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            ObjectName serverDelegate = this.mMBServer.queryNames(objectName, null).iterator().next();
            return this.mMBServer.getAttribute(objectName, "MBeanServerId").toString();
        }
        catch (MalformedObjectNameException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
        catch (AttributeNotFoundException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG.getLocation(), "INVALID_MBEAN_SERVER_ID", ex);
        }
        catch (InstanceNotFoundException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
        catch (MBeanException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
        catch (ReflectionException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
    }

    public Object invoke(String methodName, Class[] signature, Object[] args) throws RemoteException, InvocationTargetException, IllegalAccessException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (methodName.equals("getMBeanServerID")) {
                return this.getMBeanServerID();
            }
            if (methodName.equals("invoke") && TRACE.isInfoEnabled()) {
                TRACE.traceInfo("Calling Method: " + args[0] + "->" + args[1]);
            }
            Method mbeanServerMethod = (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = RMIConnectorServerImpl.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getMethod(methodName, signature);
            Object obj = mbeanServerMethod.invoke((Object)this.mMBServer, args);
            if (methodName.equals("invoke") && TRACE.isInfoEnabled()) {
                TRACE.traceInfo("Finished calling method: " + args[0] + "->" + args[1]);
            }
            Thread.currentThread().setContextClassLoader(cl);
            return obj;
        }
        catch (NoSuchMethodException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG.getLocation(), "NO_SUCH_METHOD_DECLARATION", new Object[]{args[0], args[1]}, ex);
        }
        catch (InvocationTargetException ex) {
            LOG.logOriginalException(ex);
            throw ex;
        }
        catch (IllegalAccessException ex) {
            LOG.logOriginalException(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            LOG.logOriginalException(ex);
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

