/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmx.connector.rmi;

import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.jmx.connector.rmi.AbstractConnectorClient;
import com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServer;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ViewProperty;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.rmi.server.ObjID;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.tcp.TCPEndpoint;

public class NIConnectorClient
extends AbstractConnectorClient {
    private static final Logger LOGGER = new Logger(class$com$sapmarkets$bam$jmx$connector$rmi$NIConnectorClient == null ? (class$com$sapmarkets$bam$jmx$connector$rmi$NIConnectorClient = NIConnectorClient.class$("com.sapmarkets.bam.jmx.connector.rmi.NIConnectorClient")) : class$com$sapmarkets$bam$jmx$connector$rmi$NIConnectorClient);
    private static final Tracer TRACER = new Tracer(class$com$sapmarkets$bam$jmx$connector$rmi$NIConnectorClient == null ? (class$com$sapmarkets$bam$jmx$connector$rmi$NIConnectorClient = NIConnectorClient.class$("com.sapmarkets.bam.jmx.connector.rmi.NIConnectorClient")) : class$com$sapmarkets$bam$jmx$connector$rmi$NIConnectorClient);
    public static int SERVER_ID = 168;
    private String routerString;
    private String connectionTimeout;
    private int port;
    private String hostname;
    private String protocol;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmx$connector$rmi$NIConnectorClient;
    static /* synthetic */ Class class$java$rmi$server$RemoteRef;

    public NIConnectorClient(HostDescriptor hd) throws NamingException, IOException {
        Properties props = new Properties();
        ((Hashtable)props).put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        ((Hashtable)props).put("java.naming.provider.url", "rmi://" + hd.getConnectionURL());
        if (hd.getUser() != null && hd.getUser().length() != 0) {
            ((Hashtable)props).put("java.naming.security.principal", hd.getUser());
            if (hd.getPassword() != null) {
                ((Hashtable)props).put("java.naming.security.credentials", hd.getPassword());
            }
        }
        ((Hashtable)props).put("NI_ROUTER_STRING", NIConnectorClient.getNonNullString(hd.getRouterString()));
        ((Hashtable)props).put("PROTOCOL", NIConnectorClient.getNonNullString(hd.getProtocol().toString()));
        ((Hashtable)props).put("HOSTNAME", NIConnectorClient.getNonNullString(hd.getHostName()));
        ((Hashtable)props).put("PORT", NIConnectorClient.getNonNullString(hd.getPortNumber()));
        this.init(props);
        this.initConnectorThreads();
    }

    private static String getNonNullString(String s) {
        return s == null ? "" : s;
    }

    protected void init(Properties props) throws IOException {
        super.init(props);
        this.initPropsForNI(props);
        if (this.hostname != null && this.hostname.length() > 0 && this.port > 0) {
            if (this.connectionTimeout == null) {
                this.connectionTimeout = "0";
            }
            TRACER.traceInfo("Setting connection timeout for NI to " + this.connectionTimeout);
            System.setProperty("sun.rmi.transport.connectionTimeout", this.connectionTimeout);
            AbstractConnectorClient.clientSocketFactory.setRouterString(this.routerString);
            TCPEndpoint tcpendpoint = new TCPEndpoint(this.hostname, this.port);
            LiveRef liveref = new LiveRef(new ObjID(SERVER_ID), tcpendpoint, false);
            try {
                Class<?> serverClass = Class.forName("com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServerImpl_Stub");
                Constructor<?> ctor = serverClass.getConstructor(class$java$rmi$server$RemoteRef == null ? (class$java$rmi$server$RemoteRef = NIConnectorClient.class$("java.rmi.server.RemoteRef")) : class$java$rmi$server$RemoteRef);
                this.mBServer = (RMIConnectorServer)ctor.newInstance(new UnicastRef(liveref));
            }
            catch (Exception ex) {
                throw new BAMRuntimeException(LOGGER.getLocation(), ex);
            }
        }
    }

    private void initPropsForNI(Properties props) {
        this.hostname = props.getProperty("HOSTNAME");
        ViewProperty viewProperty = ViewProperty.getInstance();
        this.connectionTimeout = viewProperty.getProperty(ViewProperty.CONNECTION_TIMEOUT);
        this.port = 1099;
        try {
            this.port = Integer.parseInt(props.getProperty("PORT"));
        }
        catch (NumberFormatException ex) {
            LOGGER.logException(ex);
            LOGGER.logError("The NI port is not configured correctly! Please modify the NI_PORT property in LogviewerServer.properties");
        }
        this.protocol = props.getProperty("PROTOCOL");
        if (this.protocol != null && this.protocol.equalsIgnoreCase("NI/Standalone")) {
            TRACER.traceInfo("Desired connection protocol is NI");
            if (this.port <= 0 || this.hostname == null || this.hostname.length() <= 0) {
                LOGGER.logWarning("Desired NI connection is not possible, because either hostname, routerstring or port is not set up correct! [hostname:" + this.hostname + "] [routerString:" + this.routerString + "] [port:" + this.port + "]");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

